/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.block.FurnitureEntityBlock;
import com.mrcrayfish.furniture.refurbished.block.MetalType;
import com.mrcrayfish.furniture.refurbished.blockentity.CeilingFanBlockEntity;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CeilingFanBlock
extends FurnitureEntityBlock
implements BlockTagSupplier {
    private static final MapCodec<CeilingFanBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)WoodType.CODEC.fieldOf("wood_type").forGetter(block -> block.woodType), (App)MetalType.CODEC.fieldOf("metal_type").forGetter(block -> block.metalType), (App)CeilingFanBlock.propertiesCodec()).apply((Applicative)builder, CeilingFanBlock::new));
    private final WoodType woodType;
    private final MetalType metalType;

    public CeilingFanBlock(WoodType woodType, MetalType metalType, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
        this.woodType = woodType;
        this.metalType = metalType;
    }

    public WoodType getWoodType() {
        return this.woodType;
    }

    public MetalType getMetalType() {
        return this.metalType;
    }

    protected MapCodec<CeilingFanBlock> codec() {
        return CODEC;
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape ceilingShape = Block.box((double)5.0, (double)7.5, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
        VoxelShape wallShape = Block.box((double)7.5, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
        VoxelShape floorShape = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.5, (double)11.0);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, state -> switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.UP -> ceilingShape;
            case Direction.DOWN -> floorShape;
            default -> VoxelShapeHelper.rotateHorizontally(wallShape, (Direction)state.getValue((Property)FACING));
        })));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite());
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)LIT) == false)), 3);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{POWERED});
        builder.add(new Property[]{LIT});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CeilingFanBlockEntity(pos, state);
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.MINEABLE_WITH_PICKAXE);
    }

    public static int light(BlockState state) {
        return (Boolean)state.getValue((Property)POWERED) != false && (Boolean)state.getValue((Property)LIT) != false ? 15 : 0;
    }
}

