/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.core.ModTags;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.entity.Seat;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChairBlock
extends FurnitureHorizontalBlock
implements BlockTagSupplier {
    private static final MapCodec<ChairBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)WoodType.CODEC.fieldOf("wood_type").forGetter(block -> block.type), (App)ChairBlock.propertiesCodec()).apply((Applicative)builder, ChairBlock::new));
    public static final BooleanProperty TUCKED = BooleanProperty.create((String)"tucked");
    private final WoodType type;

    public ChairBlock(WoodType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH)).setValue((Property)TUCKED, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public WoodType getWoodType() {
        return this.type;
    }

    protected MapCodec<ChairBlock> codec() {
        return CODEC;
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape backrestShape = Block.box((double)12.0, (double)10.0, (double)2.0, (double)14.0, (double)20.0, (double)14.0);
        VoxelShape seatShape = Block.box((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
        VoxelShape backLeftLegShape = Shapes.box((double)0.75, (double)0.0, (double)0.75, (double)0.875, (double)0.5, (double)0.875);
        VoxelShape backRightLegShape = Shapes.box((double)0.75, (double)0.0, (double)0.125, (double)0.875, (double)0.5, (double)0.25);
        VoxelShape frontLeftLegShape = Shapes.box((double)0.125, (double)0.0, (double)0.75, (double)0.25, (double)0.5, (double)0.875);
        VoxelShape frontRightLegShape = Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.25, (double)0.5, (double)0.25);
        VoxelShape chairShape = VoxelShapeHelper.combine(List.of(backrestShape, seatShape, backLeftLegShape, backRightLegShape, frontLeftLegShape, frontRightLegShape));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            VoxelShape rotatedChairShape = VoxelShapeHelper.rotateHorizontally(chairShape, direction);
            if (((Boolean)state.getValue((Property)TUCKED)).booleanValue()) {
                rotatedChairShape = rotatedChairShape.move(-0.5 * (double)direction.getStepX(), 0.0, -0.5 * (double)direction.getStepZ());
            }
            builder.put((Object)state, (Object)rotatedChairShape);
        }
        return builder.build();
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighbourBlock, BlockPos neighbourPos, boolean $$5) {
        if (!this.canTuck(state, level, pos) && ((Boolean)state.getValue((Property)TUCKED)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)TUCKED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (player.isCrouching() && Seat.availableAt(level, pos) && this.canTuck(state, level, pos)) {
            level.playSound(null, pos, (SoundEvent)ModSounds.BLOCK_CHAIR_SLIDE.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.random.nextFloat());
            level.setBlock(pos, (BlockState)state.setValue((Property)TUCKED, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)TUCKED) == false)), 3);
            return InteractionResult.SUCCESS;
        }
        if (!((Boolean)state.getValue((Property)TUCKED)).booleanValue() && Seat.sit(player, pos, Utils.pixels(10.0), ((Direction)state.getValue((Property)DIRECTION)).getOpposite())) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TUCKED});
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.MINEABLE_WITH_AXE);
    }

    protected boolean canTuck(BlockState state, Level level, BlockPos pos) {
        BlockPos front = pos.relative(((Direction)state.getValue((Property)DIRECTION)).getOpposite());
        return level.getBlockState(front).is(ModTags.Blocks.TUCKABLE);
    }
}

