/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.FryingPanBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IHeatingSource;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.core.ModParticleTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FryingPanBlock
extends FurnitureHorizontalEntityBlock
implements BlockTagSupplier {
    private static final MapCodec<FryingPanBlock> CODEC = FryingPanBlock.simpleCodec(FryingPanBlock::new);

    public FryingPanBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<FryingPanBlock> codec() {
        return CODEC;
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape baseShape = Block.box((double)2.5, (double)1.0, (double)2.5, (double)13.5, (double)4.0, (double)13.5);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, o -> baseShape)));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Vec3 clickVec = context.getClickLocation().subtract(Vec3.atLowerCornerOf((Vec3i)pos));
        Direction forward = context.getHorizontalDirection();
        Direction right = forward.getClockWise();
        double side = right.getAxis().choose(clickVec.x, 0.0, clickVec.z);
        side = Math.abs((double)Math.min(right.getAxisDirection().getStep(), 0) + side);
        forward = side < 0.5 ? forward.getOpposite() : forward;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)DIRECTION, (Comparable)forward)).setValue((Property)LIT, (Comparable)Boolean.valueOf(this.isHeated(context.getLevel(), pos)));
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && result.getDirection() != Direction.DOWN && (blockEntity = level.getBlockEntity(pos)) instanceof FryingPanBlockEntity) {
            FryingPanBlockEntity fryingPan = (FryingPanBlockEntity)blockEntity;
            ItemStack stack = player.getItemInHand(hand);
            if (stack.is((Item)ModItems.SPATULA.get())) {
                fryingPan.flipItem();
                FryingPanBlock.playSpatulaScoopSound(level, pos, 0.1875);
            } else if (!stack.isEmpty()) {
                if (fryingPan.placeContents(level, stack, player.getDirection().get2DDataValue()) && !player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
            } else {
                fryingPan.removeContents();
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        return reader.getBlockEntity(pos.below()) instanceof IHeatingSource;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LIT});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FryingPanBlockEntity(pos, state);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource source) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FryingPanBlockEntity) {
            double posZ;
            double posY;
            FryingPanBlockEntity fryingPan = (FryingPanBlockEntity)blockEntity;
            if (!fryingPan.getItem(0).isEmpty() && fryingPan.isFlippingNeeded()) {
                double posX = (double)pos.getX() + 0.35 + 0.3 * level.random.nextDouble();
                posY = (double)pos.getY() + 0.15;
                posZ = (double)pos.getZ() + 0.35 + 0.3 * level.random.nextDouble();
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.125, (double)pos.getZ() + 0.5, 0.0, 0.05, 0.0);
                fryingPan.spawnSteam(level, posX, posY, posZ);
            }
            if (((Boolean)state.getValue((Property)LIT)).booleanValue() && fryingPan.getItem(0).isEmpty() && source.nextInt(2) == 0) {
                double posX = (double)pos.getX() + 0.3 + 0.4 * level.random.nextDouble();
                posY = (double)pos.getY() + 0.15;
                posZ = (double)pos.getZ() + 0.3 + 0.4 * level.random.nextDouble();
                level.addParticle((ParticleOptions)ModParticleTypes.STEAM.get(), posX, posY, posZ, 0.0, 0.05, 0.0);
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide()) {
            return FryingPanBlock.createTicker(type, (BlockEntityType)ModBlockEntities.FRYING_PAN.get(), FryingPanBlockEntity::clientTick);
        }
        return null;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos $$4, boolean $$5) {
        if (!((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            if (this.isHeated(level, pos)) {
                level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
            }
        } else if (!this.isHeated(level, pos)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    private boolean isHeated(Level level, BlockPos pos) {
        IHeatingSource source;
        BlockEntity blockEntity;
        BlockPos belowPos = pos.below();
        return level != null && (blockEntity = level.getBlockEntity(belowPos)) instanceof IHeatingSource && (source = (IHeatingSource)blockEntity).isHeating();
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.MINEABLE_WITH_PICKAXE);
    }

    public static void playSpatulaScoopSound(Level level, BlockPos pos, double offset) {
        Vec3 vec = Vec3.atBottomCenterOf((Vec3i)pos);
        level.playSound(null, vec.x, vec.y + offset, vec.z, (SoundEvent)ModSounds.ITEM_SPATULA_SCOOP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

