/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.MailboxBlockEntity;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryService;
import com.mrcrayfish.furniture.refurbished.mail.Mailbox;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageNameMailbox;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MailboxBlock
extends FurnitureHorizontalEntityBlock
implements BlockTagSupplier {
    private static final MapCodec<MailboxBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)WoodType.CODEC.fieldOf("wood_type").forGetter(block -> block.type), (App)MailboxBlock.propertiesCodec()).apply((Applicative)builder, MailboxBlock::new));
    private final WoodType type;

    public MailboxBlock(WoodType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH)).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public WoodType getWoodType() {
        return this.type;
    }

    protected MapCodec<MailboxBlock> codec() {
        return CODEC;
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape standShape = Block.box((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)11.0, (double)9.5);
        VoxelShape boxShape = Block.box((double)3.0, (double)11.0, (double)3.0, (double)13.0, (double)20.0, (double)13.0);
        VoxelShape joinedShape = Shapes.joinUnoptimized((VoxelShape)standShape, (VoxelShape)boxShape, (BooleanOp)BooleanOp.OR).optimize();
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, o -> joinedShape)));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof MailboxBlockEntity) {
                MailboxBlockEntity mailbox = (MailboxBlockEntity)blockEntity;
                mailbox.getMailbox().owner().setValue((Object)player.getUUID());
                DeliveryService.get(((ServerLevel)level).getServer()).ifPresent(service -> service.markMailboxAsPendingName((Player)player, level, pos));
            }
            Network.getPlay().sendToPlayer(() -> player, (Object)new MessageNameMailbox(pos));
        }
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && !state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof MailboxBlockEntity) {
            MailboxBlockEntity mailbox = (MailboxBlockEntity)blockEntity;
            Optional.ofNullable(mailbox.getMailbox()).ifPresent(Mailbox::remove);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof MailboxBlockEntity) {
            Mailbox mailbox;
            MailboxBlockEntity blockEntity2 = (MailboxBlockEntity)blockEntity;
            if (!DeliveryService.isDeliverableDimension(level)) {
                ((ServerPlayer)player).sendSystemMessage((Component)Utils.translation("gui", "invalid_mailbox", new Object[0]), true);
                return InteractionResult.SUCCESS;
            }
            if (((Boolean)state.getValue((Property)ENABLED)).booleanValue()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)ENABLED, (Comparable)Boolean.valueOf(false)), 3);
            }
            if ((mailbox = blockEntity2.getMailbox()) != null && !mailbox.hasOwner()) {
                mailbox.setOwner(player.getUUID());
            }
            player.openMenu((MenuProvider)blockEntity2);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ENABLED});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MailboxBlockEntity(pos, state);
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.MINEABLE_WITH_AXE);
    }
}

