/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.block.BasinBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.IWaterTap;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.IFluidContainerBlock;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModParticleTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWaterTapAnimation;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class BasinBlockEntity
extends BlockEntity
implements IFluidContainerBlock,
IWaterTap {
    protected final FluidContainer tank;
    private int animationTime;

    public BasinBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.BASIN.get(), pos, state);
    }

    public BasinBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tank = FluidContainer.create((Long)Config.SERVER.basin.fluidCapacity.get(), container -> {
            this.setChanged();
            container.sync(this);
        });
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    @Override
    public FluidContainer getFluidContainer() {
        return this.tank;
    }

    public InteractionResult interact(Player player, InteractionHand hand, BlockHitResult result) {
        Item item;
        ItemStack heldItem = player.getItemInHand(hand);
        if (((Boolean)Config.SERVER.basin.dispenseWater.get()).booleanValue() && heldItem.isEmpty() && result.getDirection() != Direction.DOWN) {
            Pair<Fluid, Long> drained;
            long filled;
            if ((this.tank.isEmpty() || this.tank.getStoredFluid().isSame((Fluid)Fluids.WATER)) && (filled = this.tank.push((Fluid)Fluids.WATER, FluidContainer.BUCKET_CAPACITY, false)) > 0L) {
                Network.getPlay().sendToTrackingBlockEntity(() -> this, (Object)new MessageWaterTapAnimation(this.worldPosition));
                Objects.requireNonNull(this.level).playSound(null, this.worldPosition, (SoundEvent)ModSounds.BLOCK_KITCHEN_SINK_FILL.get(), SoundSource.BLOCKS);
                return InteractionResult.SUCCESS;
            }
            if (this.tank.getStoredAmount() >= FluidContainer.BUCKET_CAPACITY && this.tank.getStoredFluid().isSame((Fluid)Fluids.LAVA) && (Long)(drained = this.tank.pull(FluidContainer.BUCKET_CAPACITY, true)).right() == FluidContainer.BUCKET_CAPACITY) {
                this.tank.pull(FluidContainer.BUCKET_CAPACITY, false);
                Vec3 pos = Vec3.atBottomCenterOf((Vec3i)this.worldPosition).add(0.0, 1.0, 0.0);
                Level level = Objects.requireNonNull(this.level);
                ItemEntity entity = new ItemEntity(level, pos.x, pos.y, pos.z, new ItemStack((ItemLike)Blocks.OBSIDIAN));
                entity.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)entity);
                level.playSound(null, this.worldPosition, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS);
                level.levelEvent(1501, this.worldPosition, 0);
                Network.getPlay().sendToTrackingBlockEntity(() -> this, (Object)new MessageWaterTapAnimation(this.worldPosition));
                return InteractionResult.SUCCESS;
            }
        }
        if ((item = heldItem.getItem()) == Items.GLASS_BOTTLE && !this.tank.isEmpty() && this.tank.getStoredFluid().isSame((Fluid)Fluids.WATER)) {
            this.tank.pull(FluidContainer.BUCKET_CAPACITY, false);
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)heldItem, (Player)player, (ItemStack)PotionUtils.setPotion((ItemStack)new ItemStack((ItemLike)Items.POTION), (Potion)Potions.WATER)));
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            player.level().playSound(null, this.worldPosition, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            player.level().gameEvent(null, GameEvent.FLUID_PICKUP, this.worldPosition);
            return InteractionResult.SUCCESS;
        }
        return Services.FLUID.performInteractionWithBlock(player, hand, this.getLevel(), this.getBlockPos(), result.getDirection());
    }

    @Override
    public void playWaterAnimation() {
        this.animationTime = 4;
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BasinBlockEntity basin) {
        if (basin.animationTime > 0) {
            Vec3 tap = Vec3.atBottomCenterOf((Vec3i)pos).add(0.0, Utils.pixels(18.0), 0.0);
            tap = tap.relative((Direction)state.getValue((Property)BasinBlock.DIRECTION), Utils.pixels(2.0));
            for (int i = 0; i < 5; ++i) {
                double x = tap.x + Utils.pixels(0.5) * level.random.nextGaussian();
                double z = tap.z + Utils.pixels(0.5) * level.random.nextGaussian();
                level.addParticle((ParticleOptions)ModParticleTypes.TAP_WATER.get(), x, tap.y, z, 0.0, 0.0, 0.0);
            }
            --basin.animationTime;
        }
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.tank.load(tag.getCompound("FluidTank"));
    }

    protected void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        CompoundTag tankTag = new CompoundTag();
        this.tank.save(tankTag);
        tag.put("FluidTank", (Tag)tankTag);
    }
}

