/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.INameable;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageDoorbellNotification;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DoorbellBlockEntity
extends ElectricityModuleBlockEntity
implements INameable {
    public static final int MAX_NAME_LENGTH = 32;
    protected UUID owner;
    protected String customName = "";
    protected long lastPressedTime;
    protected boolean powered;

    public DoorbellBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.DOORBELL.get(), pos, state);
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.setChanged();
    }

    @Override
    public boolean isNodePowered() {
        return this.powered;
    }

    @Override
    public void setNodePowered(boolean powered) {
        this.powered = powered;
        this.setChanged();
        if (!this.level.isClientSide()) {
            CompoundTag compound = new CompoundTag();
            compound.putBoolean("Powered", powered);
            BlockEntityHelper.sendCustomUpdate(this, compound);
        }
    }

    @Override
    public void setName(@Nullable ServerPlayer player, String name) {
        if (this.owner == null || player == null) {
            return;
        }
        if (!this.owner.equals(player.getUUID())) {
            return;
        }
        if (!name.isBlank() && name.length() <= 32) {
            this.customName = name;
            this.setChanged();
        }
    }

    public void sendNotificationToOwner(@Nullable Player presser) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (this.owner != null) {
                MinecraftServer server = level2.getServer();
                ServerPlayer player = server.getPlayerList().getPlayer(this.owner);
                if (player == null || level2.getGameTime() - this.lastPressedTime < 600L) {
                    return;
                }
                if (presser != null && presser.equals((Object)player)) {
                    return;
                }
                Network.getPlay().sendToPlayer(() -> player, (Object)new MessageDoorbellNotification(this.customName));
                this.lastPressedTime = level2.getGameTime();
            }
        }
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        if (tag.contains("Owner", 11)) {
            this.owner = tag.getUUID("Owner");
        }
        if (tag.contains("CustomName", 8)) {
            this.customName = tag.getString("CustomName");
        }
        if (tag.contains("Powered", 1)) {
            this.powered = tag.getBoolean("Powered");
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        if (this.owner != null) {
            tag.putUUID("Owner", this.owner);
        }
        tag.putBoolean("Powered", this.powered);
        tag.putString("CustomName", this.customName);
    }
}

