/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.blockentity.BasicLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.ISourceNode;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public abstract class ElectricitySourceLootBlockEntity
extends BasicLootBlockEntity
implements ISourceNode {
    protected final Set<Connection> connections = new HashSet<Connection>();
    protected boolean overloaded;

    public ElectricitySourceLootBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int containerSize) {
        super(type, pos, state, containerSize);
    }

    @Override
    public Level getNodeLevel() {
        return this.level;
    }

    @Override
    public BlockPos getNodePosition() {
        return this.worldPosition;
    }

    @Override
    public BlockEntity getNodeOwner() {
        return this;
    }

    @Override
    public Set<Connection> getNodeConnections() {
        return this.connections;
    }

    @Override
    public void setNodeOverloaded(boolean overloaded) {
        this.overloaded = overloaded;
        this.setChanged();
    }

    @Override
    public boolean isNodeOverloaded() {
        return this.overloaded;
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.readNodeNbt(tag);
    }

    @Override
    protected void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        this.writeNodeNbt(tag);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    public int hashCode() {
        return this.worldPosition.hashCode();
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.worldPosition).inflate((double)((Integer)Config.CLIENT.electricityViewDistance.get()).intValue());
    }

    public void saveToItem(ItemStack stack) {
        this.saveNodeNbtToItem(stack);
    }
}

