/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.block.RangeHoodBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.BasicLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.FlipAnimation;
import com.mrcrayfish.furniture.refurbished.blockentity.ICookingBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ILevelAudio;
import com.mrcrayfish.furniture.refurbished.client.audio.AudioManager;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModParticleTypes;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageFlipAnimation;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class FryingPanBlockEntity
extends BasicLootBlockEntity
implements ICookingBlock,
ILevelAudio {
    public static final Vector3f OIL_COLOUR = Vec3.fromRGB24((int)14788611).toVector3f();
    public static final double MAX_AUDIO_DISTANCE = Mth.square((int)8);
    protected final RecipeManager.CachedCheck<Container, ? extends ProcessingRecipe> recipeCache;
    protected final RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> campfireCookingCache;
    protected final Vec3 audioPosition;
    protected boolean needsFlipping;
    protected boolean flipped;
    protected int rotation;
    protected boolean sync;
    private FlipAnimation animation;

    public FryingPanBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.FRYING_PAN.get(), pos, state, (RecipeType<? extends ProcessingRecipe.Item>)((RecipeType)ModRecipeTypes.FRYING_PAN_COOKING.get()));
    }

    public FryingPanBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, RecipeType<? extends ProcessingRecipe.Item> recipeType) {
        super(type, pos, state, 1);
        this.recipeCache = RecipeManager.createCheck(recipeType);
        this.campfireCookingCache = RecipeManager.createCheck((RecipeType)RecipeType.CAMPFIRE_COOKING);
        this.audioPosition = pos.getCenter().add(0.0, -0.375, 0.0);
    }

    public boolean isFlippingNeeded() {
        return this.needsFlipping;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public int getRotation() {
        return this.rotation;
    }

    protected Component getDefaultName() {
        return Utils.translation("container", "frying_pan", new Object[0]);
    }

    @Override
    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        return false;
    }

    protected AbstractContainerMenu createMenu(int windowId, Inventory playerInventory) {
        return null;
    }

    public int getMaxStackSize() {
        return 1;
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, FryingPanBlockEntity fryingPan) {
        AudioManager.get().playLevelAudio(fryingPan);
        fryingPan.spawnParticles(level, pos);
        FlipAnimation animation = fryingPan.getAnimation();
        boolean wasPlaying = animation.isPlaying();
        animation.tick();
        if (wasPlaying && !animation.isPlaying()) {
            fryingPan.playPlaceIngredientSound(true, 1.0f);
        }
    }

    private void spawnParticles(Level level, BlockPos pos) {
        if (this.isCooking() && !this.getAnimation().isPlaying()) {
            double posX = (double)pos.getX() + 0.35 + 0.3 * level.random.nextDouble();
            double posY = (double)pos.getY() + 0.15;
            double posZ = (double)pos.getZ() + 0.35 + 0.3 * level.random.nextDouble();
            level.addParticle((ParticleOptions)new DustParticleOptions(OIL_COLOUR, 0.25f), posX, posY, posZ, 0.0, -0.05, 0.0);
            this.spawnSteam(level, posX, posY, posZ);
        }
    }

    public void spawnSteam(Level level, double x, double y, double z) {
        double ySpeed = 0.01;
        if (this.isRangeHoodPowered(level, this.worldPosition.above())) {
            ySpeed = 0.05;
        } else if (this.isRangeHoodPowered(level, this.worldPosition.above().above())) {
            ySpeed = 0.1;
        }
        level.addParticle((ParticleOptions)ModParticleTypes.STEAM.get(), x, y, z, 0.0, ySpeed, 0.0);
    }

    private boolean isRangeHoodPowered(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof RangeHoodBlock) {
            return (Boolean)state.getValue((Property)RangeHoodBlock.POWERED);
        }
        return false;
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this;
    }

    @Override
    public boolean canCook() {
        ItemStack stack = this.getItem(0);
        if (!stack.isEmpty() && !this.needsFlipping) {
            return this.getRecipe(stack).isPresent();
        }
        return false;
    }

    @Override
    public int getTimeToCook() {
        Optional<? extends ProcessingRecipe> optional;
        ItemStack stack = this.getItem(0);
        if (!stack.isEmpty() && (optional = this.getRecipe(stack)).isPresent()) {
            return optional.get().getTime() / 2;
        }
        return 0;
    }

    @Override
    public void onCompleteCooking() {
        if (!this.flipped) {
            this.needsFlipping = true;
            this.setChanged();
            return;
        }
        ItemStack stack = this.getItem(0);
        if (!stack.isEmpty()) {
            Item remainingItem = stack.getItem().getCraftingRemainingItem();
            Optional<? extends ProcessingRecipe> optional = this.getRecipe(stack);
            ItemStack result = optional.map(recipe -> recipe.getResultItem(this.level.registryAccess())).orElse(ItemStack.EMPTY);
            stack.shrink(1);
            if (!result.isEmpty()) {
                ItemStack copy = result.copy();
                this.setItem(0, copy);
                if (remainingItem != null) {
                    BlockPos pos = this.worldPosition;
                    this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)remainingItem)));
                }
            }
        }
    }

    @Override
    public boolean canPlaceItem(int slotIndex, ItemStack stack) {
        return slotIndex == 0 && super.canPlaceItem(slotIndex, stack) && this.getRecipe(stack).isPresent();
    }

    public boolean canTakeItem(Container container, int slotIndex, ItemStack stack) {
        return slotIndex == 0 && super.canTakeItem(container, slotIndex, stack) && this.getRecipe(stack).isEmpty();
    }

    public void setItem(int slotIndex, ItemStack stack) {
        if (!this.isCooking() && this.getRecipe(stack).isPresent()) {
            this.flipped = false;
            this.needsFlipping = false;
        }
        super.setItem(slotIndex, stack);
    }

    private Optional<? extends ProcessingRecipe> getRecipe(ItemStack stack) {
        Optional<? extends ProcessingRecipe> optional = this.getRecipe(this.recipeCache, stack);
        if (((Boolean)Config.SERVER.recipes.inheritCampfireRecipes.get()).booleanValue()) {
            optional = optional.isEmpty() ? this.getCookingRecipe(this.campfireCookingCache, stack) : optional;
        }
        return optional;
    }

    private Optional<? extends ProcessingRecipe> getRecipe(RecipeManager.CachedCheck<Container, ? extends ProcessingRecipe> cache, ItemStack stack) {
        return cache.getRecipeFor((Container)new SimpleContainer(new ItemStack[]{stack}), Objects.requireNonNull(this.level)).map(RecipeHolder::value);
    }

    private Optional<ProcessingRecipe> getCookingRecipe(RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> cache, ItemStack stack) {
        return cache.getRecipeFor((Container)new SimpleContainer(new ItemStack[]{stack}), Objects.requireNonNull(this.level)).map(RecipeHolder::value).map(recipe -> ProcessingRecipe.Item.from(recipe, this.level.registryAccess()));
    }

    public void flipItem() {
        if (this.needsFlipping && !this.flipped) {
            this.flipped = true;
            this.needsFlipping = false;
            this.sendFlipAnimationToPlayers();
            this.setChanged();
            return;
        }
        if (!this.getItem(0).isEmpty()) {
            this.removeContents();
        }
    }

    public boolean placeContents(Level level, ItemStack stack, int rotation) {
        if (!stack.isEmpty() && this.getItem(0).isEmpty()) {
            ItemStack copy = stack.copy();
            copy.setCount(1);
            this.setItem(0, copy);
            this.rotation = rotation;
            this.flipped = false;
            this.needsFlipping = false;
            this.setChanged();
            this.playPlaceIngredientSound(false, 0.85f);
            return true;
        }
        this.removeContents();
        return false;
    }

    public void removeContents() {
        if (!this.getItem(0).isEmpty()) {
            ItemStack stack = this.getItem(0);
            BlockPos pos = this.worldPosition;
            ItemEntity entity = new ItemEntity(this.level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5, stack.copy());
            this.setItem(0, ItemStack.EMPTY);
            this.level.addFreshEntity((Entity)entity);
            this.flipped = false;
            this.needsFlipping = false;
            this.setChanged();
        }
    }

    public void playFlipAnimation(int index) {
        if (Objects.requireNonNull(this.level).isClientSide() && index == 0) {
            this.getAnimation().play();
        }
    }

    private void sendFlipAnimationToPlayers() {
        Level level = Objects.requireNonNull(this.level);
        ChunkSource chunkSource = level.getChunkSource();
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache cache = (ServerChunkCache)chunkSource;
            BlockPos pos = this.getBlockPos();
            List players = cache.chunkMap.getPlayers(new ChunkPos(pos), false);
            players.forEach(player -> Network.getPlay().sendToPlayer(() -> player, (Object)new MessageFlipAnimation(pos, 0)));
        }
    }

    public FlipAnimation getAnimation() {
        if (this.animation == null) {
            this.animation = new FlipAnimation();
        }
        return this.animation;
    }

    private void playPlaceIngredientSound(boolean client, float pitch) {
        Level level = Objects.requireNonNull(this.level);
        Vec3 vec = Vec3.atBottomCenterOf((Vec3i)this.worldPosition);
        if (client) {
            level.playLocalSound(vec.x, vec.y, vec.z, (SoundEvent)ModSounds.BLOCK_FRYING_PAN_PLACE_INGREDIENT.get(), SoundSource.PLAYERS, 1.0f, pitch, false);
            return;
        }
        level.playSound(null, vec.x, vec.y, vec.z, (SoundEvent)ModSounds.BLOCK_FRYING_PAN_PLACE_INGREDIENT.get(), SoundSource.PLAYERS, 1.0f, pitch);
    }

    public void setChanged() {
        super.setChanged();
        this.sync();
    }

    protected void sync() {
        BlockEntityHelper.sendCustomUpdate((BlockEntity)this, this.getUpdateTag());
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        if (tag.contains("NeedsFlipping", 1)) {
            this.needsFlipping = tag.getBoolean("NeedsFlipping");
        }
        if (tag.contains("Flipped", 1)) {
            this.flipped = tag.getBoolean("Flipped");
        }
        if (tag.contains("Rotation", 3)) {
            this.rotation = tag.getInt("Rotation");
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.putBoolean("NeedsFlipping", this.needsFlipping);
        tag.putBoolean("Flipped", this.flipped);
        tag.putInt("Rotation", this.rotation);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    @Override
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.BLOCK_FRYING_PAN_SIZZLING.get();
    }

    @Override
    public SoundSource getSource() {
        return SoundSource.BLOCKS;
    }

    @Override
    public Vec3 getAudioPosition() {
        return this.audioPosition;
    }

    @Override
    public boolean canPlayAudio() {
        return !this.isRemoved() && (this.isCooking() || this.isPartiallyCooked());
    }

    @Override
    public float getAudioVolume() {
        return (this.isCooking() || this.isPartiallyCooked()) && !this.getAnimation().isPlaying() ? 1.0f : 0.0f;
    }

    @Override
    public float getAudioPitch() {
        return this.isPartiallyCooked() ? 0.8f : 1.0f;
    }

    @Override
    public int getAudioHash() {
        return this.worldPosition.hashCode();
    }

    @Override
    public boolean isAudioEqual(ILevelAudio other) {
        return this == other;
    }

    @Override
    public double getAudioRadiusSqr() {
        return MAX_AUDIO_DISTANCE;
    }

    private boolean isPartiallyCooked() {
        return !this.getItem(0).isEmpty() && this.isFlippingNeeded();
    }
}

