/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.block.LightswitchBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IHomeControlDevice;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LightswitchBlockEntity
extends ElectricityModuleBlockEntity
implements IHomeControlDevice,
Nameable {
    @Nullable
    private Component name;

    public LightswitchBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.LIGHTSWITCH.get(), pos, state);
    }

    @Override
    public boolean canPowerTraverseNode() {
        BlockState state = this.getBlockState();
        return state.hasProperty((Property)LightswitchBlock.ENABLED) && (Boolean)state.getValue((Property)LightswitchBlock.ENABLED) != false;
    }

    @Override
    public boolean isNodePowered() {
        BlockState state = this.getBlockState();
        return state.hasProperty((Property)LightswitchBlock.POWERED) && (Boolean)state.getValue((Property)LightswitchBlock.POWERED) != false;
    }

    @Override
    public void setNodePowered(boolean powered) {
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)LightswitchBlock.POWERED)) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)LightswitchBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        }
    }

    @Override
    public BlockPos getDevicePos() {
        return this.worldPosition;
    }

    @Override
    public boolean isDeviceEnabled() {
        BlockState state = this.getBlockState();
        return state.hasProperty((Property)LightswitchBlock.ENABLED) && (Boolean)state.getValue((Property)LightswitchBlock.ENABLED) != false;
    }

    @Override
    public void toggleDeviceState() {
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)LightswitchBlock.ENABLED)) {
            boolean enabled = (Boolean)state.getValue((Property)LightswitchBlock.ENABLED) == false;
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)LightswitchBlock.ENABLED, (Comparable)Boolean.valueOf(enabled)), 3);
        }
    }

    @Override
    public void setDeviceState(boolean enabled) {
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)LightswitchBlock.ENABLED)) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)LightswitchBlock.ENABLED, (Comparable)Boolean.valueOf(enabled)), 3);
        }
    }

    @Override
    public Component getDeviceName() {
        if (this.hasCustomName()) {
            return this.getCustomName();
        }
        return Components.SMART_DEVICE_LIGHTSWITCH;
    }

    public Component getName() {
        return this.getBlockState().getBlock().getName();
    }

    public Component getDisplayName() {
        return this.name != null ? this.name : this.getName();
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    public void setCustomName(@Nullable Component name) {
        this.name = name;
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        if (tag.contains("CustomName", 8)) {
            this.name = Component.Serializer.fromJson((String)tag.getString("CustomName"));
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        if (this.name != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.name));
        }
    }
}

