/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.blockentity.ICookingBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.StoveBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;

public class StoveContainer
extends CompoundContainer
implements WorldlyContainer {
    private final StoveBlockEntity stove;
    private final ICookingBlock cookingBlock;
    private final Container cookingContainer;
    private final int[][] slots;

    public StoveContainer(StoveBlockEntity stove, ICookingBlock cookingBlock, Container cookingContainer) {
        super((Container)stove, cookingContainer);
        this.stove = stove;
        this.cookingBlock = cookingBlock;
        this.cookingContainer = cookingContainer;
        this.slots = this.generateSlots();
    }

    private int[][] generateSlots() {
        int[][] slots = new int[Direction.values().length][1];
        for (Direction direction : Direction.values()) {
            int[] stoveSlots = this.stove.getSlotsForFace(direction);
            Container container = this.cookingContainer;
            if (container instanceof WorldlyContainer) {
                WorldlyContainer worldlyContainer = (WorldlyContainer)container;
                int[] cookingSlots = worldlyContainer.getSlotsForFace(direction);
                slots[direction.get3DDataValue()] = this.combineSlots(stoveSlots, cookingSlots, this.stove.getContainerSize());
                continue;
            }
            slots[direction.get3DDataValue()] = stoveSlots;
        }
        return slots;
    }

    private int[] combineSlots(int[] a, int[] b, int indexOffset) {
        int[] copy = new int[b.length];
        System.arraycopy(b, 0, copy, 0, b.length);
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = copy[i] + indexOffset;
        }
        int[] c = new int[a.length + copy.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(copy, 0, c, a.length, copy.length);
        return c;
    }

    public boolean isValid() {
        return !this.stove.isRemoved() && !this.cookingBlock.getBlockEntity().isRemoved();
    }

    public int[] getSlotsForFace(Direction direction) {
        return this.slots[direction.get3DDataValue()];
    }

    public boolean canPlaceItemThroughFace(int slotIndex, ItemStack stack, @Nullable Direction direction) {
        if (slotIndex >= this.stove.getContainerSize()) {
            Container container = this.cookingContainer;
            if (container instanceof WorldlyContainer) {
                WorldlyContainer worldlyContainer = (WorldlyContainer)container;
                return worldlyContainer.canPlaceItemThroughFace(slotIndex - this.stove.getContainerSize(), stack, direction);
            }
            return this.cookingContainer.canPlaceItem(slotIndex - this.stove.getContainerSize(), stack);
        }
        return this.stove.canPlaceItemThroughFace(slotIndex, stack, direction);
    }

    public boolean canTakeItemThroughFace(int slotIndex, ItemStack stack, Direction direction) {
        if (slotIndex >= this.stove.getContainerSize()) {
            Container container = this.cookingContainer;
            if (container instanceof WorldlyContainer) {
                WorldlyContainer worldlyContainer = (WorldlyContainer)container;
                return worldlyContainer.canTakeItemThroughFace(slotIndex - this.stove.getContainerSize(), stack, direction);
            }
            return this.cookingContainer.canTakeItem(this.cookingContainer, slotIndex - this.stove.getContainerSize(), stack);
        }
        return this.stove.canTakeItemThroughFace(slotIndex, stack, direction);
    }

    public boolean canTakeItem(Container container, int slotIndex, ItemStack stack) {
        if (slotIndex >= this.stove.getContainerSize()) {
            return this.cookingContainer.canTakeItem(this.cookingContainer, slotIndex - this.stove.getContainerSize(), stack);
        }
        return this.stove.canTakeItem((Container)this.stove, slotIndex, stack);
    }
}

