/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.IFluidContainerBlock;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageFlushItem;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ToiletBlockEntity
extends BlockEntity
implements IFluidContainerBlock {
    protected final FluidContainer tank;

    public ToiletBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.TOILET.get(), pos, state);
    }

    public ToiletBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tank = FluidContainer.create((Long)Config.SERVER.toilet.fluidCapacity.get(), container -> {
            this.setChanged();
            container.sync(this);
        });
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    @Override
    public FluidContainer getFluidContainer() {
        return this.tank;
    }

    public InteractionResult interact(Player player, InteractionHand hand, BlockHitResult result) {
        Level level = Objects.requireNonNull(this.level);
        ItemStack heldItem = player.getItemInHand(hand);
        Item item = heldItem.getItem();
        if (item == Items.GLASS_BOTTLE && !this.tank.isEmpty() && this.tank.getStoredFluid().isSame((Fluid)Fluids.WATER)) {
            this.tank.pull(FluidContainer.BUCKET_CAPACITY, false);
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)heldItem, (Player)player, (ItemStack)PotionUtils.setPotion((ItemStack)new ItemStack((ItemLike)Items.POTION), (Potion)Potions.WATER)));
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            player.level().playSound(null, this.worldPosition, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            player.level().gameEvent(null, GameEvent.FLUID_PICKUP, this.worldPosition);
            return InteractionResult.SUCCESS;
        }
        if (!Services.FLUID.isFluidContainerItem(heldItem)) {
            Vec3 hit = result.getLocation().subtract(Vec3.atLowerCornerOf((Vec3i)this.worldPosition));
            if (hit.y() > 0.625) {
                if (!this.tank.isEmpty() && this.flushItems(level) != InteractionResult.PASS) {
                    return InteractionResult.SUCCESS;
                }
                if (((Boolean)Config.SERVER.toilet.dispenseWater.get()).booleanValue() && this.fillWithWater(level) != InteractionResult.PASS) {
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.PASS;
        }
        return Services.FLUID.performInteractionWithBlock(player, hand, this.getLevel(), this.getBlockPos(), result.getDirection());
    }

    private InteractionResult fillWithWater(Level level) {
        if (this.tank.isEmpty() || this.tank.getStoredFluid().isSame((Fluid)Fluids.WATER)) {
            SoundEvent event;
            if (this.tank.getStoredAmount() < this.tank.getCapacity()) {
                this.tank.push((Fluid)Fluids.WATER, FluidContainer.BUCKET_CAPACITY, false);
            }
            if ((event = Services.FLUID.getBucketEmptySound((Fluid)Fluids.WATER)) != null) {
                Vec3 splashPos = Vec3.atCenterOf((Vec3i)this.worldPosition);
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SPLASH, splashPos.x, splashPos.y, splashPos.z, 10, 0.0, 0.0, 0.0, 0.0);
                level.playSound(null, this.worldPosition, event, SoundSource.BLOCKS);
                return InteractionResult.SUCCESS;
            }
        }
        if (this.tank.getStoredFluid().isSame((Fluid)Fluids.LAVA) && this.tank.getStoredAmount() >= FluidContainer.BUCKET_CAPACITY && this.tank.getStoredFluid().isSame((Fluid)Fluids.LAVA)) {
            Pair<Fluid, Long> drained = this.tank.pull(FluidContainer.BUCKET_CAPACITY, true);
            if ((Long)drained.right() != FluidContainer.BUCKET_CAPACITY) {
                return InteractionResult.PASS;
            }
            this.tank.pull(FluidContainer.BUCKET_CAPACITY, false);
            Vec3 pos = Vec3.atCenterOf((Vec3i)this.worldPosition);
            ItemEntity entity = new ItemEntity(level, pos.x, pos.y, pos.z, new ItemStack((ItemLike)Blocks.OBSIDIAN));
            entity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)entity);
            level.playSound(null, this.worldPosition, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS);
            level.levelEvent(1501, this.worldPosition, 0);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private InteractionResult flushItems(Level level) {
        List entities = level.getEntitiesOfClass(ItemEntity.class, new AABB(this.worldPosition));
        entities.forEach(entity -> {
            Network.getPlay().sendToTrackingBlockEntity(() -> this, (Object)new MessageFlushItem(entity.getId(), this.worldPosition));
            entity.discard();
        });
        if (!entities.isEmpty()) {
            level.scheduleTick(this.worldPosition, this.getBlockState().getBlock(), 40);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.tank.load(tag.getCompound("FluidTank"));
    }

    protected void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        CompoundTag tankTag = new CompoundTag();
        this.tank.save(tankTag);
        tag.put("FluidTank", (Tag)tankTag);
    }
}

