/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.furniture.refurbished.client.CustomSheets;
import com.mrcrayfish.furniture.refurbished.client.DeferredElectricRenderer;
import com.mrcrayfish.furniture.refurbished.client.LinkHandler;
import com.mrcrayfish.furniture.refurbished.client.ToolAnimationRenderer;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.platform.ClientServices;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@Mod.EventBusSubscriber(modid="refurbished_furniture", value={Dist.CLIENT})
public class NeoForgeClientEvents {
    @SubscribeEvent
    private static void onKeyTriggered(InputEvent.InteractionKeyMappingTriggered event) {
        Minecraft mc = Minecraft.getInstance();
        if (event.getKeyMapping() == mc.options.keyAttack && mc.player != null && mc.level != null && mc.player.getMainHandItem().is((Item)ModItems.WRENCH.get()) && LinkHandler.get().onWrenchLeftClick((Level)mc.level)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    private static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        PoseStack stack = event.getPoseStack();
        stack.pushPose();
        Vec3 view = event.getCamera().getPosition();
        stack.translate(-view.x(), -view.y(), -view.z());
        LinkHandler.get().render((Player)mc.player, stack, mc.renderBuffers().bufferSource(), event.getPartialTick());
        ToolAnimationRenderer.get().render((Level)mc.level, stack, mc.renderBuffers().bufferSource(), event.getPartialTick());
        DeferredElectricRenderer.get().draw(stack);
        stack.popPose();
        mc.renderBuffers().bufferSource().endBatch(ClientServices.PLATFORM.getTelevisionScreenRenderType(CustomSheets.TV_CHANNELS_SHEET));
    }

    @SubscribeEvent
    private static void onDrawHighlight(RenderHighlightEvent.Block event) {
        ItemStack stack;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && (stack = mc.player.getItemInHand(InteractionHand.MAIN_HAND)).is((Item)ModItems.WRENCH.get())) {
            event.setCanceled(true);
        }
    }
}

