/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.overlay;

import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.client.LinkHandler;
import com.mrcrayfish.furniture.refurbished.client.gui.overlay.IHudOverlay;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.IconButton;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;

public class NodeIndicatorOverlay
implements IHudOverlay {
    @Override
    public void draw(GuiGraphics graphics, float partialTick) {
        IElectricityNode node1;
        BlockHitResult result;
        BlockEntity entity;
        Connection connection;
        IElectricityNode linking;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.hitResult == null) {
            return;
        }
        if (mc.player == null) {
            return;
        }
        LinkHandler handler = LinkHandler.get();
        IElectricityNode target = handler.getTargetNode();
        if (handler.isLinking()) {
            double linkLength = handler.getLinkLength();
            if (linkLength > 512.0) {
                this.drawLabel(mc, graphics, Components.GUI_LINK_TOO_LONG, 40, 0);
                return;
            }
            linking = handler.getLinkingNode((Level)mc.level);
            if (target != null && linking != null && target != linking) {
                if (target.isSourceNode() && linking.isSourceNode()) {
                    this.drawLabel(mc, graphics, Components.GUI_LINK_INVALID_NODE, 40, 0);
                    return;
                }
                int nodeLinkLength = (int)(linking.getNodePosition().getCenter().distanceTo(target.getNodePosition().getCenter()) + 0.5);
                if ((double)nodeLinkLength > 512.0) {
                    this.drawLabel(mc, graphics, Components.GUI_LINK_TOO_LONG, 40, 0);
                    return;
                }
                if (target.isNodeConnectionLimitReached()) {
                    this.drawLabel(mc, graphics, Components.GUI_LINK_TOO_MANY, 40, 0);
                    return;
                }
                if (handler.canLinkToNode((Level)mc.level, target)) {
                    if (!handler.isLinkInsidePowerableArea()) {
                        this.drawLabel(mc, graphics, Components.GUI_LINK_UNPOWERABLE, 30, 0);
                        return;
                    }
                    MutableComponent label = Utils.translation("gui", "progress", target.getNodeConnections().size(), Components.GUI_SLASH, target.getNodeMaximumConnections());
                    this.drawLabel(mc, graphics, (Component)label, 0, 10);
                    return;
                }
            }
            if (!handler.isLinkInsidePowerableArea()) {
                this.drawLabel(mc, graphics, Components.GUI_LINK_OUTSIDE_AREA, 40, 0);
                return;
            }
        } else if (target != null) {
            MutableComponent label = Utils.translation("gui", "progress", target.getNodeConnections().size(), Components.GUI_SLASH, target.getNodeMaximumConnections());
            this.drawLabel(mc, graphics, (Component)label, 0, 10);
            return;
        }
        if ((connection = handler.getTargetConnection()) != null && connection.isCrossingPowerableZone((Level)mc.level)) {
            this.drawLabel(mc, graphics, Components.GUI_LINK_OUTSIDE_AREA, 40, 0);
            return;
        }
        if (!LinkHandler.isHoldingWrench() && (linking = mc.hitResult) instanceof BlockHitResult && (entity = mc.level.getBlockEntity((result = (BlockHitResult)linking).getBlockPos())) instanceof IElectricityNode && !(node1 = (IElectricityNode)entity).isNodeInPowerableNetwork() && !((Boolean)Config.SERVER.electricity.cheats.everythingIsPowered.get()).booleanValue()) {
            this.drawLabel(mc, graphics, Components.GUI_NO_POWER, 20, 20);
        }
    }

    private void drawLabel(Minecraft mc, GuiGraphics graphics, Component label, int iconU, int iconV) {
        int padding = 3;
        int iconSize = 10;
        int messageWidth = mc.font.width((FormattedText)label);
        int contentWidth = padding + iconSize + padding + messageWidth + padding;
        Objects.requireNonNull(mc.font);
        int contentHeight = padding + 9 + padding;
        int contentStart = (graphics.guiWidth() - contentWidth) / 2;
        int contentTop = (graphics.guiHeight() - contentHeight) / 2 + 50;
        graphics.fill(contentStart, contentTop + 1, contentStart + 1, contentTop + contentHeight - 1, 0x77000000);
        graphics.fill(contentStart + 1, contentTop, contentStart + contentWidth - 1, contentTop + contentHeight, 0x77000000);
        graphics.fill(contentStart + contentWidth - 1, contentTop + 1, contentStart + contentWidth, contentTop + contentHeight - 1, 0x77000000);
        graphics.blit(IconButton.ICON_TEXTURES, contentStart + padding, contentTop + padding, (float)iconU, (float)iconV, iconSize, iconSize, 64, 64);
        graphics.drawString(mc.font, label, contentStart + padding + iconSize + padding, contentTop + padding + 1, -1);
    }
}

