/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.compat.jei.categories;

import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.compat.jei.Plugin;
import com.mrcrayfish.furniture.refurbished.compat.jei.categories.FurnitureRecipeCategory;
import com.mrcrayfish.furniture.refurbished.core.ModBlocks;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class GrillCookingCategory
extends FurnitureRecipeCategory<ProcessingRecipe> {
    public static final RecipeType<ProcessingRecipe> TYPE = RecipeType.create((String)"refurbished_furniture", (String)"grill_cooking", ProcessingRecipe.class);
    private final ItemStack campfireStack = new ItemStack((ItemLike)Items.CAMPFIRE);
    private final IGuiHelper helper;
    private final IDrawable background;
    private final IDrawable icon;
    private IDrawable arrow;

    public GrillCookingCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(Plugin.TEXTURES, 135, 57, 121, 79);
        this.icon = helper.createDrawableItemStack(new ItemStack((ItemLike)ModBlocks.GRILL_RED.get()));
    }

    public RecipeType<ProcessingRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Utils.translation("jei_category", "grill_cooking", new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ProcessingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 26, 6).addIngredients((Ingredient)recipe.getIngredients().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 99, 31).addItemStack(Plugin.getResult(recipe));
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 71, 3).addItemStack(new ItemStack((ItemLike)ModItems.SPATULA.get()));
        this.arrow = this.helper.createAnimatedDrawable(this.helper.createDrawable(Plugin.TEXTURES, 133, 136, 24, 17), recipe.getTime(), IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void draw(ProcessingRecipe recipe, IRecipeSlotsView view, GuiGraphics graphics, double mouseX, double mouseY) {
        this.arrow.draw(graphics, 68, 31);
        this.drawSeconds(graphics, 80, 50, recipe.getTime());
        if (recipe.getType() == net.minecraft.world.item.crafting.RecipeType.CAMPFIRE_COOKING) {
            graphics.fill(99, 5, 115, 21, 0x33000000);
            graphics.renderFakeItem(this.campfireStack, 99, 5);
        }
    }

    public List<Component> getTooltipStrings(ProcessingRecipe recipe, IRecipeSlotsView view, double mouseX, double mouseY) {
        if (ScreenHelper.isMouseWithinBounds(mouseX, mouseY, 5, 15, 57, 61) && !ScreenHelper.isMouseWithinBounds(mouseX, mouseY, 26, 6, 16, 16)) {
            return Plugin.getItemTooltip((ItemLike)ModBlocks.GRILL_RED.get());
        }
        if (ScreenHelper.isMouseWithinBounds(mouseX, mouseY, 99, 5, 16, 16)) {
            return List.of(Utils.translation("gui", "jei_campfire_info", new Object[0]));
        }
        return super.getTooltipStrings((Object)recipe, view, mouseX, mouseY);
    }
}

