/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.computer;

import com.mrcrayfish.furniture.refurbished.computer.Computer;
import com.mrcrayfish.furniture.refurbished.computer.Program;
import com.mrcrayfish.furniture.refurbished.computer.client.DisplayableProgram;
import com.mrcrayfish.furniture.refurbished.computer.client.Icon;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class Display {
    private static Display instance;
    private final Map<Class<? extends Program>, Function<Program, DisplayableProgram<? extends Program>>> programs = new HashMap<Class<? extends Program>, Function<Program, DisplayableProgram<? extends Program>>>();
    private Map<ResourceLocation, Icon> icons;

    public static Display get() {
        if (instance == null) {
            instance = new Display();
        }
        return instance;
    }

    public <T extends Program, D extends DisplayableProgram<T>> void bind(Class<T> programClass, Function<T, D> displayableProvider) {
        this.programs.putIfAbsent(programClass, displayableProvider);
    }

    public <T extends Program> DisplayableProgram<T> getDisplay(T program) {
        return this.programs.get(program.getClass()).apply(program);
    }

    @Nullable
    public Icon getIcon(ResourceLocation programId) {
        if (this.icons == null) {
            this.icons = this.computeIconMap();
        }
        return this.icons.get(programId);
    }

    private Map<ResourceLocation, Icon> computeIconMap() {
        HashMap<ResourceLocation, Icon> icons = new HashMap<ResourceLocation, Icon>();
        HashMap textures = new HashMap();
        HashMap indexTracker = new HashMap();
        Computer.get().getPrograms().forEach(id -> {
            String namespace = id.getNamespace();
            textures.putIfAbsent(namespace, new ResourceLocation(namespace, "textures/gui/program_icons.png"));
            int nextIndex = indexTracker.getOrDefault(namespace, -1) + 1;
            indexTracker.put(namespace, nextIndex);
            icons.put((ResourceLocation)id, new Icon((ResourceLocation)textures.get(namespace), nextIndex % 8 * 16, nextIndex / 8 * 16));
        });
        return icons;
    }
}

