/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public abstract class ProcessingRecipe
implements Recipe<Container> {
    protected final RecipeType<?> type;
    protected final Category category;
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final int time;

    public ProcessingRecipe(RecipeType<?> type, Category category, Ingredient ingredient, ItemStack result, int time) {
        this.type = type;
        this.category = category;
        this.ingredient = ingredient;
        this.result = result;
        this.time = time;
    }

    public RecipeType<?> getType() {
        return this.type;
    }

    public Category getCategory() {
        return this.category;
    }

    public ItemStack getResultItem(RegistryAccess access) {
        return this.result;
    }

    public boolean matches(Container container, Level level) {
        return this.ingredient.test(container.getItem(0));
    }

    public ItemStack assemble(Container container, RegistryAccess access) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.create();
        ingredients.add((Object)this.ingredient);
        return ingredients;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public int getTime() {
        return this.time;
    }

    public static <T extends ProcessingRecipe> Builder<T> builder(Factory<T> factory, Category category, Ingredient input, ItemStack output, int processTime) {
        return new Builder<T>(factory, category, input, output, processTime);
    }

    public static enum Category implements StringRepresentable
    {
        BLOCKS("blocks"),
        ITEMS("items"),
        FOOD("food"),
        MISC("misc");

        public static final StringRepresentable.EnumCodec<Category> CODEC;
        private final String name;

        private Category(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public void toNetwork(FriendlyByteBuf buf) {
            buf.writeUtf(this.name, 6);
        }

        public static Category fromNetwork(FriendlyByteBuf buf) {
            return Category.byName(buf.readUtf(6));
        }

        public static Category byName(String name) {
            return (Category)CODEC.byName(name, (Enum)MISC);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Category::values);
        }
    }

    public static class Builder<T extends ProcessingRecipe>
    implements RecipeBuilder {
        protected final Category category;
        protected final Factory<T> factory;
        protected final Ingredient input;
        protected final ItemStack output;
        protected final int processTime;
        protected final Map<String, Criterion<?>> criteria = new LinkedHashMap();

        private Builder(Factory<T> factory, Category category, Ingredient input, ItemStack output, int processTime) {
            this.factory = factory;
            this.category = category;
            this.input = input;
            this.output = output;
            this.processTime = processTime;
        }

        public RecipeBuilder unlockedBy(String s, Criterion<?> instance) {
            this.criteria.put(s, instance);
            return this;
        }

        public RecipeBuilder group(@Nullable String group) {
            throw new UnsupportedOperationException("Group not supported for ProcessingRecipes");
        }

        public net.minecraft.world.item.Item getResult() {
            return this.output.getItem();
        }

        public void save(RecipeOutput output, ResourceLocation id) {
            Advancement.Builder builder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
            this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
            output.accept(id, this.factory.create(this.category, this.input, this.output, this.processTime), builder.build(id.withPrefix("recipes/" + this.category.getSerializedName() + "/")));
        }
    }

    public static interface Factory<T extends ProcessingRecipe> {
        public T create(Category var1, Ingredient var2, ItemStack var3, int var4);
    }

    public static abstract class ItemWithCount
    extends ProcessingRecipe {
        public static final Codec<ItemStack> ITEMSTACK = RecordCodecBuilder.create(builder -> builder.group((App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("item").forGetter(ItemStack::getItemHolder), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(ItemStack::getCount), (App)CompoundTag.CODEC.optionalFieldOf("tag").forGetter(stack -> Optional.ofNullable(stack.getTag()))).apply((Applicative)builder, ItemStack::new));
        public static final Codec<ItemStack> RESULT = ExtraCodecs.xor(ITEMSTACK, (Codec)ItemStack.SINGLE_ITEM_CODEC).xmap(either -> (ItemStack)either.map(Function.identity(), Function.identity()), stack -> stack.getCount() == 1 && stack.getTag() == null ? Either.right((Object)stack) : Either.left((Object)stack));

        public ItemWithCount(RecipeType<?> type, Category category, Ingredient ingredient, ItemStack result, int time) {
            super(type, category, ingredient, result, time);
        }

        public static class Serializer<T extends ProcessingRecipe>
        implements RecipeSerializer<T> {
            private final Factory<T> factory;
            private final int defaultTime;
            private final Codec<T> codec;

            public Serializer(Factory<T> factory, int defaultTime) {
                this.factory = factory;
                this.defaultTime = defaultTime;
                this.codec = RecordCodecBuilder.create(builder -> builder.group((App)Category.CODEC.fieldOf("category").forGetter(recipe -> recipe.category), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)RESULT.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.fieldOf("time").orElse((Object)this.defaultTime).forGetter(recipe -> recipe.time)).apply((Applicative)builder, this.factory::create));
            }

            public Codec<T> codec() {
                return this.codec;
            }

            public T fromNetwork(FriendlyByteBuf buf) {
                Category category = Category.fromNetwork(buf);
                Ingredient input = Ingredient.fromNetwork((FriendlyByteBuf)buf);
                ItemStack output = buf.readItem();
                int processTime = buf.readVarInt();
                return this.factory.create(category, input, output, processTime);
            }

            public void toNetwork(FriendlyByteBuf buf, T recipe) {
                ((ProcessingRecipe)recipe).category.toNetwork(buf);
                ((ProcessingRecipe)recipe).ingredient.toNetwork(buf);
                buf.writeItem(((ProcessingRecipe)recipe).result);
                buf.writeVarInt(((ProcessingRecipe)recipe).time);
            }
        }
    }

    public static abstract class Item
    extends ProcessingRecipe {
        public static final Codec<ItemStack> SINGLE_ITEMSTACK = RecordCodecBuilder.create(builder -> builder.group((App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("item").forGetter(ItemStack::getItemHolder), (App)CompoundTag.CODEC.optionalFieldOf("tag").forGetter(stack -> Optional.ofNullable(stack.getTag()))).apply((Applicative)builder, (holder, tag) -> new ItemStack(holder, 1, tag)));
        public static final Codec<ItemStack> RESULT = ExtraCodecs.xor(SINGLE_ITEMSTACK, (Codec)ItemStack.SINGLE_ITEM_CODEC).xmap(either -> (ItemStack)either.map(Function.identity(), Function.identity()), stack -> stack.getTag() == null ? Either.right((Object)stack) : Either.left((Object)stack));

        public Item(RecipeType<?> type, Category category, Ingredient ingredient, ItemStack result, int time) {
            super(type, category, ingredient, result, time);
        }

        public static ProcessingRecipe from(final AbstractCookingRecipe recipe, RegistryAccess access) {
            return new ProcessingRecipe(recipe.getType(), Category.FOOD, (Ingredient)recipe.getIngredients().get(0), recipe.getResultItem(access), recipe.getCookingTime()){

                public RecipeSerializer<?> getSerializer() {
                    return recipe.getSerializer();
                }
            };
        }

        public static class Serializer<T extends ProcessingRecipe>
        implements RecipeSerializer<T> {
            private final Factory<T> factory;
            private final int defaultTime;
            private final Codec<T> codec;

            public Serializer(Factory<T> factory, int defaultTime) {
                this.factory = factory;
                this.defaultTime = defaultTime;
                this.codec = RecordCodecBuilder.create(builder -> builder.group((App)Category.CODEC.fieldOf("category").forGetter(recipe -> recipe.category), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)RESULT.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.fieldOf("time").orElse((Object)this.defaultTime).forGetter(recipe -> recipe.time)).apply((Applicative)builder, this.factory::create));
            }

            public Codec<T> codec() {
                return this.codec;
            }

            public T fromNetwork(FriendlyByteBuf buf) {
                Category category = Category.fromNetwork(buf);
                Ingredient input = Ingredient.fromNetwork((FriendlyByteBuf)buf);
                ItemStack output = buf.readItem();
                int processTime = buf.readVarInt();
                return this.factory.create(category, input, output, processTime);
            }

            public void toNetwork(FriendlyByteBuf buf, T recipe) {
                ((ProcessingRecipe)recipe).category.toNetwork(buf);
                ((ProcessingRecipe)recipe).ingredient.toNetwork(buf);
                buf.writeItem(((ProcessingRecipe)recipe).result);
                buf.writeVarInt(((ProcessingRecipe)recipe).time);
            }
        }
    }
}

