/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.data;

import com.mrcrayfish.framework.Registration;
import com.mrcrayfish.furniture.refurbished.block.DoorMatBlock;
import com.mrcrayfish.furniture.refurbished.data.DropWithName;
import com.mrcrayfish.furniture.refurbished.data.LootBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class CommonLootTableProvider {

    public static class Entity {
        public static void accept(LootBuilder.Entity builder) {
        }
    }

    public static class Block {
        public static void accept(LootBuilder.Block builder) {
            Registration.get((ResourceKey)Registries.BLOCK).stream().filter(entry -> entry.getId().getNamespace().equals("refurbished_furniture")).forEach(entry -> {
                net.minecraft.world.level.block.Block block = (net.minecraft.world.level.block.Block)entry.get();
                if (block instanceof DropWithName) {
                    builder.custom(block, Block.createDropWithName(block));
                } else if (block instanceof DoorMatBlock) {
                    builder.custom(block, Block.createDoorMatLootPool(block));
                } else {
                    builder.self(block);
                }
            });
        }

        private static LootPool.Builder createDoorMatLootPool(net.minecraft.world.level.block.Block block) {
            return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyNbtFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY).copy("Image", "BlockEntityTag.Image").copy("Finalised", "BlockEntityTag.Finalised")));
        }

        private static LootPool.Builder createDropWithName(net.minecraft.world.level.block.Block block) {
            return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)));
        }
    }
}

