/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.electricity;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.electricity.ISourceNode;
import java.lang.ref.WeakReference;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Connection {
    private final Node a;
    private final Node b;
    private Integer hash;

    private Connection(BlockPos a, BlockPos b) {
        this.a = new Node(a);
        this.b = new Node(b);
    }

    public BlockPos getPosA() {
        return this.a.pos;
    }

    public BlockPos getPosB() {
        return this.b.pos;
    }

    @Nullable
    public IElectricityNode getNodeA(Level level) {
        return this.a.getElectricNode(level);
    }

    @Nullable
    public IElectricityNode getNodeB(Level level) {
        return this.b.getElectricNode(level);
    }

    public boolean isConnected(Level level) {
        return this.a.isValid(level) && this.b.isValid(level);
    }

    public boolean isPowered(Level level) {
        IElectricityNode a = this.a.getElectricNode(level);
        IElectricityNode b = this.b.getElectricNode(level);
        return a != null && a.isNodePowered() && b != null && b.isNodePowered();
    }

    public boolean isCrossingPowerableZone(Level level) {
        Set<BlockPos> bPowerSources;
        Set<BlockPos> aPowerSources;
        IElectricityNode a = this.a.getElectricNode(level);
        IElectricityNode b = this.b.getElectricNode(level);
        if (a != null && b != null && !(aPowerSources = a.getPowerSources()).equals(bPowerSources = b.getPowerSources())) {
            Vec3 aPos = this.a.pos.getCenter();
            Vec3 bPos = this.b.pos.getCenter();
            for (BlockPos source : Sets.symmetricDifference(aPowerSources, bPowerSources)) {
                AABB box = ISourceNode.createPowerableZone(level, source);
                if (box.contains(aPos) && box.contains(bPos)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public IElectricityNode getOtherNode(IElectricityNode node) {
        if (this.a.pos.equals((Object)node.getNodePosition())) {
            return this.b.getElectricNode(node.getNodeLevel());
        }
        if (this.b.pos.equals((Object)node.getNodePosition())) {
            return this.a.getElectricNode(node.getNodeLevel());
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Connection other = (Connection)o;
        if (this.getMinPos().equals((Object)other.getMinPos())) {
            return this.getMaxPos().equals((Object)other.getMaxPos());
        }
        return false;
    }

    public int hashCode() {
        this.calculateHash();
        return this.hash;
    }

    private void calculateHash() {
        if (this.hash == null) {
            this.hash = Objects.hashCode((Object[])new Object[]{this.getMinPos(), this.getMaxPos()});
        }
    }

    private BlockPos getMinPos() {
        int c = this.a.pos.compareTo((Vec3i)this.b.pos);
        return c > 0 ? this.a.pos : this.b.pos;
    }

    private BlockPos getMaxPos() {
        int c = this.a.pos.compareTo((Vec3i)this.b.pos);
        return c > 0 ? this.b.pos : this.a.pos;
    }

    public static Connection of(BlockPos a, BlockPos b) {
        return new Connection(a, b);
    }

    private static class Node {
        private final BlockPos pos;
        private WeakReference<IElectricityNode> ref;
        private Status status = Status.ACTIVE;

        private Node(BlockPos pos) {
            this.pos = pos;
            this.ref = new WeakReference<Object>(null);
        }

        public boolean isValid(Level level) {
            this.updateStatus(level);
            return this.status.valid;
        }

        @Nullable
        public IElectricityNode getElectricNode(Level level) {
            this.updateStatus(level);
            return (IElectricityNode)this.ref.get();
        }

        private void updateStatus(Level level) {
            IElectricityNode node = (IElectricityNode)this.ref.get();
            if (node != null && node.isNodeValid()) {
                this.status = Status.ACTIVE;
                return;
            }
            if (level.isLoaded(this.pos)) {
                BlockEntity blockEntity = level.getBlockEntity(this.pos);
                if (blockEntity instanceof IElectricityNode) {
                    IElectricityNode found = (IElectricityNode)blockEntity;
                    this.ref = new WeakReference<IElectricityNode>(found);
                    this.status = Status.ACTIVE;
                } else {
                    this.status = Status.INVALID;
                }
            } else {
                this.status = Status.UNDETERMINED;
            }
        }

        public static enum Status {
            ACTIVE(true),
            UNDETERMINED(true),
            INVALID(false);

            final boolean valid;

            private Status(boolean valid) {
                this.valid = valid;
            }
        }
    }
}

