/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.electricity;

import com.mrcrayfish.furniture.refurbished.Constants;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.electricity.IModuleNode;
import com.mrcrayfish.furniture.refurbished.electricity.ISourceNode;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class ElectricityTicker {
    private final Level level;
    private final Map<BlockPos, WeakReference<IModuleNode>> modules = new ConcurrentHashMap<BlockPos, WeakReference<IModuleNode>>();
    private final Map<BlockPos, WeakReference<ISourceNode>> sources = new ConcurrentHashMap<BlockPos, WeakReference<ISourceNode>>();

    public ElectricityTicker(Level level) {
        this.level = level;
    }

    public void addElectricityNode(IElectricityNode node) {
        if (node instanceof IModuleNode) {
            IModuleNode module = (IModuleNode)node;
            this.modules.put(node.getNodePosition(), new WeakReference<IModuleNode>(module));
        } else if (node instanceof ISourceNode) {
            ISourceNode source = (ISourceNode)node;
            this.sources.put(node.getNodePosition(), new WeakReference<ISourceNode>(source));
        }
    }

    public void earlyTick() {
        this.tickSet(this.modules, this::getModuleNode, IElectricityNode::earlyNodeTick);
        this.tickSet(this.sources, this::getSourceNode, IElectricityNode::earlyNodeTick);
    }

    public void tick() {
        this.tickSet(this.modules, this::getModuleNode, IModuleNode::moduleTick);
    }

    private <T extends IElectricityNode> void tickSet(Map<BlockPos, WeakReference<T>> nodes, Function<BlockPos, T> getter, BiConsumer<T, Level> ticker) {
        Iterator<BlockPos> it = nodes.keySet().iterator();
        while (it.hasNext()) {
            BlockPos pos = it.next();
            IElectricityNode node = (IElectricityNode)getter.apply(pos);
            if (node == null || !node.isNodeValid()) {
                Constants.LOG.debug("Stopping ticking node at {}", (Object)pos);
                it.remove();
                continue;
            }
            if (!this.level.shouldTickBlocksAt(pos)) continue;
            ticker.accept(node, this.level);
        }
    }

    @Nullable
    private <T extends IElectricityNode> T getElectricityNode(Map<BlockPos, WeakReference<T>> map, BlockPos pos, Function<BlockEntity, T> caster) {
        WeakReference<T> sourceRef = map.get(pos);
        if (sourceRef != null) {
            IElectricityNode node = (IElectricityNode)sourceRef.get();
            if (node == null && this.level.isLoaded(pos) && (node = (IElectricityNode)caster.apply(this.level.getBlockEntity(pos))) != null) {
                map.put(pos, new WeakReference<IElectricityNode>(node));
            }
            if (node != null && !node.getNodeOwner().isRemoved()) {
                return (T)node;
            }
        }
        return null;
    }

    @Nullable
    private IModuleNode getModuleNode(BlockPos pos) {
        return this.getElectricityNode(this.modules, pos, entity -> {
            IModuleNode node;
            return entity instanceof IModuleNode ? (node = (IModuleNode)entity) : null;
        });
    }

    @Nullable
    private ISourceNode getSourceNode(BlockPos pos) {
        return this.getElectricityNode(this.sources, pos, entity -> {
            ISourceNode node;
            return entity instanceof ISourceNode ? (node = (ISourceNode)entity) : null;
        });
    }

    public static ElectricityTicker get(Level level) {
        return ((Access)level).refurbishedFurniture$GetElectricityTicker();
    }

    public static interface Access {
        public ElectricityTicker refurbishedFurniture$GetElectricityTicker();
    }
}

