/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.inventory;

import com.mrcrayfish.furniture.refurbished.blockentity.IPowerSwitch;
import com.mrcrayfish.furniture.refurbished.core.ModMenuTypes;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeBookTypes;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.inventory.IContainerHolder;
import com.mrcrayfish.furniture.refurbished.inventory.IElectricityMenu;
import com.mrcrayfish.furniture.refurbished.inventory.IPowerSwitchMenu;
import com.mrcrayfish.furniture.refurbished.inventory.IProcessingMenu;
import com.mrcrayfish.furniture.refurbished.inventory.SimpleRecipeContainerMenu;
import com.mrcrayfish.furniture.refurbished.inventory.slot.ResultSlot;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class MicrowaveMenu
extends SimpleRecipeContainerMenu<Container>
implements IPowerSwitchMenu,
IElectricityMenu,
IContainerHolder,
IProcessingMenu {
    private final ContainerData data;
    private final Level level;

    public MicrowaveMenu(int windowId, Inventory playerInventory) {
        this(windowId, playerInventory, (Container)new SimpleContainer(2), (ContainerData)new SimpleContainerData(4));
    }

    public MicrowaveMenu(int windowId, Inventory playerInventory, Container container, ContainerData data) {
        super((MenuType)ModMenuTypes.MICROWAVE.get(), windowId, container);
        MicrowaveMenu.checkContainerSize((Container)container, (int)2);
        MicrowaveMenu.checkContainerDataCount((ContainerData)data, (int)4);
        container.startOpen(playerInventory.player);
        this.data = data;
        this.level = playerInventory.player.level();
        this.addSlot(new Slot(container, 0, 48, 35));
        this.addSlot(new ResultSlot(container, 1, 108, 35));
        this.addPlayerInventorySlots(8, 84, playerInventory);
        this.addDataSlots(data);
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (slotIndex < this.container.getContainerSize() ? !this.moveItemStackTo(slotStack, this.container.getContainerSize(), this.slots.size(), true) : (this.isRecipe(slotStack) ? !this.moveItemStackTo(slotStack, 0, this.container.getContainerSize(), false) : (slotIndex < this.container.getContainerSize() + 27 ? !this.moveItemStackTo(slotStack, this.container.getContainerSize() + 27, this.slots.size(), false) : !this.moveItemStackTo(slotStack, this.container.getContainerSize(), this.slots.size() - 9, false)))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return stack;
    }

    private boolean isRecipe(ItemStack stack) {
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.MICROWAVE_HEATING.get(), (Container)new SimpleContainer(new ItemStack[]{stack}), this.level).isPresent();
    }

    @Override
    public int getProcessTime() {
        return this.data.get(2);
    }

    @Override
    public int getMaxProcessTime() {
        return this.data.get(3);
    }

    @Override
    public boolean isPowered() {
        return this.data.get(0) != 0;
    }

    @Override
    public boolean isEnabled() {
        return this.data.get(1) != 0;
    }

    @Override
    public void toggle() {
        Container container = this.container;
        if (container instanceof IPowerSwitch) {
            IPowerSwitch powerSwitch = (IPowerSwitch)container;
            powerSwitch.togglePower();
        }
    }

    public void fillCraftSlotsStackedContents(StackedContents contents) {
        if (this.container instanceof StackedContentsCompatible) {
            ((StackedContentsCompatible)this.container).fillStackedContents(contents);
        }
    }

    public void clearCraftingContent() {
        this.getSlot(0).set(ItemStack.EMPTY);
        this.getSlot(1).set(ItemStack.EMPTY);
    }

    public boolean recipeMatches(RecipeHolder<? extends Recipe<Container>> holder) {
        return holder.value().matches(this.container, this.level);
    }

    public int getResultSlotIndex() {
        return 1;
    }

    public int getGridWidth() {
        return 1;
    }

    public int getGridHeight() {
        return 1;
    }

    public int getSize() {
        return 2;
    }

    public RecipeBookType getRecipeBookType() {
        return ModRecipeBookTypes.MICROWAVE.get();
    }

    public boolean shouldMoveToInventory(int slot) {
        return slot != this.getResultSlotIndex();
    }

    @Override
    public Container container() {
        return this.container;
    }
}

