/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.item;

import com.mrcrayfish.framework.api.Environment;
import com.mrcrayfish.framework.api.util.EnvironmentHelper;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PackageItem
extends Item {
    public PackageItem(Item.Properties properties) {
        super(properties);
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> lines, TooltipFlag flag) {
        if (level == null) {
            return;
        }
        this.loadString(stack, "Sender", s -> lines.add((Component)Utils.translation("gui", "package_sent_by", s).withStyle(ChatFormatting.AQUA)));
        this.loadString(stack, "Message", s -> EnvironmentHelper.runOn((Environment)Environment.CLIENT, () -> () -> ScreenHelper.splitText(s, 170).forEach(component -> lines.add((Component)component.withStyle(ChatFormatting.GRAY)))));
        lines.add((Component)Utils.translation("gui", "package_open", new Object[0]).withStyle(ChatFormatting.YELLOW));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide()) {
            float pitch = 0.9f + 0.2f * level.random.nextFloat();
            level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)ModSounds.ITEM_PACKAGE_OPEN.get(), SoundSource.PLAYERS, 1.0f, pitch);
            PackageItem.getPackagedItems(stack).forEach(s -> Containers.dropItemStack((Level)level, (double)player.getX(), (double)player.getY(), (double)player.getZ(), (ItemStack)s));
            player.setItemInHand(hand, ItemStack.EMPTY);
        }
        stack.shrink(1);
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public static List<ItemStack> getPackagedItems(ItemStack stack) {
        NonNullList items = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);
        CompoundTag tag = stack.getOrCreateTag();
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)items);
        return items;
    }

    private void loadString(ItemStack stack, String key, Consumer<String> consumer) {
        CompoundTag tag = stack.getOrCreateTag();
        if (tag.contains(key, 8)) {
            consumer.accept(tag.getString(key));
        }
    }

    public static ItemStack create(Container container, @Nullable String message, @Nullable String sender) {
        return PackageItem.create(BlockEntityHelper.nonNullListFromContainer(container), message, sender);
    }

    public static ItemStack create(NonNullList<ItemStack> items, @Nullable String message, @Nullable String sender) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.PACKAGE.get());
        CompoundTag tag = stack.getOrCreateTag();
        ContainerHelper.saveAllItems((CompoundTag)tag, items);
        Optional.ofNullable(message).ifPresent(s -> tag.putString("Message", s));
        Optional.ofNullable(sender).ifPresent(s -> tag.putString("Sender", s));
        return stack;
    }
}

