/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.item;

import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.electricity.LinkManager;
import com.mrcrayfish.furniture.refurbished.electricity.NodeHitResult;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class WrenchItem
extends Item {
    public WrenchItem(Item.Properties properties) {
        super(properties);
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return false;
    }

    public InteractionResult useOn(UseOnContext context) {
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        float range = player.isCreative() ? 5.0f : 4.5f;
        NodeHitResult result = WrenchItem.performNodeRaycast(level, player, range, 1.0f);
        if (result.getType() != HitResult.Type.MISS) {
            if (!level.isClientSide() && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                LinkManager.get(serverLevel.getServer()).ifPresent(manager -> manager.onNodeInteract(level, player, result.getNode()));
            }
            return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)level.isClientSide());
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public static NodeHitResult performNodeRaycast(Level level, Player player, float range, float partialTick) {
        Vec3 start = player.getEyePosition(partialTick);
        Vec3 look = player.getViewVector(partialTick);
        Vec3 end = start.add(look.x * (double)range, look.y * (double)range, look.z * (double)range);
        return (NodeHitResult)((Object)BlockGetter.traverseBlocks((Vec3)start, (Vec3)end, null, (o, pos) -> {
            IElectricityNode found;
            Optional hit;
            BlockEntity patt2576$temp = level.getBlockEntity(pos);
            if (patt2576$temp instanceof IElectricityNode && (hit = (found = (IElectricityNode)patt2576$temp).getPositionedNodeInteractBox().inflate(0.0625).clip(start, end)).isPresent()) {
                return new NodeHitResult((Vec3)hit.get(), (BlockPos)pos, found);
            }
            return null;
        }, o -> new NodeHitResult(end, null, null)));
    }
}

