/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.furniture.refurbished.network.play.ClientPlayHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;

public record MessageToolAnimation(Tool tool, BlockPos pos, Direction direction) {
    public static void encode(MessageToolAnimation message, FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)message.tool);
        buffer.writeBlockPos(message.pos);
        buffer.writeEnum((Enum)message.direction);
    }

    public static MessageToolAnimation decode(FriendlyByteBuf buffer) {
        Tool tool = (Tool)buffer.readEnum(Tool.class);
        BlockPos pos = buffer.readBlockPos();
        Direction direction = (Direction)buffer.readEnum(Direction.class);
        return new MessageToolAnimation(tool, pos, direction);
    }

    public static void handle(MessageToolAnimation message, MessageContext context) {
        context.execute(() -> ClientPlayHandler.handleMessageToolAnimation(message));
        context.setHandled(true);
    }

    public static enum Tool {
        SPATULA,
        KNIFE;

    }
}

