/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.util;

import com.google.gson.JsonObject;
import com.mrcrayfish.furniture.refurbished.util.ItemHash;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

public class Utils {
    public static ResourceLocation resource(String name) {
        return new ResourceLocation("refurbished_furniture", name);
    }

    public static MutableComponent translation(String category, String path, Object ... params) {
        return Component.translatable((String)String.format("%s.%s.%s", category, "refurbished_furniture", path), (Object[])params);
    }

    public static String translationKey(String category, String path) {
        return String.format("%s.%s.%s", category, "refurbished_furniture", path);
    }

    public static <T> void shuffle(List<T> list, RandomSource random) {
        for (int i = list.size() - 1; i > 0; --i) {
            int randIndex = random.nextIntBetweenInclusive(0, i);
            T temp = list.get(i);
            list.set(i, list.get(randIndex));
            list.set(randIndex, temp);
        }
    }

    public static <T> List<T> concat(Collection<T> a, Collection<T> b) {
        return Stream.concat(a.stream(), b.stream()).collect(Collectors.toList());
    }

    public static double pixels(double value) {
        return value * 0.0625;
    }

    public static Map<Item, Integer> countItems(boolean skipDamaged, List<Pair<Direction, Container>> containers) {
        Object2IntOpenCustomHashMap map = new Object2IntOpenCustomHashMap((Hash.Strategy)ItemHash.INSTANCE);
        for (Pair<Direction, Container> pair : containers) {
            Direction direction = (Direction)pair.first();
            Container container = (Container)pair.second();
            Utils.getContainerSlots(container, direction).forEach(arg_0 -> Utils.lambda$countItems$0(container, skipDamaged, direction, (Map)map, arg_0));
        }
        return map;
    }

    public static int countItem(Item item, Container container) {
        return IntStream.range(0, container.getContainerSize()).mapToObj(arg_0 -> ((Container)container).getItem(arg_0)).filter(stack -> stack.is(item)).map(ItemStack::getCount).reduce(Integer::sum).orElse(0);
    }

    public static IntStream getContainerSlots(Container container, @Nullable Direction direction) {
        if (direction != null && container instanceof WorldlyContainer) {
            WorldlyContainer worldly = (WorldlyContainer)container;
            return IntStream.of(worldly.getSlotsForFace(direction));
        }
        return IntStream.range(0, container.getContainerSize());
    }

    public static boolean canTakeFromContainer(Container container, int slot, ItemStack stack, @Nullable Direction direction) {
        if (container.canTakeItem(container, slot, stack)) {
            if (direction != null && container instanceof WorldlyContainer) {
                WorldlyContainer worldly = (WorldlyContainer)container;
                return worldly.canTakeItemThroughFace(slot, stack, direction);
            }
            return true;
        }
        return false;
    }

    public static Ingredient getIngredient(JsonObject object, String key) {
        return null;
    }

    public static ItemStack getItemStack(JsonObject object, String key) {
        if (GsonHelper.isStringValue((JsonObject)object, (String)key)) {
            ResourceLocation id = new ResourceLocation(GsonHelper.getAsString((JsonObject)object, (String)key));
            Item item = (Item)BuiltInRegistries.ITEM.getOptional(id).orElseThrow(() -> new IllegalStateException("The item '%s' does not exist".formatted(id)));
            return new ItemStack((ItemLike)item);
        }
        if (GsonHelper.isObjectNode((JsonObject)object, (String)key)) {
            JsonObject itemObject = GsonHelper.getAsJsonObject((JsonObject)object, (String)key);
            ResourceLocation id = new ResourceLocation(GsonHelper.getAsString((JsonObject)itemObject, (String)"item"));
            Item item = (Item)BuiltInRegistries.ITEM.getOptional(id).orElseThrow(() -> new IllegalStateException("The item '%s' does not exist".formatted(id)));
            int count = GsonHelper.getAsInt((JsonObject)itemObject, (String)"count", (int)1);
            return new ItemStack((ItemLike)item, count);
        }
        throw new IllegalStateException("'%s' must be either a string or object".formatted(key));
    }

    public static Fluid getFluid(JsonObject object, String key) {
        ResourceLocation id = new ResourceLocation(GsonHelper.getAsString((JsonObject)object, (String)key));
        return (Fluid)BuiltInRegistries.FLUID.getOptional(id).orElseThrow(() -> new RuntimeException("The fluid '%s' does not exist".formatted(id)));
    }

    public static String getItemName(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getPath();
    }

    private static /* synthetic */ void lambda$countItems$0(Container container, boolean skipDamaged, Direction direction, Map map, int slot) {
        ItemStack stack = container.getItem(slot);
        if (stack.isEmpty() || skipDamaged && stack.isDamaged()) {
            return;
        }
        if (!Utils.canTakeFromContainer(container, slot, stack, direction)) {
            return;
        }
        map.merge(stack.getItem(), stack.getCount(), Integer::sum);
    }
}

