/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.BathBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3542;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_6862;

public abstract class BathBlock
extends FurnitureHorizontalEntityBlock
implements BlockTagSupplier {
    protected static final class_265 BASE_SHAPE = class_2248.method_9541((double)0.0, (double)2.0, (double)0.0, (double)32.0, (double)16.0, (double)16.0);
    protected static final class_265 COLLISION_SHAPE = class_259.method_1072((class_265)BASE_SHAPE, (class_265)class_2248.method_9541((double)2.0, (double)4.0, (double)2.0, (double)28.0, (double)16.0, (double)14.0), (class_247)class_247.field_16886);
    public static final class_2754<Type> TYPE = class_2754.method_11850((String)"type", Type.class);

    public BathBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)DIRECTION, (Comparable)class_2350.field_11043)).method_11657(TYPE, (Comparable)((Object)Type.BOTTOM)));
    }

    @Override
    protected Map<class_2680, class_265> generateShapes(ImmutableList<class_2680> states) {
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, state -> {
            if (state.method_11654(TYPE) == Type.HEAD) {
                return VoxelShapeHelper.rotateHorizontally(BASE_SHAPE.method_1096(-1.0, 0.0, 0.0), (class_2350)state.method_11654((class_2769)DIRECTION));
            }
            return VoxelShapeHelper.rotateHorizontally(BASE_SHAPE, (class_2350)state.method_11654((class_2769)DIRECTION));
        })));
    }

    public class_265 method_9549(class_2680 state, class_1922 getter, class_2338 pos, class_3726 context) {
        if (state.method_11654(TYPE) == Type.HEAD) {
            return VoxelShapeHelper.rotateHorizontally(COLLISION_SHAPE.method_1096(-1.0, 0.0, 0.0), (class_2350)state.method_11654((class_2769)DIRECTION));
        }
        return VoxelShapeHelper.rotateHorizontally(COLLISION_SHAPE, (class_2350)state.method_11654((class_2769)DIRECTION));
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2338 headPos;
        class_2350 direction = context.method_8042();
        class_1937 level = context.method_8045();
        if (level.method_8320(headPos = context.method_8037().method_10093(direction)).method_26166(context) && level.method_8621().method_11952(headPos)) {
            return (class_2680)this.method_9564().method_11657((class_2769)DIRECTION, (Comparable)direction);
        }
        return null;
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 entity, class_1799 stack) {
        super.method_9567(level, pos, state, entity, stack);
        if (!level.method_8608()) {
            class_2338 headPos = pos.method_10093((class_2350)state.method_11654((class_2769)DIRECTION));
            level.method_8652(headPos, (class_2680)state.method_11657(TYPE, (Comparable)((Object)Type.HEAD)), 3);
            level.method_8408(pos, class_2246.field_10124);
            state.method_30101((class_1936)level, pos, 3);
        }
    }

    @Override
    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        super.method_9536(state, level, pos, newState, isMoving);
        if (!state.method_27852(newState.method_26204())) {
            class_2350 direction = (class_2350)state.method_11654((class_2769)DIRECTION);
            Type type = (Type)((Object)state.method_11654(TYPE));
            class_2338 otherPos = pos.method_10093(type == Type.HEAD ? direction.method_10153() : direction);
            class_2680 otherState = level.method_8320(otherPos);
            if (otherState.method_26204() instanceof BathBlock && otherState.method_11654(TYPE) != type) {
                level.method_8650(otherPos, false);
            }
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 result) {
        class_2586 class_25862;
        if (!level.method_8608() && (class_25862 = level.method_8321(pos)) instanceof BathBlockEntity) {
            BathBlockEntity bath = (BathBlockEntity)class_25862;
            return bath.interact(player, hand, result);
        }
        return class_1269.field_5812;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{TYPE});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BathBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        if (level.method_8608()) {
            return BathBlock.createTicker(type, (class_2591)ModBlockEntities.BATH.get(), BathBlockEntity::clientTick);
        }
        return null;
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 source) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof BathBlockEntity) {
            BathBlockEntity bath = (BathBlockEntity)class_25862;
            FluidContainer container = bath.getFluidContainer();
            if (container == null || container.isEmpty()) {
                return;
            }
            double fullness = (double)container.getStoredAmount() / (double)container.getCapacity();
            if (fullness < 0.6) {
                return;
            }
            container.getStoredFluid().method_15785().method_15768(level, pos, source);
        }
    }

    public void method_9548(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof BathBlockEntity) {
            BathBlockEntity bath = (BathBlockEntity)class_25862;
            FluidContainer container = bath.getFluidContainer();
            if (container == null || container.isEmpty()) {
                return;
            }
            double fullness = (double)container.getStoredAmount() / (double)container.getCapacity();
            double startY = (double)pos.method_10264() + 0.25;
            double endY = (double)pos.method_10264() + 0.9375 * fullness;
            if (entity.method_23318() < startY || entity.method_23318() > endY) {
                return;
            }
            if (container.getStoredFluid().method_15780((class_3611)class_3612.field_15908)) {
                entity.method_5730();
            } else if (container.getStoredFluid().method_15780((class_3611)class_3612.field_15910)) {
                if (!entity.method_5701() && entity.field_28629) {
                    float volume = 0.7f;
                    float pitch = 1.6f + 0.4f * (level.field_9229.method_43057() - level.field_9229.method_43057());
                    level.method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_15222, entity.method_5634(), volume, pitch);
                }
                entity.method_5646();
            }
        }
    }

    @Override
    public List<class_6862<class_2248>> getTags() {
        return List.of(class_3481.field_33715);
    }

    public static enum Type implements class_3542
    {
        HEAD("head"),
        BOTTOM("bottom");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

