/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.core.ModTags;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.entity.Seat;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_6862;

public class ChairBlock
extends FurnitureHorizontalBlock
implements BlockTagSupplier {
    private static final MapCodec<ChairBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_4719.field_46535.fieldOf("wood_type").forGetter(block -> block.type), (App)ChairBlock.method_54096()).apply((Applicative)builder, ChairBlock::new));
    public static final class_2746 TUCKED = class_2746.method_11825((String)"tucked");
    private final class_4719 type;

    public ChairBlock(class_4719 type, class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)DIRECTION, (Comparable)class_2350.field_11043)).method_11657((class_2769)TUCKED, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public class_4719 getWoodType() {
        return this.type;
    }

    protected MapCodec<ChairBlock> method_53969() {
        return CODEC;
    }

    @Override
    protected Map<class_2680, class_265> generateShapes(ImmutableList<class_2680> states) {
        class_265 backrestShape = class_2248.method_9541((double)12.0, (double)10.0, (double)2.0, (double)14.0, (double)20.0, (double)14.0);
        class_265 seatShape = class_2248.method_9541((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
        class_265 backLeftLegShape = class_259.method_1081((double)0.75, (double)0.0, (double)0.75, (double)0.875, (double)0.5, (double)0.875);
        class_265 backRightLegShape = class_259.method_1081((double)0.75, (double)0.0, (double)0.125, (double)0.875, (double)0.5, (double)0.25);
        class_265 frontLeftLegShape = class_259.method_1081((double)0.125, (double)0.0, (double)0.75, (double)0.25, (double)0.5, (double)0.875);
        class_265 frontRightLegShape = class_259.method_1081((double)0.125, (double)0.0, (double)0.125, (double)0.25, (double)0.5, (double)0.25);
        class_265 chairShape = VoxelShapeHelper.combine(List.of(backrestShape, seatShape, backLeftLegShape, backRightLegShape, frontLeftLegShape, frontRightLegShape));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (class_2680 state : states) {
            class_2350 direction = (class_2350)state.method_11654((class_2769)DIRECTION);
            class_265 rotatedChairShape = VoxelShapeHelper.rotateHorizontally(chairShape, direction);
            if (((Boolean)state.method_11654((class_2769)TUCKED)).booleanValue()) {
                rotatedChairShape = rotatedChairShape.method_1096(-0.5 * (double)direction.method_10148(), 0.0, -0.5 * (double)direction.method_10165());
            }
            builder.put((Object)state, (Object)rotatedChairShape);
        }
        return builder.build();
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 neighbourBlock, class_2338 neighbourPos, boolean $$5) {
        if (!this.canTuck(state, level, pos) && ((Boolean)state.method_11654((class_2769)TUCKED)).booleanValue()) {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)TUCKED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 result) {
        if (player.method_18276() && Seat.availableAt(level, pos) && this.canTuck(state, level, pos)) {
            level.method_8396(null, pos, (class_3414)ModSounds.BLOCK_CHAIR_SLIDE.get(), class_3419.field_15245, 1.0f, 0.9f + 0.1f * level.field_9229.method_43057());
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)TUCKED, (Comparable)Boolean.valueOf((Boolean)state.method_11654((class_2769)TUCKED) == false)), 3);
            return class_1269.field_5812;
        }
        if (!((Boolean)state.method_11654((class_2769)TUCKED)).booleanValue() && Seat.sit(player, pos, Utils.pixels(10.0), ((class_2350)state.method_11654((class_2769)DIRECTION)).method_10153())) {
            return class_1269.field_21466;
        }
        return class_1269.field_5812;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{TUCKED});
    }

    @Override
    public List<class_6862<class_2248>> getTags() {
        return List.of(class_3481.field_33713);
    }

    protected boolean canTuck(class_2680 state, class_1937 level, class_2338 pos) {
        class_2338 front = pos.method_10093(((class_2350)state.method_11654((class_2769)DIRECTION)).method_10153());
        return level.method_8320(front).method_26164(ModTags.Blocks.TUCKABLE);
    }
}

