/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.block.FryingPanBlock;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.GrillBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_6862;

public class GrillBlock
extends FurnitureHorizontalEntityBlock
implements BlockTagSupplier {
    private static final MapCodec<GrillBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_1767.field_41600.fieldOf("color").forGetter(block -> block.color), (App)GrillBlock.method_54096()).apply((Applicative)builder, GrillBlock::new));
    private final class_1767 color;

    public GrillBlock(class_1767 color, class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)DIRECTION, (Comparable)class_2350.field_11043));
        this.color = color;
    }

    public class_1767 getDyeColor() {
        return this.color;
    }

    protected MapCodec<GrillBlock> method_53969() {
        return CODEC;
    }

    @Override
    protected Map<class_2680, class_265> generateShapes(ImmutableList<class_2680> states) {
        class_265 baseShape = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, o -> baseShape)));
    }

    @Override
    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (state.method_26204() != newState.method_26204()) {
            class_2586 class_25862 = level.method_8321(pos);
            if (class_25862 instanceof GrillBlockEntity) {
                GrillBlockEntity grill = (GrillBlockEntity)class_25862;
                class_1264.method_17349((class_1937)level, (class_2338)pos, grill.getCookingItems());
                class_1264.method_17349((class_1937)level, (class_2338)pos, grill.getFuelItems());
            }
            super.method_9536(state, level, pos, newState, isMoving);
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 result) {
        class_2586 class_25862;
        if (!level.method_8608() && result.method_17780() == class_2350.field_11036 && (class_25862 = level.method_8321(pos)) instanceof GrillBlockEntity) {
            GrillBlockEntity grill = (GrillBlockEntity)class_25862;
            class_1799 stack = player.method_5998(hand);
            if (stack.method_7909() == ModItems.SPATULA.get()) {
                grill.flipItem(this.getGrillQuadrant(result));
                FryingPanBlock.playSpatulaScoopSound(level, pos.method_10084(), 0.0);
            } else if (grill.addFuel(stack)) {
                stack.method_7934(1);
                level.method_8396(null, pos, class_3417.field_21930, class_3419.field_15245, 1.0f, 1.5f);
            } else if (!stack.method_7960()) {
                if (grill.addCookingItem(stack, this.getGrillQuadrant(result), player.method_5735().method_10161()) && !player.method_31549().field_7477) {
                    stack.method_7934(1);
                }
            } else {
                grill.removeCookingItem(this.getGrillQuadrant(result));
            }
        }
        return class_1269.field_5812;
    }

    private int getGrillQuadrant(class_3965 hit) {
        class_2338 pos = hit.method_17777();
        class_243 hitVec = hit.method_17784().method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        return (hitVec.method_10216() > 0.5 ? 1 : 0) + (hitVec.method_10215() > 0.5 ? 2 : 0);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new GrillBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        if (level.method_8608()) {
            return GrillBlock.createTicker(type, (class_2591)ModBlockEntities.GRILL.get(), GrillBlockEntity::clientTick);
        }
        return GrillBlock.createTicker(type, (class_2591)ModBlockEntities.GRILL.get(), GrillBlockEntity::serverTick);
    }

    @Override
    public List<class_6862<class_2248>> getTags() {
        return List.of(class_3481.field_33715, class_3481.field_33719);
    }
}

