/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.entity.Seat;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3542;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_6862;

public class SofaBlock
extends FurnitureHorizontalBlock
implements BlockTagSupplier {
    private static final MapCodec<SofaBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_1767.field_41600.fieldOf("color").forGetter(block -> block.color), (App)SofaBlock.method_54096()).apply((Applicative)builder, SofaBlock::new));
    public static final class_2754<Shape> SHAPE = class_2754.method_11850((String)"shape", Shape.class);
    private final class_1767 color;

    public SofaBlock(class_1767 color, class_4970.class_2251 properties) {
        super(properties);
        this.color = color;
    }

    public class_1767 getDyeColor() {
        return this.color;
    }

    protected MapCodec<SofaBlock> method_53969() {
        return CODEC;
    }

    @Override
    protected Map<class_2680, class_265> generateShapes(ImmutableList<class_2680> states) {
        class_265 baseShape = class_2248.method_9541((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
        class_265 frontLeftLegShape = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0);
        class_265 frontRightLegShape = class_2248.method_9541((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0);
        class_265 backLeftLegShape = class_2248.method_9541((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0);
        class_265 backRightLegShape = class_2248.method_9541((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0);
        class_265 leftArmShape = class_2248.method_9541((double)0.0, (double)6.0, (double)-2.0, (double)16.0, (double)14.0, (double)2.0);
        class_265 rightArmShape = class_2248.method_9541((double)0.0, (double)6.0, (double)14.0, (double)16.0, (double)14.0, (double)18.0);
        class_265 backRestShape = class_2248.method_9541((double)12.0, (double)10.0, (double)0.0, (double)16.0, (double)20.0, (double)16.0);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, state -> {
            ArrayList<class_265> shapes = new ArrayList<class_265>();
            shapes.add(baseShape);
            shapes.add(backRestShape);
            switch ((Shape)((Object)((Object)state.method_11654(SHAPE)))) {
                case DEFAULT: {
                    shapes.add(frontLeftLegShape);
                    shapes.add(frontRightLegShape);
                    shapes.add(backLeftLegShape);
                    shapes.add(backRightLegShape);
                    shapes.add(leftArmShape);
                    shapes.add(rightArmShape);
                    break;
                }
                case LEFT: {
                    shapes.add(frontLeftLegShape);
                    shapes.add(backLeftLegShape);
                    shapes.add(leftArmShape);
                    break;
                }
                case RIGHT: {
                    shapes.add(frontRightLegShape);
                    shapes.add(backRightLegShape);
                    shapes.add(rightArmShape);
                    break;
                }
                case CORNER_LEFT: {
                    shapes.add(backLeftLegShape);
                    shapes.add(VoxelShapeHelper.rotateHorizontally(backRestShape, class_2350.field_11043));
                    break;
                }
                case CORNER_RIGHT: {
                    shapes.add(backRightLegShape);
                    shapes.add(VoxelShapeHelper.rotateHorizontally(backRestShape, class_2350.field_11035));
                }
            }
            return VoxelShapeHelper.rotateHorizontally(VoxelShapeHelper.combine(shapes), (class_2350)state.method_11654((class_2769)DIRECTION));
        })));
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 state = super.method_9605(context);
        if (state != null) {
            return (class_2680)state.method_11657(SHAPE, (Comparable)((Object)this.getShape(state, (class_1936)context.method_8045(), context.method_8037())));
        }
        return null;
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 result) {
        if (Seat.sit(player, pos, Utils.pixels(10.0), ((class_2350)state.method_11654((class_2769)DIRECTION)).method_10153())) {
            return class_1269.field_21466;
        }
        return class_1269.field_5812;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 level, class_2338 pos, class_2338 newPos) {
        return (class_2680)state.method_11657(SHAPE, (Comparable)((Object)this.getShape(state, level, pos)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{SHAPE});
    }

    public Shape getShape(class_2680 state, class_1936 level, class_2338 pos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)DIRECTION);
        class_2350 front = this.getSofaDirection(level, pos, facing.method_10153());
        if (front != null) {
            if (front == facing.method_10170()) {
                return Shape.CORNER_RIGHT;
            }
            if (front == facing.method_10160()) {
                return Shape.CORNER_LEFT;
            }
        }
        boolean left = this.isConnectable(level, pos, facing, facing.method_10160());
        boolean right = this.isConnectable(level, pos, facing, facing.method_10170());
        if (left && right) {
            return Shape.MIDDLE;
        }
        if (left) {
            return Shape.RIGHT;
        }
        if (right) {
            return Shape.LEFT;
        }
        return Shape.DEFAULT;
    }

    private class_2350 getSofaDirection(class_1936 level, class_2338 pos, class_2350 side) {
        class_2680 relativeState = level.method_8320(pos.method_10093(side));
        return relativeState.method_26204() instanceof SofaBlock ? (class_2350)relativeState.method_11654((class_2769)DIRECTION) : null;
    }

    private boolean isConnectable(class_1936 level, class_2338 pos, class_2350 facing, class_2350 offset) {
        class_2338 relativePos = pos.method_10093(offset);
        class_2680 relativeState = level.method_8320(pos.method_10093(offset));
        if (relativeState.method_26204() instanceof SofaBlock) {
            class_2350 other = (class_2350)relativeState.method_11654((class_2769)DIRECTION);
            return other == facing || other == offset;
        }
        return relativeState.method_26206((class_1922)level, relativePos, offset.method_10153());
    }

    @Override
    public List<class_6862<class_2248>> getTags() {
        return List.of(class_3481.field_33713);
    }

    public static enum Shape implements class_3542
    {
        DEFAULT("default"),
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle"),
        CORNER_LEFT("corner_left"),
        CORNER_RIGHT("corner_right");

        private final String name;

        private Shape(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

