/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.block.BathBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.IWaterTap;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.IFluidContainerBlock;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModParticleTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWaterTapAnimation;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_5328;
import net.minecraft.class_5712;

public class BathBlockEntity
extends class_2586
implements IFluidContainerBlock,
IWaterTap {
    protected final FluidContainer tank;
    private int animationTime;

    public BathBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591)ModBlockEntities.BATH.get(), pos, state);
    }

    public BathBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.tank = this.createFluidContainer(state);
    }

    public boolean isHead() {
        return this.tank != null;
    }

    @Override
    public FluidContainer getFluidContainer() {
        return this.tank != null ? this.tank : this.getFluidContainerFromHead();
    }

    @Nullable
    private FluidContainer getFluidContainerFromHead() {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)BathBlock.DIRECTION)) {
            class_2350 direction = (class_2350)state.method_11654((class_2769)BathBlock.DIRECTION);
            class_1937 level = Objects.requireNonNull(this.field_11863);
            class_2586 class_25862 = level.method_8321(this.field_11867.method_10093(direction));
            if (class_25862 instanceof BathBlockEntity) {
                BathBlockEntity bath = (BathBlockEntity)class_25862;
                return bath.getFluidContainer();
            }
        }
        return null;
    }

    @Nullable
    private FluidContainer createFluidContainer(class_2680 state) {
        if (state.method_28498(BathBlock.TYPE) && state.method_11654(BathBlock.TYPE) == BathBlock.Type.HEAD) {
            return FluidContainer.create((Long)Config.SERVER.bath.fluidCapacity.get(), container -> {
                this.method_5431();
                container.sync(this);
            });
        }
        return null;
    }

    public class_1269 interact(class_1657 player, class_1268 hand, class_3965 result) {
        class_1792 item;
        FluidContainer tank = this.getFluidContainer();
        if (tank == null) {
            return class_1269.field_5811;
        }
        class_1799 heldItem = player.method_5998(hand);
        if (((Boolean)Config.SERVER.bath.dispenseWater.get()).booleanValue() && heldItem.method_7960()) {
            Pair<class_3611, Long> drained;
            long filled;
            if ((tank.isEmpty() || tank.getStoredFluid().method_15780((class_3611)class_3612.field_15910)) && (filled = tank.push((class_3611)class_3612.field_15910, FluidContainer.BUCKET_CAPACITY, false)) > 0L) {
                this.sendTapWaterAnimation();
                Objects.requireNonNull(this.field_11863).method_45447(null, this.field_11867, (class_3414)ModSounds.BLOCK_KITCHEN_SINK_FILL.get(), class_3419.field_15245);
                return class_1269.field_5812;
            }
            if (tank.getStoredAmount() >= FluidContainer.BUCKET_CAPACITY && tank.getStoredFluid().method_15780((class_3611)class_3612.field_15908) && (Long)(drained = tank.pull(FluidContainer.BUCKET_CAPACITY, true)).right() == FluidContainer.BUCKET_CAPACITY) {
                tank.pull(FluidContainer.BUCKET_CAPACITY, false);
                class_243 pos = class_243.method_24955((class_2382)this.field_11867).method_1031(0.0, 1.0, 0.0);
                class_1937 level = Objects.requireNonNull(this.field_11863);
                class_1542 entity = new class_1542(level, pos.field_1352, pos.field_1351, pos.field_1350, new class_1799((class_1935)class_2246.field_10540));
                entity.method_6988();
                level.method_8649((class_1297)entity);
                level.method_45447(null, this.field_11867, class_3417.field_19198, class_3419.field_15245);
                level.method_20290(1501, this.field_11867, 0);
                this.sendTapWaterAnimation();
                return class_1269.field_5812;
            }
        }
        if ((item = heldItem.method_7909()) == class_1802.field_8469 && !this.tank.isEmpty() && this.tank.getStoredFluid().method_15780((class_3611)class_3612.field_15910)) {
            this.tank.pull(FluidContainer.BUCKET_CAPACITY, false);
            player.method_6122(hand, class_5328.method_30012((class_1799)heldItem, (class_1657)player, (class_1799)class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)class_1847.field_8991)));
            player.method_7259(class_3468.field_15372.method_14956((Object)item));
            player.method_37908().method_8396(null, this.field_11867, class_3417.field_14779, class_3419.field_15245, 1.0f, 1.0f);
            player.method_37908().method_33596(null, class_5712.field_28167, this.field_11867);
            return class_1269.field_5812;
        }
        return Services.FLUID.performInteractionWithBlock(player, hand, this.method_10997(), this.method_11016(), result.method_17780());
    }

    private void sendTapWaterAnimation() {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)BathBlock.DIRECTION)) {
            class_2338 tapPos = this.isHead() ? this.field_11867 : this.field_11867.method_10093((class_2350)state.method_11654((class_2769)BathBlock.DIRECTION));
            Network.getPlay().sendToTrackingBlockEntity(() -> this, (Object)new MessageWaterTapAnimation(tapPos));
        }
    }

    @Override
    public void playWaterAnimation() {
        if (this.isHead()) {
            this.animationTime = 4;
        }
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, BathBlockEntity bath) {
        if (bath.animationTime > 0) {
            class_243 tap = class_243.method_24955((class_2382)pos).method_1031(0.0, Utils.pixels(18.0), 0.0);
            tap = tap.method_43206((class_2350)state.method_11654((class_2769)BathBlock.DIRECTION), Utils.pixels(2.0));
            for (int i = 0; i < 5; ++i) {
                double x = tap.field_1352 + Utils.pixels(0.5) * level.field_9229.method_43059();
                double z = tap.field_1350 + Utils.pixels(0.5) * level.field_9229.method_43059();
                level.method_8406((class_2394)ModParticleTypes.TAP_WATER.get(), x, tap.field_1351, z, 0.0, 0.0, 0.0);
            }
            --bath.animationTime;
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (this.tank != null) {
            this.tank.load(tag.method_10562("FluidTank"));
        }
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (this.tank != null) {
            class_2487 tankTag = new class_2487();
            this.tank.save(tankTag);
            tag.method_10566("FluidTank", (class_2520)tankTag);
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }
}

