/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.google.common.base.Preconditions;
import com.mrcrayfish.furniture.refurbished.blockentity.BasicLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.CuttingBoardCombiningRecipe;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3956;
import net.minecraft.class_3972;
import net.minecraft.class_5819;
import net.minecraft.class_8786;

public class CuttingBoardBlockEntity
extends BasicLootBlockEntity {
    private final class_1863.class_7266<class_1263, ? extends class_3972> slicingRecipeCache;
    private final class_1863.class_7266<class_1263, CuttingBoardCombiningRecipe> combiningRecipeCache;
    private final class_1863.class_7266<class_1263, ? extends class_3972> outputCache;
    protected final int useableContainerSize;
    protected boolean sync;
    protected boolean canExtract;
    protected boolean placedByPlayer;

    public CuttingBoardBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591)ModBlockEntities.CUTTING_BOARD.get(), pos, state, 5, (class_3956<? extends class_3972>)((class_3956)ModRecipeTypes.CUTTING_BOARD_SLICING.get()), (class_3956<CuttingBoardCombiningRecipe>)((class_3956)ModRecipeTypes.CUTTING_BOARD_COMBINING.get()));
    }

    public CuttingBoardBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, int containerSize, class_3956<? extends class_3972> slicingRecipeType, class_3956<CuttingBoardCombiningRecipe> combiningRecipeType) {
        super(type, pos, state, containerSize + 1);
        this.useableContainerSize = containerSize;
        this.slicingRecipeCache = class_1863.method_42302(slicingRecipeType);
        this.combiningRecipeCache = class_1863.method_42302(combiningRecipeType);
        this.outputCache = class_1863.method_42302(slicingRecipeType);
    }

    @Override
    public boolean isMatchingContainerMenu(class_1703 menu) {
        return false;
    }

    protected class_2561 method_17823() {
        return Utils.translation("container", "cutting_board", new Object[0]);
    }

    protected class_1703 method_5465(int windowId, class_1661 playerInventory) {
        return null;
    }

    public boolean placeItem(class_1799 heldItem) {
        int placeIndex = this.getPlaceIndex();
        if (this.method_5437(placeIndex, heldItem)) {
            class_1799 copy = heldItem.method_7972();
            copy.method_7939(1);
            heldItem.method_7934(1);
            if (!this.field_11863.method_8608()) {
                this.placedByPlayer = true;
                this.canExtract = false;
                this.playPlaceIngredientSound(1.0f);
            }
            this.method_5447(placeIndex, copy);
            return true;
        }
        return false;
    }

    public void removeItem() {
        int removeIndex = this.getHeadIndex();
        if (removeIndex >= 0 && !this.method_5438(removeIndex).method_7960()) {
            class_1799 stack = this.method_5438(removeIndex);
            this.spawnItemIntoLevel(this.field_11863, stack);
            this.method_5447(removeIndex, class_1799.field_8037);
            this.canExtract = false;
        }
    }

    public boolean sliceItem(class_1937 level, boolean spawnIntoLevel) {
        int sliceIndex = this.getHeadIndex();
        if (sliceIndex != 0) {
            return false;
        }
        class_1799 input = this.method_5438(sliceIndex);
        Optional<? extends class_3972> recipe = this.getSlicingRecipe(input);
        if (recipe.isPresent()) {
            if (!this.field_11863.method_8608()) {
                level.method_8396(null, this.field_11867, (class_3414)ModSounds.ITEM_KNIFE_CHOP.get(), class_3419.field_15245, 1.0f, 1.0f);
                this.spawnSliceParticles(input);
                this.spawnSliceResultFromRecipe(sliceIndex, recipe.get(), spawnIntoLevel);
            }
            return true;
        }
        return false;
    }

    private void spawnSliceParticles(class_1799 stack) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_2338 pos = this.field_11867;
            class_5819 rand = serverLevel.method_8409();
            for (int i = 0; i < 8; ++i) {
                serverLevel.method_14199((class_2394)new class_2392(class_2398.field_11218, stack), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.1, (double)pos.method_10260() + 0.5, 1, rand.method_43059() * 0.15, rand.method_43058() * 0.2, rand.method_43059() * 0.15, 0.0);
            }
        }
    }

    private void spawnMagicParticles() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_2338 pos = this.field_11867;
            class_5819 rand = serverLevel.method_8409();
            for (int i = 0; i < 8; ++i) {
                double x = (double)pos.method_10263() + 0.5 + 0.3 * rand.method_43059();
                double y = (double)pos.method_10264() + 0.1;
                double z = (double)pos.method_10260() + 0.5 + 0.3 * rand.method_43059();
                serverLevel.method_14199((class_2394)class_2398.field_17741, x, y, z, 1, rand.method_43059() * 0.02, rand.method_43059() * 0.02, rand.method_43059() * 0.02, 0.0);
            }
        }
    }

    private void spawnSliceResultFromRecipe(int sliceIndex, class_3972 recipe, boolean spawnIntoLevel) {
        Preconditions.checkNotNull((Object)this.field_11863);
        class_1799 result = recipe.method_8110(this.field_11863.method_30349());
        if (spawnIntoLevel) {
            this.spawnItemIntoLevel(this.field_11863, result);
            this.method_5447(sliceIndex, class_1799.field_8037);
            return;
        }
        this.method_5447(sliceIndex, result.method_7972());
        this.canExtract = true;
    }

    private void spawnItemIntoLevel(class_1937 level, class_1799 stack) {
        class_2338 pos = this.field_11867;
        class_1542 entity = new class_1542(level, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.0625, (double)pos.method_10260() + 0.5, stack.method_7972());
        entity.method_6988();
        entity.method_18799(new class_243(0.0, 0.15, 0.0));
        level.method_8649((class_1297)entity);
    }

    private void playPlaceIngredientSound(float pitch) {
        class_1937 level = Objects.requireNonNull(this.field_11863);
        class_243 vec = class_243.method_24955((class_2382)this.field_11867);
        level.method_43128(null, vec.field_1352, vec.field_1351, vec.field_1350, (class_3414)ModSounds.BLOCK_CUTTING_BOARD_PLACED_INGREDIENT.get(), class_3419.field_15248, 1.0f, pitch + 0.05f * (float)level.field_9229.method_43059());
    }

    public int getPlaceIndex() {
        return this.getHeadIndex() + 1;
    }

    public int getHeadIndex() {
        for (int i = this.useableContainerSize - 1; i >= 0; --i) {
            if (this.method_5438(i).method_7960()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean method_5437(int slotIndex, class_1799 stack) {
        return slotIndex >= 0 && slotIndex < this.useableContainerSize && slotIndex == this.getPlaceIndex() && this.isSlotInsertable(slotIndex) && this.canPlaceOnTop(stack);
    }

    public boolean method_49104(class_1263 container, int slotIndex, class_1799 stack) {
        if (slotIndex >= 0 && slotIndex < this.useableContainerSize && slotIndex == this.getHeadIndex() && this.canExtract) {
            return this.outputCache.method_42303((class_1263)new class_1277(new class_1799[]{stack}), Objects.requireNonNull(this.field_11863)).isEmpty();
        }
        return false;
    }

    public void method_5447(int slotIndex, class_1799 stack) {
        super.method_5447(slotIndex, stack);
        if (!stack.method_7960() && this.getHeadIndex() >= 0 && !Objects.requireNonNull(this.field_11863).method_8608()) {
            this.craftCombiningRecipe(this.placedByPlayer);
        }
    }

    public class_1799 method_5434(int slotIndex, int count) {
        class_1799 stack = super.method_5434(slotIndex, count);
        if (this.method_5442()) {
            this.canExtract = false;
        }
        return stack;
    }

    @Override
    protected boolean isSlotInsertable(int slotIndex) {
        class_1799 target = this.method_5438(slotIndex);
        return target.method_7960() || target.method_7947() < target.method_7914() && target.method_7947() < 1;
    }

    public boolean canPlaceOnTop(class_1799 stack) {
        return this.getNextCombiningRecipe(stack).isPresent() || this.getHeadIndex() == -1 && this.getSlicingRecipe(stack).isPresent();
    }

    private Optional<? extends class_3972> getSlicingRecipe(class_1799 stack) {
        return this.slicingRecipeCache.method_42303((class_1263)new class_1277(new class_1799[]{stack}), Objects.requireNonNull(this.field_11863)).map(class_8786::comp_1933);
    }

    private Optional<CuttingBoardCombiningRecipe> getCombiningRecipe() {
        return this.combiningRecipeCache.method_42303((class_1263)this, Objects.requireNonNull(this.field_11863)).map(class_8786::comp_1933);
    }

    private Optional<CuttingBoardCombiningRecipe> getNextCombiningRecipe(class_1799 stack) {
        int placeIndex = this.getPlaceIndex();
        if (placeIndex >= this.useableContainerSize) {
            return Optional.empty();
        }
        class_1277 container = new class_1277(placeIndex + 1);
        IntStream.range(0, placeIndex + 1).forEach(arg_0 -> this.lambda$getNextCombiningRecipe$0((class_1263)container, arg_0));
        container.method_5447(container.method_5439() - 1, stack);
        return this.combiningRecipeCache.method_42303((class_1263)container, Objects.requireNonNull(this.field_11863)).map(class_8786::comp_1933);
    }

    private void craftCombiningRecipe(boolean spawnIntoLevel) {
        this.placedByPlayer = false;
        Optional<CuttingBoardCombiningRecipe> optional = this.getCombiningRecipe();
        if (optional.isEmpty()) {
            return;
        }
        CuttingBoardCombiningRecipe recipe = optional.get();
        if (!recipe.completelyMatches((class_1263)this)) {
            return;
        }
        class_1937 level = Objects.requireNonNull(this.field_11863);
        class_1799 stack = recipe.method_8116((class_1263)this, level.method_30349());
        List<class_1799> remainingItems = this.getCraftingRemainingItems();
        this.method_5448();
        this.method_5431();
        this.spawnSliceParticles(stack);
        this.spawnMagicParticles();
        class_243 center = class_243.method_24955((class_2382)this.field_11867);
        level.method_43128(null, center.field_1352, center.field_1351, center.field_1350, class_3417.field_14627, class_3419.field_15248, 1.0f, 1.0f);
        if (spawnIntoLevel) {
            this.spawnItemIntoLevel(level, stack);
            remainingItems.forEach(item -> this.spawnItemIntoLevel(this.field_11863, (class_1799)item));
            return;
        }
        this.method_5447(0, stack);
        for (int i = 0; i < remainingItems.size() && i < this.useableContainerSize; ++i) {
            this.method_5447(i + 1, remainingItems.get(i));
        }
        this.canExtract = true;
    }

    private List<class_1799> getCraftingRemainingItems() {
        ArrayList<class_1799> remainingItems = new ArrayList<class_1799>();
        for (int i = 0; i < this.useableContainerSize; ++i) {
            class_1792 item;
            class_1799 stack = this.method_5438(i);
            if (stack.method_7960() || !stack.method_7909().method_7857() || (item = stack.method_7909().method_7858()) == null) continue;
            remainingItems.add(new class_1799((class_1935)item));
        }
        return remainingItems;
    }

    public void method_5431() {
        super.method_5431();
        this.sync();
    }

    protected void sync() {
        this.sync = true;
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, CuttingBoardBlockEntity entity) {
        if (entity.sync) {
            BlockEntityHelper.sendCustomUpdate((class_2586)entity, entity.method_16887());
            entity.sync = false;
        }
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Override
    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10556("CanExtract", this.canExtract);
        tag.method_10556("PlacedByPlayer", this.placedByPlayer);
    }

    @Override
    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        if (compound.method_10573("CanExtract", 1)) {
            this.canExtract = compound.method_10577("CanExtract");
        }
        if (compound.method_10573("PlacedByPlayer", 1)) {
            this.placedByPlayer = compound.method_10577("PlacedByPlayer");
        }
    }

    private /* synthetic */ void lambda$getNextCombiningRecipe$0(class_1263 container, int index) {
        container.method_5447(index, this.method_5438(index));
    }
}

