/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.block.RangeHoodBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.BasicLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.FlipAnimation;
import com.mrcrayfish.furniture.refurbished.blockentity.ICookingBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ILevelAudio;
import com.mrcrayfish.furniture.refurbished.client.audio.AudioManager;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModParticleTypes;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageFlipAnimation;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1874;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2802;
import net.minecraft.class_3215;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import org.joml.Vector3f;

public class FryingPanBlockEntity
extends BasicLootBlockEntity
implements ICookingBlock,
ILevelAudio {
    public static final Vector3f OIL_COLOUR = class_243.method_24457((int)14788611).method_46409();
    public static final double MAX_AUDIO_DISTANCE = class_3532.method_34954((int)8);
    protected final class_1863.class_7266<class_1263, ? extends ProcessingRecipe> recipeCache;
    protected final class_1863.class_7266<class_1263, ? extends class_1874> campfireCookingCache;
    protected final class_243 audioPosition;
    protected boolean needsFlipping;
    protected boolean flipped;
    protected int rotation;
    protected boolean sync;
    private FlipAnimation animation;

    public FryingPanBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591)ModBlockEntities.FRYING_PAN.get(), pos, state, (class_3956<? extends ProcessingRecipe.Item>)((class_3956)ModRecipeTypes.FRYING_PAN_COOKING.get()));
    }

    public FryingPanBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, class_3956<? extends ProcessingRecipe.Item> recipeType) {
        super(type, pos, state, 1);
        this.recipeCache = class_1863.method_42302(recipeType);
        this.campfireCookingCache = class_1863.method_42302((class_3956)class_3956.field_17549);
        this.audioPosition = pos.method_46558().method_1031(0.0, -0.375, 0.0);
    }

    public boolean isFlippingNeeded() {
        return this.needsFlipping;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public int getRotation() {
        return this.rotation;
    }

    protected class_2561 method_17823() {
        return Utils.translation("container", "frying_pan", new Object[0]);
    }

    @Override
    public boolean isMatchingContainerMenu(class_1703 menu) {
        return false;
    }

    protected class_1703 method_5465(int windowId, class_1661 playerInventory) {
        return null;
    }

    public int method_5444() {
        return 1;
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, FryingPanBlockEntity fryingPan) {
        AudioManager.get().playLevelAudio(fryingPan);
        fryingPan.spawnParticles(level, pos);
        FlipAnimation animation = fryingPan.getAnimation();
        boolean wasPlaying = animation.isPlaying();
        animation.tick();
        if (wasPlaying && !animation.isPlaying()) {
            fryingPan.playPlaceIngredientSound(true, 1.0f);
        }
    }

    private void spawnParticles(class_1937 level, class_2338 pos) {
        if (this.isCooking() && !this.getAnimation().isPlaying()) {
            double posX = (double)pos.method_10263() + 0.35 + 0.3 * level.field_9229.method_43058();
            double posY = (double)pos.method_10264() + 0.15;
            double posZ = (double)pos.method_10260() + 0.35 + 0.3 * level.field_9229.method_43058();
            level.method_8406((class_2394)new class_2390(OIL_COLOUR, 0.25f), posX, posY, posZ, 0.0, -0.05, 0.0);
            this.spawnSteam(level, posX, posY, posZ);
        }
    }

    public void spawnSteam(class_1937 level, double x, double y, double z) {
        double ySpeed = 0.01;
        if (this.isRangeHoodPowered(level, this.field_11867.method_10084())) {
            ySpeed = 0.05;
        } else if (this.isRangeHoodPowered(level, this.field_11867.method_10084().method_10084())) {
            ySpeed = 0.1;
        }
        level.method_8406((class_2394)ModParticleTypes.STEAM.get(), x, y, z, 0.0, ySpeed, 0.0);
    }

    private boolean isRangeHoodPowered(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        if (state.method_26204() instanceof RangeHoodBlock) {
            return (Boolean)state.method_11654((class_2769)RangeHoodBlock.POWERED);
        }
        return false;
    }

    @Override
    public class_2586 getBlockEntity() {
        return this;
    }

    @Override
    public boolean canCook() {
        class_1799 stack = this.method_5438(0);
        if (!stack.method_7960() && !this.needsFlipping) {
            return this.getRecipe(stack).isPresent();
        }
        return false;
    }

    @Override
    public int getTimeToCook() {
        Optional<? extends ProcessingRecipe> optional;
        class_1799 stack = this.method_5438(0);
        if (!stack.method_7960() && (optional = this.getRecipe(stack)).isPresent()) {
            return optional.get().getTime() / 2;
        }
        return 0;
    }

    @Override
    public void onCompleteCooking() {
        if (!this.flipped) {
            this.needsFlipping = true;
            this.method_5431();
            return;
        }
        class_1799 stack = this.method_5438(0);
        if (!stack.method_7960()) {
            class_1792 remainingItem = stack.method_7909().method_7858();
            Optional<? extends ProcessingRecipe> optional = this.getRecipe(stack);
            class_1799 result = optional.map(recipe -> recipe.method_8110(this.field_11863.method_30349())).orElse(class_1799.field_8037);
            stack.method_7934(1);
            if (!result.method_7960()) {
                class_1799 copy = result.method_7972();
                this.method_5447(0, copy);
                if (remainingItem != null) {
                    class_2338 pos = this.field_11867;
                    this.field_11863.method_8649((class_1297)new class_1542(this.field_11863, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.1, (double)pos.method_10260() + 0.5, new class_1799((class_1935)remainingItem)));
                }
            }
        }
    }

    @Override
    public boolean method_5437(int slotIndex, class_1799 stack) {
        return slotIndex == 0 && super.method_5437(slotIndex, stack) && this.getRecipe(stack).isPresent();
    }

    public boolean method_49104(class_1263 container, int slotIndex, class_1799 stack) {
        return slotIndex == 0 && super.method_49104(container, slotIndex, stack) && this.getRecipe(stack).isEmpty();
    }

    public void method_5447(int slotIndex, class_1799 stack) {
        if (!this.isCooking() && this.getRecipe(stack).isPresent()) {
            this.flipped = false;
            this.needsFlipping = false;
        }
        super.method_5447(slotIndex, stack);
    }

    private Optional<? extends ProcessingRecipe> getRecipe(class_1799 stack) {
        Optional<? extends ProcessingRecipe> optional = this.getRecipe(this.recipeCache, stack);
        if (((Boolean)Config.SERVER.recipes.inheritCampfireRecipes.get()).booleanValue()) {
            optional = optional.isEmpty() ? this.getCookingRecipe(this.campfireCookingCache, stack) : optional;
        }
        return optional;
    }

    private Optional<? extends ProcessingRecipe> getRecipe(class_1863.class_7266<class_1263, ? extends ProcessingRecipe> cache, class_1799 stack) {
        return cache.method_42303((class_1263)new class_1277(new class_1799[]{stack}), Objects.requireNonNull(this.field_11863)).map(class_8786::comp_1933);
    }

    private Optional<ProcessingRecipe> getCookingRecipe(class_1863.class_7266<class_1263, ? extends class_1874> cache, class_1799 stack) {
        return cache.method_42303((class_1263)new class_1277(new class_1799[]{stack}), Objects.requireNonNull(this.field_11863)).map(class_8786::comp_1933).map(recipe -> ProcessingRecipe.Item.from(recipe, this.field_11863.method_30349()));
    }

    public void flipItem() {
        if (this.needsFlipping && !this.flipped) {
            this.flipped = true;
            this.needsFlipping = false;
            this.sendFlipAnimationToPlayers();
            this.method_5431();
            return;
        }
        if (!this.method_5438(0).method_7960()) {
            this.removeContents();
        }
    }

    public boolean placeContents(class_1937 level, class_1799 stack, int rotation) {
        if (!stack.method_7960() && this.method_5438(0).method_7960()) {
            class_1799 copy = stack.method_7972();
            copy.method_7939(1);
            this.method_5447(0, copy);
            this.rotation = rotation;
            this.flipped = false;
            this.needsFlipping = false;
            this.method_5431();
            this.playPlaceIngredientSound(false, 0.85f);
            return true;
        }
        this.removeContents();
        return false;
    }

    public void removeContents() {
        if (!this.method_5438(0).method_7960()) {
            class_1799 stack = this.method_5438(0);
            class_2338 pos = this.field_11867;
            class_1542 entity = new class_1542(this.field_11863, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.1, (double)pos.method_10260() + 0.5, stack.method_7972());
            this.method_5447(0, class_1799.field_8037);
            this.field_11863.method_8649((class_1297)entity);
            this.flipped = false;
            this.needsFlipping = false;
            this.method_5431();
        }
    }

    public void playFlipAnimation(int index) {
        if (Objects.requireNonNull(this.field_11863).method_8608() && index == 0) {
            this.getAnimation().play();
        }
    }

    private void sendFlipAnimationToPlayers() {
        class_1937 level = Objects.requireNonNull(this.field_11863);
        class_2802 class_28022 = level.method_8398();
        if (class_28022 instanceof class_3215) {
            class_3215 cache = (class_3215)class_28022;
            class_2338 pos = this.method_11016();
            List players = cache.field_17254.method_17210(new class_1923(pos), false);
            players.forEach(player -> Network.getPlay().sendToPlayer(() -> player, (Object)new MessageFlipAnimation(pos, 0)));
        }
    }

    public FlipAnimation getAnimation() {
        if (this.animation == null) {
            this.animation = new FlipAnimation();
        }
        return this.animation;
    }

    private void playPlaceIngredientSound(boolean client, float pitch) {
        class_1937 level = Objects.requireNonNull(this.field_11863);
        class_243 vec = class_243.method_24955((class_2382)this.field_11867);
        if (client) {
            level.method_8486(vec.field_1352, vec.field_1351, vec.field_1350, (class_3414)ModSounds.BLOCK_FRYING_PAN_PLACE_INGREDIENT.get(), class_3419.field_15248, 1.0f, pitch, false);
            return;
        }
        level.method_43128(null, vec.field_1352, vec.field_1351, vec.field_1350, (class_3414)ModSounds.BLOCK_FRYING_PAN_PLACE_INGREDIENT.get(), class_3419.field_15248, 1.0f, pitch);
    }

    public void method_5431() {
        super.method_5431();
        this.sync();
    }

    protected void sync() {
        BlockEntityHelper.sendCustomUpdate((class_2586)this, this.method_16887());
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10573("NeedsFlipping", 1)) {
            this.needsFlipping = tag.method_10577("NeedsFlipping");
        }
        if (tag.method_10573("Flipped", 1)) {
            this.flipped = tag.method_10577("Flipped");
        }
        if (tag.method_10573("Rotation", 3)) {
            this.rotation = tag.method_10550("Rotation");
        }
    }

    @Override
    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10556("NeedsFlipping", this.needsFlipping);
        tag.method_10556("Flipped", this.flipped);
        tag.method_10569("Rotation", this.rotation);
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Override
    public class_3414 getSound() {
        return (class_3414)ModSounds.BLOCK_FRYING_PAN_SIZZLING.get();
    }

    @Override
    public class_3419 getSource() {
        return class_3419.field_15245;
    }

    @Override
    public class_243 getAudioPosition() {
        return this.audioPosition;
    }

    @Override
    public boolean canPlayAudio() {
        return !this.method_11015() && (this.isCooking() || this.isPartiallyCooked());
    }

    @Override
    public float getAudioVolume() {
        return (this.isCooking() || this.isPartiallyCooked()) && !this.getAnimation().isPlaying() ? 1.0f : 0.0f;
    }

    @Override
    public float getAudioPitch() {
        return this.isPartiallyCooked() ? 0.8f : 1.0f;
    }

    @Override
    public int getAudioHash() {
        return this.field_11867.hashCode();
    }

    @Override
    public boolean isAudioEqual(ILevelAudio other) {
        return this == other;
    }

    @Override
    public double getAudioRadiusSqr() {
        return MAX_AUDIO_DISTANCE;
    }

    private boolean isPartiallyCooked() {
        return !this.method_5438(0).method_7960() && this.isFlippingNeeded();
    }
}

