/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeSerializers;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5797;
import net.minecraft.class_8790;

public class CuttingBoardCombiningRecipe
implements class_1860<class_1263> {
    public static final int MAX_INGREDIENTS = 5;
    protected final class_2371<class_1856> ingredients;
    protected final class_1799 result;

    public CuttingBoardCombiningRecipe(class_2371<class_1856> ingredients, class_1799 result) {
        this.ingredients = ingredients;
        this.result = result;
    }

    public boolean method_8115(class_1263 container, class_1937 level) {
        for (int i = 0; i < this.ingredients.size() && i < container.method_5439(); ++i) {
            if (((class_1856)this.ingredients.get(i)).method_8093(container.method_5438(i))) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_8116(class_1263 container, class_5455 access) {
        return this.result.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_5455 access) {
        return this.result;
    }

    public class_1865<?> method_8119() {
        return (class_1865)ModRecipeSerializers.CUTTING_BOARD_COMBINING_RECIPE.get();
    }

    public class_3956<?> method_17716() {
        return (class_3956)ModRecipeTypes.CUTTING_BOARD_COMBINING.get();
    }

    public class_2371<class_1856> method_8117() {
        return this.ingredients;
    }

    public class_1799 getResult() {
        return this.result;
    }

    public boolean completelyMatches(class_1263 container) {
        if (this.ingredients.size() <= container.method_5439()) {
            for (int i = 0; i < this.ingredients.size(); ++i) {
                if (((class_1856)this.ingredients.get(i)).method_8093(container.method_5438(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static class Builder
    implements class_5797 {
        private final class_2371<class_1856> ingredients = class_2371.method_10211();
        private final class_1799 result;

        public Builder(class_1799 output) {
            this.result = output;
        }

        public Builder add(class_1856 ingredient) {
            this.ingredients.add((Object)ingredient);
            return this;
        }

        public class_5797 method_33530(String name, class_175<?> criterion) {
            throw new UnsupportedOperationException("Cutting Board combining recipes don't support unlocking");
        }

        public class_5797 method_33529(@Nullable String group) {
            throw new UnsupportedOperationException("Cutting Board combining recipes don't support setting the group");
        }

        public class_1792 method_36441() {
            return this.result.method_7909();
        }

        public void method_17972(class_8790 output, class_2960 id) {
            this.validate();
            output.method_53819(id, (class_1860)new CuttingBoardCombiningRecipe(this.ingredients, this.result), null);
        }

        private void validate() {
            if (this.ingredients.size() < 2) {
                throw new IllegalStateException("Cutting Board combining recipe must have at least 2 input ingredients");
            }
            if (this.ingredients.size() > 5) {
                throw new IllegalStateException("Cutting Board combining recipe only supports up to 5 input ingredients");
            }
        }
    }

    public static class Serializer
    implements class_1865<CuttingBoardCombiningRecipe> {
        public static final Codec<CuttingBoardCombiningRecipe> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)class_1856.field_46096.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
            Object[] inputs = (class_1856[])ingredients.stream().filter(ingredient -> !ingredient.method_8103()).toArray(class_1856[]::new);
            if (inputs.length > 5) {
                return DataResult.error(() -> "Too many ingredients");
            }
            if (inputs.length == 0) {
                return DataResult.error(() -> "No ingredients");
            }
            return DataResult.success((Object)class_2371.method_10212((Object)class_1856.field_9017, (Object[])inputs));
        }, DataResult::success).forGetter(recipe -> recipe.method_8117()), (App)class_1799.field_47309.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)builder, CuttingBoardCombiningRecipe::new));

        public Codec<CuttingBoardCombiningRecipe> method_53736() {
            return CODEC;
        }

        public CuttingBoardCombiningRecipe fromNetwork(class_2540 buffer) {
            int ingredientCount = buffer.readInt();
            class_2371 ingredients = class_2371.method_10213((int)ingredientCount, (Object)class_1856.field_9017);
            IntStream.range(0, ingredientCount).forEach(i -> ingredients.set(i, (Object)class_1856.method_8086((class_2540)buffer)));
            class_1799 result = buffer.method_10819();
            return new CuttingBoardCombiningRecipe((class_2371<class_1856>)ingredients, result);
        }

        public void toNetwork(class_2540 buffer, CuttingBoardCombiningRecipe recipe) {
            buffer.method_53002(recipe.ingredients.size());
            for (class_1856 ingredient : recipe.ingredients) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10793(recipe.result);
        }
    }
}

