/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2119;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_5797;
import net.minecraft.class_7923;
import net.minecraft.class_8782;
import net.minecraft.class_8790;

public abstract class ProcessingRecipe
implements class_1860<class_1263> {
    protected final class_3956<?> type;
    protected final Category category;
    protected final class_1856 ingredient;
    protected final class_1799 result;
    protected final int time;

    public ProcessingRecipe(class_3956<?> type, Category category, class_1856 ingredient, class_1799 result, int time) {
        this.type = type;
        this.category = category;
        this.ingredient = ingredient;
        this.result = result;
        this.time = time;
    }

    public class_3956<?> method_17716() {
        return this.type;
    }

    public Category getCategory() {
        return this.category;
    }

    public class_1799 method_8110(class_5455 access) {
        return this.result;
    }

    public boolean method_8115(class_1263 container, class_1937 level) {
        return this.ingredient.method_8093(container.method_5438(0));
    }

    public class_1799 method_8116(class_1263 container, class_5455 access) {
        return this.result.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 ingredients = class_2371.method_10211();
        ingredients.add((Object)this.ingredient);
        return ingredients;
    }

    public class_1856 getIngredient() {
        return this.ingredient;
    }

    public class_1799 getResult() {
        return this.result;
    }

    public int getTime() {
        return this.time;
    }

    public static <T extends ProcessingRecipe> Builder<T> builder(Factory<T> factory, Category category, class_1856 input, class_1799 output, int processTime) {
        return new Builder<T>(factory, category, input, output, processTime);
    }

    public static enum Category implements class_3542
    {
        BLOCKS("blocks"),
        ITEMS("items"),
        FOOD("food"),
        MISC("misc");

        public static final class_3542.class_7292<Category> CODEC;
        private final String name;

        private Category(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public void toNetwork(class_2540 buf) {
            buf.method_10788(this.name, 6);
        }

        public static Category fromNetwork(class_2540 buf) {
            return Category.byName(buf.method_10800(6));
        }

        public static Category byName(String name) {
            return (Category)CODEC.method_47920(name, (Enum)MISC);
        }

        static {
            CODEC = class_3542.method_28140(Category::values);
        }
    }

    public static class Builder<T extends ProcessingRecipe>
    implements class_5797 {
        protected final Category category;
        protected final Factory<T> factory;
        protected final class_1856 input;
        protected final class_1799 output;
        protected final int processTime;
        protected final Map<String, class_175<?>> criteria = new LinkedHashMap();

        private Builder(Factory<T> factory, Category category, class_1856 input, class_1799 output, int processTime) {
            this.factory = factory;
            this.category = category;
            this.input = input;
            this.output = output;
            this.processTime = processTime;
        }

        public class_5797 method_33530(String s, class_175<?> instance) {
            this.criteria.put(s, instance);
            return this;
        }

        public class_5797 method_33529(@Nullable String group) {
            throw new UnsupportedOperationException("Group not supported for ProcessingRecipes");
        }

        public class_1792 method_36441() {
            return this.output.method_7909();
        }

        public void method_17972(class_8790 output, class_2960 id) {
            class_161.class_162 builder = output.method_53818().method_705("has_the_recipe", class_2119.method_27847((class_2960)id)).method_703(class_170.class_171.method_753((class_2960)id)).method_704(class_8782.class_8797.field_1257);
            this.criteria.forEach((arg_0, arg_1) -> ((class_161.class_162)builder).method_705(arg_0, arg_1));
            output.method_53819(id, this.factory.create(this.category, this.input, this.output, this.processTime), builder.method_695(id.method_45138("recipes/" + this.category.method_15434() + "/")));
        }
    }

    public static interface Factory<T extends ProcessingRecipe> {
        public T create(Category var1, class_1856 var2, class_1799 var3, int var4);
    }

    public static abstract class ItemWithCount
    extends ProcessingRecipe {
        public static final Codec<class_1799> ITEMSTACK = RecordCodecBuilder.create(builder -> builder.group((App)class_7923.field_41178.method_40294().fieldOf("item").forGetter(class_1799::method_41409), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(class_1799::method_7947), (App)class_2487.field_25128.optionalFieldOf("tag").forGetter(stack -> Optional.ofNullable(stack.method_7969()))).apply((Applicative)builder, class_1799::new));
        public static final Codec<class_1799> RESULT = class_5699.method_33817(ITEMSTACK, (Codec)class_1799.field_47310).xmap(either -> (class_1799)either.map(Function.identity(), Function.identity()), stack -> stack.method_7947() == 1 && stack.method_7969() == null ? Either.right((Object)stack) : Either.left((Object)stack));

        public ItemWithCount(class_3956<?> type, Category category, class_1856 ingredient, class_1799 result, int time) {
            super(type, category, ingredient, result, time);
        }

        public static class Serializer<T extends ProcessingRecipe>
        implements class_1865<T> {
            private final Factory<T> factory;
            private final int defaultTime;
            private final Codec<T> codec;

            public Serializer(Factory<T> factory, int defaultTime) {
                this.factory = factory;
                this.defaultTime = defaultTime;
                this.codec = RecordCodecBuilder.create(builder -> builder.group((App)Category.CODEC.fieldOf("category").forGetter(recipe -> recipe.category), (App)class_1856.field_46096.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)RESULT.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.fieldOf("time").orElse((Object)this.defaultTime).forGetter(recipe -> recipe.time)).apply((Applicative)builder, this.factory::create));
            }

            public Codec<T> method_53736() {
                return this.codec;
            }

            public T fromNetwork(class_2540 buf) {
                Category category = Category.fromNetwork(buf);
                class_1856 input = class_1856.method_8086((class_2540)buf);
                class_1799 output = buf.method_10819();
                int processTime = buf.method_10816();
                return this.factory.create(category, input, output, processTime);
            }

            public void toNetwork(class_2540 buf, T recipe) {
                ((ProcessingRecipe)recipe).category.toNetwork(buf);
                ((ProcessingRecipe)recipe).ingredient.method_8088(buf);
                buf.method_10793(((ProcessingRecipe)recipe).result);
                buf.method_10804(((ProcessingRecipe)recipe).time);
            }
        }
    }

    public static abstract class Item
    extends ProcessingRecipe {
        public static final Codec<class_1799> SINGLE_ITEMSTACK = RecordCodecBuilder.create(builder -> builder.group((App)class_7923.field_41178.method_40294().fieldOf("item").forGetter(class_1799::method_41409), (App)class_2487.field_25128.optionalFieldOf("tag").forGetter(stack -> Optional.ofNullable(stack.method_7969()))).apply((Applicative)builder, (holder, tag) -> new class_1799(holder, 1, tag)));
        public static final Codec<class_1799> RESULT = class_5699.method_33817(SINGLE_ITEMSTACK, (Codec)class_1799.field_47310).xmap(either -> (class_1799)either.map(Function.identity(), Function.identity()), stack -> stack.method_7969() == null ? Either.right((Object)stack) : Either.left((Object)stack));

        public Item(class_3956<?> type, Category category, class_1856 ingredient, class_1799 result, int time) {
            super(type, category, ingredient, result, time);
        }

        public static ProcessingRecipe from(final class_1874 recipe, class_5455 access) {
            return new ProcessingRecipe(recipe.method_17716(), Category.FOOD, (class_1856)recipe.method_8117().get(0), recipe.method_8110(access), recipe.method_8167()){

                public class_1865<?> method_8119() {
                    return recipe.method_8119();
                }
            };
        }

        public static class Serializer<T extends ProcessingRecipe>
        implements class_1865<T> {
            private final Factory<T> factory;
            private final int defaultTime;
            private final Codec<T> codec;

            public Serializer(Factory<T> factory, int defaultTime) {
                this.factory = factory;
                this.defaultTime = defaultTime;
                this.codec = RecordCodecBuilder.create(builder -> builder.group((App)Category.CODEC.fieldOf("category").forGetter(recipe -> recipe.category), (App)class_1856.field_46096.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)RESULT.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.fieldOf("time").orElse((Object)this.defaultTime).forGetter(recipe -> recipe.time)).apply((Applicative)builder, this.factory::create));
            }

            public Codec<T> method_53736() {
                return this.codec;
            }

            public T fromNetwork(class_2540 buf) {
                Category category = Category.fromNetwork(buf);
                class_1856 input = class_1856.method_8086((class_2540)buf);
                class_1799 output = buf.method_10819();
                int processTime = buf.method_10816();
                return this.factory.create(category, input, output, processTime);
            }

            public void toNetwork(class_2540 buf, T recipe) {
                ((ProcessingRecipe)recipe).category.toNetwork(buf);
                ((ProcessingRecipe)recipe).ingredient.method_8088(buf);
                buf.method_10793(((ProcessingRecipe)recipe).result);
                buf.method_10804(((ProcessingRecipe)recipe).time);
            }
        }
    }
}

