/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.image;

import com.google.common.base.Preconditions;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.BitSet;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class PaletteImage {
    public static final int[] COLOURS = new int[]{0, -15726070, -10985901, -5921399, -1382959, -2177434, -6837424, -11441352, -14346993, -11393230, -6540740, -3905987, -1798784, -10251601, -13878166, -13886156};
    private static final int BITS_PER_INDEX = 4;
    protected final class_2960 id;
    protected final int width;
    protected final int height;
    protected final BitSet bits;

    public PaletteImage(int width, int height) {
        this(width, height, () -> new BitSet(width * height));
    }

    public PaletteImage(int width, int height, Supplier<BitSet> supplier) {
        Preconditions.checkArgument((width >= 1 && width <= 128 ? 1 : 0) != 0, (Object)"Width must be between 1 and 128 (inclusive)");
        Preconditions.checkArgument((height >= 1 && height <= 128 ? 1 : 0) != 0, (Object)"Height must be between 1 and 128 (inclusive)");
        this.width = width;
        this.height = height;
        BitSet bits = new BitSet(width * height);
        bits.or(supplier.get());
        this.bits = bits;
        this.id = this.createImageId(bits);
    }

    public class_2960 getId() {
        return this.id;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public BitSet getData() {
        return this.bits;
    }

    public void set(int x, int y, int colourIndex) {
        Preconditions.checkPositionIndex((int)(y * this.width + x), (int)(this.width * this.height - 1));
        Preconditions.checkPositionIndex((int)colourIndex, (int)(COLOURS.length - 1));
        int bitIndex = (y * this.width + x) * 4;
        this.bits.set(bitIndex + 0, (colourIndex & 1) != 0);
        this.bits.set(bitIndex + 1, (colourIndex & 2) != 0);
        this.bits.set(bitIndex + 2, (colourIndex & 4) != 0);
        this.bits.set(bitIndex + 3, (colourIndex & 8) != 0);
    }

    public int get(int x, int y) {
        Preconditions.checkArgument((y * this.width + x < this.width * this.height ? 1 : 0) != 0);
        int bitIndex = (y * this.width + x) * 4;
        int value = 0;
        value = PaletteImage.setBit(value, 0, this.bits.get(bitIndex + 0));
        value = PaletteImage.setBit(value, 1, this.bits.get(bitIndex + 1));
        value = PaletteImage.setBit(value, 2, this.bits.get(bitIndex + 2));
        value = PaletteImage.setBit(value, 3, this.bits.get(bitIndex + 3));
        return value;
    }

    private static int setBit(int value, int offset, boolean state) {
        if (state) {
            value |= 1 << offset;
        }
        return value;
    }

    public void write(class_2540 buffer) {
        buffer.method_52997((int)((byte)this.width));
        buffer.method_52997((int)((byte)this.height));
        buffer.method_10789(this.bits.toLongArray());
    }

    public static PaletteImage read(class_2540 buffer) {
        byte width = buffer.readByte();
        byte height = buffer.readByte();
        long[] data = buffer.method_33134();
        return new PaletteImage(width, height, () -> BitSet.valueOf(data));
    }

    private class_2960 createImageId(BitSet set) {
        return Utils.resource("palette_image_" + class_156.method_30309((String)Integer.toHexString(set.hashCode()), class_2960::method_29184));
    }

    public PaletteImage copy() {
        return new PaletteImage(this.width, this.height, () -> BitSet.valueOf(this.bits.toLongArray()));
    }
}

