/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.furniture.refurbished.computer.app.PaddleBall;
import com.mrcrayfish.furniture.refurbished.network.play.ClientPlayHandler;
import com.mrcrayfish.furniture.refurbished.network.play.ServerPlayHandler;
import net.minecraft.class_2540;

public class MessagePaddleBall {

    public record Event(byte data) {
        public static void encode(Event message, class_2540 buffer) {
            buffer.method_52997((int)message.data);
        }

        public static Event decode(class_2540 buffer) {
            byte event = buffer.readByte();
            return new Event(event);
        }

        public static void handle(Event message, MessageContext context) {
            context.execute(() -> ClientPlayHandler.handleMessagePaddleBallEvent(message));
            context.setHandled(true);
        }
    }

    public record OpponentName(String name) {
        public static void encode(OpponentName message, class_2540 buffer) {
            buffer.method_10814(message.name);
        }

        public static OpponentName decode(class_2540 buffer) {
            String name = buffer.method_19772();
            return new OpponentName(name);
        }

        public static void handle(OpponentName message, MessageContext context) {
            context.execute(() -> ClientPlayHandler.handleMessagePaddleBallOpponentName(message));
            context.setHandled(true);
        }
    }

    public record Action(PaddleBall.Action action, byte data) {
        public static void encode(Action message, class_2540 buffer) {
            buffer.method_10817((Enum)message.action);
            buffer.method_52997((int)message.data);
        }

        public static Action decode(class_2540 buffer) {
            PaddleBall.Action action = (PaddleBall.Action)buffer.method_10818(PaddleBall.Action.class);
            byte data = buffer.readByte();
            return new Action(action, data);
        }

        public static void handle(Action message, MessageContext context) {
            context.execute(() -> ServerPlayHandler.handleMessageTennisGame(message, context.getPlayer().orElse(null)));
            context.setHandled(true);
        }
    }

    public record BallUpdate(float ballX, float ballY, float velocityX, float velocityY) {
        public static void encode(BallUpdate message, class_2540 buffer) {
            buffer.method_52941(message.ballX);
            buffer.method_52941(message.ballY);
            buffer.method_52941(message.velocityX);
            buffer.method_52941(message.velocityY);
        }

        public static BallUpdate decode(class_2540 buffer) {
            float ballX = buffer.readFloat();
            float ballY = buffer.readFloat();
            float velocityX = buffer.readFloat();
            float velocityY = buffer.readFloat();
            return new BallUpdate(ballX, ballY, velocityX, velocityY);
        }

        public static void handle(BallUpdate message, MessageContext context) {
            context.execute(() -> ClientPlayHandler.handleMessageTennisGameBallUpdate(message));
            context.setHandled(true);
        }
    }

    public record PaddlePosition(float playerPos, float opponentPos) {
        public static void encode(PaddlePosition message, class_2540 buffer) {
            buffer.method_52941(message.playerPos);
            buffer.method_52941(message.opponentPos);
        }

        public static PaddlePosition decode(class_2540 buffer) {
            float playerPos = buffer.readFloat();
            float opponentPos = buffer.readFloat();
            return new PaddlePosition(playerPos, opponentPos);
        }

        public static void handle(PaddlePosition message, MessageContext context) {
            context.execute(() -> ClientPlayHandler.handleMessageTennisGamePaddlePosition(message));
            context.setHandled(true);
        }
    }
}

