/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.block.BathBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.IWaterTap;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.IFluidContainerBlock;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModParticleTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWaterTapAnimation;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class BathBlockEntity
extends BlockEntity
implements IFluidContainerBlock,
IWaterTap {
    protected final FluidContainer tank;
    private int animationTime;

    public BathBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.BATH.get(), pos, state);
    }

    public BathBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tank = this.createFluidContainer(state);
    }

    public boolean isHead() {
        return this.tank != null;
    }

    @Override
    public FluidContainer getFluidContainer() {
        return this.tank != null ? this.tank : this.getFluidContainerFromHead();
    }

    @Nullable
    private FluidContainer getFluidContainerFromHead() {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)BathBlock.DIRECTION)) {
            Direction direction = (Direction)state.m_61143_((Property)BathBlock.DIRECTION);
            Level level = Objects.requireNonNull(this.f_58857_);
            BlockEntity blockEntity = level.m_7702_(this.f_58858_.m_121945_(direction));
            if (blockEntity instanceof BathBlockEntity) {
                BathBlockEntity bath = (BathBlockEntity)blockEntity;
                return bath.getFluidContainer();
            }
        }
        return null;
    }

    @Nullable
    private FluidContainer createFluidContainer(BlockState state) {
        if (state.m_61138_(BathBlock.TYPE) && state.m_61143_(BathBlock.TYPE) == BathBlock.Type.HEAD) {
            return FluidContainer.create((Long)Config.SERVER.bath.fluidCapacity.get(), container -> {
                this.m_6596_();
                container.sync(this);
            });
        }
        return null;
    }

    public InteractionResult interact(Player player, InteractionHand hand, BlockHitResult result) {
        Item item;
        FluidContainer tank = this.getFluidContainer();
        if (tank == null) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        if (((Boolean)Config.SERVER.bath.dispenseWater.get()).booleanValue() && heldItem.m_41619_()) {
            Pair<Fluid, Long> drained;
            long filled;
            if ((tank.isEmpty() || tank.getStoredFluid().m_6212_((Fluid)Fluids.f_76193_)) && (filled = tank.push((Fluid)Fluids.f_76193_, FluidContainer.BUCKET_CAPACITY, false)) > 0L) {
                this.sendTapWaterAnimation();
                Objects.requireNonNull(this.f_58857_).m_247517_(null, this.f_58858_, (SoundEvent)ModSounds.BLOCK_KITCHEN_SINK_FILL.get(), SoundSource.BLOCKS);
                return InteractionResult.SUCCESS;
            }
            if (tank.getStoredAmount() >= FluidContainer.BUCKET_CAPACITY && tank.getStoredFluid().m_6212_((Fluid)Fluids.f_76195_) && (Long)(drained = tank.pull(FluidContainer.BUCKET_CAPACITY, true)).right() == FluidContainer.BUCKET_CAPACITY) {
                tank.pull(FluidContainer.BUCKET_CAPACITY, false);
                Vec3 pos = Vec3.m_82539_((Vec3i)this.f_58858_).m_82520_(0.0, 1.0, 0.0);
                Level level = Objects.requireNonNull(this.f_58857_);
                ItemEntity entity = new ItemEntity(level, pos.f_82479_, pos.f_82480_, pos.f_82481_, new ItemStack((ItemLike)Blocks.f_50080_));
                entity.m_32060_();
                level.m_7967_((Entity)entity);
                level.m_247517_(null, this.f_58858_, SoundEvents.f_12031_, SoundSource.BLOCKS);
                level.m_46796_(1501, this.f_58858_, 0);
                this.sendTapWaterAnimation();
                return InteractionResult.SUCCESS;
            }
        }
        if ((item = heldItem.m_41720_()) == Items.f_42590_ && !this.tank.isEmpty() && this.tank.getStoredFluid().m_6212_((Fluid)Fluids.f_76193_)) {
            this.tank.pull(FluidContainer.BUCKET_CAPACITY, false);
            player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)heldItem, (Player)player, (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_)));
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            player.f_19853_.m_5594_(null, this.f_58858_, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
            player.f_19853_.m_142346_(null, GameEvent.f_157816_, this.f_58858_);
            return InteractionResult.SUCCESS;
        }
        return Services.FLUID.performInteractionWithBlock(player, hand, this.m_58904_(), this.m_58899_(), result.m_82434_());
    }

    private void sendTapWaterAnimation() {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)BathBlock.DIRECTION)) {
            BlockPos tapPos = this.isHead() ? this.f_58858_ : this.f_58858_.m_121945_((Direction)state.m_61143_((Property)BathBlock.DIRECTION));
            Network.getPlay().sendToTrackingBlockEntity(() -> this, (IMessage)new MessageWaterTapAnimation(tapPos));
        }
    }

    @Override
    public void playWaterAnimation() {
        if (this.isHead()) {
            this.animationTime = 4;
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BathBlockEntity bath) {
        if (bath.animationTime > 0) {
            Vec3 tap = Vec3.m_82539_((Vec3i)pos).m_82520_(0.0, Utils.pixels(18.0), 0.0);
            tap = tap.m_231075_((Direction)state.m_61143_((Property)BathBlock.DIRECTION), Utils.pixels(2.0));
            for (int i = 0; i < 5; ++i) {
                double x = tap.f_82479_ + Utils.pixels(0.5) * level.f_46441_.m_188583_();
                double z = tap.f_82481_ + Utils.pixels(0.5) * level.f_46441_.m_188583_();
                level.m_7106_((ParticleOptions)ModParticleTypes.TAP_WATER.get(), x, tap.f_82480_, z, 0.0, 0.0, 0.0);
            }
            --bath.animationTime;
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (this.tank != null) {
            this.tank.load(tag.m_128469_("FluidTank"));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.tank != null) {
            CompoundTag tankTag = new CompoundTag();
            this.tank.save(tankTag);
            tag.m_128365_("FluidTank", (Tag)tankTag);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

