/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.block.RangeHoodBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.BasicLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.FlipAnimation;
import com.mrcrayfish.furniture.refurbished.blockentity.ICookingBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ILevelAudio;
import com.mrcrayfish.furniture.refurbished.client.audio.AudioManager;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModParticleTypes;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageFlipAnimation;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class FryingPanBlockEntity
extends BasicLootBlockEntity
implements ICookingBlock,
ILevelAudio {
    public static final Vector3f OIL_COLOUR = Vec3.m_82501_((int)14788611).m_252839_();
    public static final double MAX_AUDIO_DISTANCE = Mth.m_144944_((int)8);
    protected final RecipeManager.CachedCheck<Container, ? extends ProcessingRecipe> recipeCache;
    protected final RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> campfireCookingCache;
    protected final Vec3 audioPosition;
    protected boolean needsFlipping;
    protected boolean flipped;
    protected int rotation;
    protected boolean sync;
    private FlipAnimation animation;

    public FryingPanBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.FRYING_PAN.get(), pos, state, (RecipeType<? extends ProcessingRecipe>)((RecipeType)ModRecipeTypes.FRYING_PAN_COOKING.get()));
    }

    public FryingPanBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, RecipeType<? extends ProcessingRecipe> recipeType) {
        super(type, pos, state, 1);
        this.recipeCache = RecipeManager.m_220267_(recipeType);
        this.campfireCookingCache = RecipeManager.m_220267_((RecipeType)RecipeType.f_44111_);
        this.audioPosition = pos.m_252807_().m_82520_(0.0, -0.375, 0.0);
    }

    public boolean isFlippingNeeded() {
        return this.needsFlipping;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public int getRotation() {
        return this.rotation;
    }

    protected Component m_6820_() {
        return Utils.translation("container", "frying_pan", new Object[0]);
    }

    @Override
    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        return false;
    }

    protected AbstractContainerMenu m_6555_(int windowId, Inventory playerInventory) {
        return null;
    }

    public int m_6893_() {
        return 1;
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, FryingPanBlockEntity fryingPan) {
        AudioManager.get().playLevelAudio(fryingPan);
        fryingPan.spawnParticles(level, pos);
        FlipAnimation animation = fryingPan.getAnimation();
        boolean wasPlaying = animation.isPlaying();
        animation.tick();
        if (wasPlaying && !animation.isPlaying()) {
            fryingPan.playPlaceIngredientSound(true, 1.0f);
        }
    }

    private void spawnParticles(Level level, BlockPos pos) {
        if (this.isCooking() && !this.getAnimation().isPlaying()) {
            double posX = (double)pos.m_123341_() + 0.35 + 0.3 * level.f_46441_.m_188500_();
            double posY = (double)pos.m_123342_() + 0.15;
            double posZ = (double)pos.m_123343_() + 0.35 + 0.3 * level.f_46441_.m_188500_();
            level.m_7106_((ParticleOptions)new DustParticleOptions(OIL_COLOUR, 0.25f), posX, posY, posZ, 0.0, -0.05, 0.0);
            this.spawnSteam(level, posX, posY, posZ);
        }
    }

    public void spawnSteam(Level level, double x, double y, double z) {
        double ySpeed = 0.01;
        if (this.isRangeHoodPowered(level, this.f_58858_.m_7494_())) {
            ySpeed = 0.05;
        } else if (this.isRangeHoodPowered(level, this.f_58858_.m_7494_().m_7494_())) {
            ySpeed = 0.1;
        }
        level.m_7106_((ParticleOptions)ModParticleTypes.STEAM.get(), x, y, z, 0.0, ySpeed, 0.0);
    }

    private boolean isRangeHoodPowered(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof RangeHoodBlock) {
            return (Boolean)state.m_61143_((Property)RangeHoodBlock.POWERED);
        }
        return false;
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this;
    }

    @Override
    public boolean canCook() {
        ItemStack stack = this.m_8020_(0);
        if (!stack.m_41619_() && !this.needsFlipping) {
            return this.getRecipe(stack).isPresent();
        }
        return false;
    }

    @Override
    public int getTimeToCook() {
        Optional<? extends ProcessingRecipe> optional;
        ItemStack stack = this.m_8020_(0);
        if (!stack.m_41619_() && (optional = this.getRecipe(stack)).isPresent()) {
            return optional.get().getTime() / 2;
        }
        return 0;
    }

    @Override
    public void onCompleteCooking() {
        if (!this.flipped) {
            this.needsFlipping = true;
            this.sync();
            return;
        }
        ItemStack stack = this.m_8020_(0);
        if (!stack.m_41619_()) {
            Item remainingItem = stack.m_41720_().m_41469_();
            Optional<? extends ProcessingRecipe> optional = this.getRecipe(stack);
            ItemStack result = optional.map(recipe -> recipe.m_8043_(this.f_58857_.m_9598_())).orElse(ItemStack.f_41583_);
            stack.m_41774_(1);
            if (!result.m_41619_()) {
                ItemStack copy = result.m_41777_();
                this.m_6836_(0, copy);
                if (remainingItem != null) {
                    BlockPos pos = this.f_58858_;
                    this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)remainingItem)));
                }
            }
        }
    }

    @Override
    public boolean m_7013_(int slotIndex, ItemStack stack) {
        return slotIndex == 0 && super.m_7013_(slotIndex, stack) && this.getRecipe(stack).isPresent();
    }

    public boolean m_271862_(Container container, int slotIndex, ItemStack stack) {
        return slotIndex == 0 && super.m_271862_(container, slotIndex, stack) && this.getRecipe(stack).isEmpty();
    }

    public void m_6836_(int slotIndex, ItemStack stack) {
        if (!this.isCooking() && this.getRecipe(stack).isPresent()) {
            this.flipped = false;
            this.needsFlipping = false;
        }
        super.m_6836_(slotIndex, stack);
    }

    private Optional<? extends ProcessingRecipe> getRecipe(ItemStack stack) {
        Optional<? extends ProcessingRecipe> optional = this.getRecipe(this.recipeCache, stack);
        optional = optional.isEmpty() ? this.getCookingRecipe(this.campfireCookingCache, stack) : optional;
        return optional;
    }

    private Optional<ProcessingRecipe> getCookingRecipe(RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> cache, ItemStack stack) {
        return cache.m_213657_((Container)new SimpleContainer(new ItemStack[]{stack}), Objects.requireNonNull(this.f_58857_)).map(recipe -> ProcessingRecipe.Item.from(recipe, this.f_58857_.m_9598_()));
    }

    private Optional<? extends ProcessingRecipe> getRecipe(RecipeManager.CachedCheck<Container, ? extends ProcessingRecipe> cache, ItemStack stack) {
        return cache.m_213657_((Container)new SimpleContainer(new ItemStack[]{stack}), Objects.requireNonNull(this.f_58857_));
    }

    public void flipItem() {
        if (this.needsFlipping && !this.flipped) {
            this.flipped = true;
            this.needsFlipping = false;
            this.sendFlipAnimationToPlayers();
            this.sync();
            return;
        }
        if (!this.m_8020_(0).m_41619_()) {
            this.removeContents();
        }
    }

    public boolean placeContents(Level level, ItemStack stack, int rotation) {
        if (!stack.m_41619_() && this.m_8020_(0).m_41619_()) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            this.m_6836_(0, copy);
            this.rotation = rotation;
            this.flipped = false;
            this.needsFlipping = false;
            this.sync();
            this.playPlaceIngredientSound(false, 0.85f);
            return true;
        }
        this.removeContents();
        return false;
    }

    public void removeContents() {
        if (!this.m_8020_(0).m_41619_()) {
            ItemStack stack = this.m_8020_(0);
            BlockPos pos = this.f_58858_;
            ItemEntity entity = new ItemEntity(this.f_58857_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5, stack.m_41777_());
            this.m_6836_(0, ItemStack.f_41583_);
            this.f_58857_.m_7967_((Entity)entity);
            this.flipped = false;
            this.needsFlipping = false;
            this.sync();
        }
    }

    public void playFlipAnimation(int index) {
        if (Objects.requireNonNull(this.f_58857_).m_5776_() && index == 0) {
            this.getAnimation().play();
        }
    }

    private void sendFlipAnimationToPlayers() {
        Level level = Objects.requireNonNull(this.f_58857_);
        ChunkSource chunkSource = level.m_7726_();
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache cache = (ServerChunkCache)chunkSource;
            BlockPos pos = this.m_58899_();
            List players = cache.f_8325_.m_183262_(new ChunkPos(pos), false);
            players.forEach(player -> Network.getPlay().sendToPlayer(() -> player, (IMessage)new MessageFlipAnimation(pos, 0)));
        }
    }

    public FlipAnimation getAnimation() {
        if (this.animation == null) {
            this.animation = new FlipAnimation();
        }
        return this.animation;
    }

    private void playPlaceIngredientSound(boolean client, float pitch) {
        Level level = Objects.requireNonNull(this.f_58857_);
        Vec3 vec = Vec3.m_82539_((Vec3i)this.f_58858_);
        if (client) {
            level.m_7785_(vec.f_82479_, vec.f_82480_, vec.f_82481_, (SoundEvent)ModSounds.BLOCK_FRYING_PAN_PLACE_INGREDIENT.get(), SoundSource.PLAYERS, 1.0f, pitch, false);
            return;
        }
        level.m_6263_(null, vec.f_82479_, vec.f_82480_, vec.f_82481_, (SoundEvent)ModSounds.BLOCK_FRYING_PAN_PLACE_INGREDIENT.get(), SoundSource.PLAYERS, 1.0f, pitch);
    }

    public void m_6596_() {
        super.m_6596_();
        this.sync();
    }

    protected void sync() {
        BlockEntityHelper.sendCustomUpdate((BlockEntity)this, this.m_5995_());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("NeedsFlipping", 1)) {
            this.needsFlipping = tag.m_128471_("NeedsFlipping");
        }
        if (tag.m_128425_("Flipped", 1)) {
            this.flipped = tag.m_128471_("Flipped");
        }
        if (tag.m_128425_("Rotation", 3)) {
            this.rotation = tag.m_128451_("Rotation");
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("NeedsFlipping", this.needsFlipping);
        tag.m_128379_("Flipped", this.flipped);
        tag.m_128405_("Rotation", this.rotation);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Override
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.BLOCK_FRYING_PAN_SIZZLING.get();
    }

    @Override
    public SoundSource getSource() {
        return SoundSource.BLOCKS;
    }

    @Override
    public Vec3 getAudioPosition() {
        return this.audioPosition;
    }

    @Override
    public boolean canPlayAudio() {
        return !this.m_58901_() && (this.isCooking() || this.isPartiallyCooked());
    }

    @Override
    public float getAudioVolume() {
        return (this.isCooking() || this.isPartiallyCooked()) && !this.getAnimation().isPlaying() ? 1.0f : 0.0f;
    }

    @Override
    public float getAudioPitch() {
        return this.isPartiallyCooked() ? 0.8f : 1.0f;
    }

    @Override
    public int getAudioHash() {
        return this.f_58858_.hashCode();
    }

    @Override
    public boolean isAudioEqual(ILevelAudio other) {
        return this == other;
    }

    @Override
    public double getAudioRadiusSqr() {
        return MAX_AUDIO_DISTANCE;
    }

    private boolean isPartiallyCooked() {
        return !this.m_8020_(0).m_41619_() && this.isFlippingNeeded();
    }
}

