/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.computer.client.graphics;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.computer.Display;
import com.mrcrayfish.furniture.refurbished.computer.app.Marketplace;
import com.mrcrayfish.furniture.refurbished.computer.client.DisplayableProgram;
import com.mrcrayfish.furniture.refurbished.computer.client.Icon;
import com.mrcrayfish.furniture.refurbished.computer.client.Scene;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ComputerButton;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ComputerSelectionList;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class MarketplaceGraphics
extends DisplayableProgram<Marketplace> {
    private static final ResourceLocation TEXTURE = Utils.resource("textures/gui/program/marketplace.png");

    public MarketplaceGraphics(Marketplace program) {
        super(program, 112, 54);
        this.setScene(new ComingSoon(this));
    }

    public static class ComingSoon
    extends Scene {
        private final MarketplaceGraphics program;

        public ComingSoon(MarketplaceGraphics program) {
            this.program = program;
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
        }

        @Override
        public void render(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            Icon icon = Display.get().getIcon(((Marketplace)this.program.getProgram()).getId());
            if (icon != null) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)icon.texture());
                GuiComponent.m_93133_((PoseStack)poseStack, (int)((this.program.getWidth() - 16) / 2), (int)10, (float)icon.u(), (float)icon.v(), (int)16, (int)16, (int)128, (int)128);
            }
            GuiComponent.m_93208_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (String)"Coming Soon!", (int)56, (int)35, (int)-1);
        }
    }

    public static class CatalogueScene
    extends Scene {
        private final MarketplaceGraphics program;
        private final ComputerSelectionList<Item> itemList;

        private CatalogueScene(MarketplaceGraphics program) {
            this.program = program;
            this.itemList = this.addWidget(new ComputerSelectionList(program.getWidth() - 10, program.getHeight() - 26, 0, 100, 30));
            this.itemList.m_6702_().add(new Item());
            this.itemList.m_6702_().add(new Item());
            this.itemList.m_6702_().add(new Item());
            this.itemList.m_6702_().add(new Item());
            this.itemList.m_6702_().add(new Item());
            this.itemList.m_6702_().add(new Item());
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
            this.itemList.setPosition(contentStart + 5, contentTop + 21);
        }

        @Override
        public void render(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            GuiComponent.m_93172_((PoseStack)poseStack, (int)0, (int)0, (int)this.program.getWidth(), (int)16, (int)-10143432);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            GuiComponent.m_93228_((PoseStack)poseStack, (int)5, (int)2, (int)0, (int)0, (int)12, (int)12);
            ScreenHelper.drawString(poseStack, Integer.toString(this.getEmeraldCount()), 50, 5, -1, true);
        }

        private int getEmeraldCount() {
            return Optional.ofNullable(((Marketplace)this.program.getProgram()).getComputer().getMenu()).map(menu -> (int)menu.getProgramData()).orElse(0);
        }

        private static class Item
        extends ObjectSelectionList.Entry<Item> {
            private final ComputerButton buyButton = new ComputerButton(50, 16, (Component)Component.m_237113_((String)"Buy"), btn -> System.out.println("Hello"));

            public Component m_142172_() {
                return CommonComponents.f_237098_;
            }

            public void m_6311_(PoseStack poseStack, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTick) {
                GuiComponent.m_93172_((PoseStack)poseStack, (int)left, (int)top, (int)(left + rowWidth), (int)(top + rowHeight), (int)-1);
                this.buyButton.m_264152_(left + rowWidth - this.buyButton.m_5711_(), top);
                this.buyButton.m_86412_(poseStack, mouseX, mouseY, partialTick);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                this.buyButton.m_6375_(mouseX, mouseY, button);
                return true;
            }
        }
    }
}

