/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.network.message;

import com.mojang.authlib.GameProfile;
import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.mrcrayfish.furniture.refurbished.client.ClientMailbox;
import com.mrcrayfish.furniture.refurbished.mail.IMailbox;
import com.mrcrayfish.furniture.refurbished.network.play.ClientPlayHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;

public class MessageUpdateMailboxes
extends PlayMessage<MessageUpdateMailboxes> {
    private Collection<? extends IMailbox> mailboxes;

    public MessageUpdateMailboxes() {
    }

    public MessageUpdateMailboxes(Collection<? extends IMailbox> mailboxes) {
        this.mailboxes = mailboxes;
    }

    public void encode(MessageUpdateMailboxes message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.mailboxes.size());
        message.mailboxes.forEach(mailbox -> {
            buffer.m_130077_(mailbox.getId());
            Optional<GameProfile> ownerId = mailbox.getOwner();
            buffer.writeBoolean(ownerId.isPresent());
            ownerId.ifPresent(profile -> {
                buffer.m_130077_(profile.getId());
                String name = profile.getName();
                buffer.writeBoolean(name != null);
                if (name != null) {
                    buffer.m_130070_(name);
                }
            });
            Optional<String> customName = mailbox.getCustomName();
            buffer.writeBoolean(customName.isPresent());
            customName.ifPresent(arg_0 -> ((FriendlyByteBuf)buffer).m_130070_(arg_0));
        });
    }

    public MessageUpdateMailboxes decode(FriendlyByteBuf buffer) {
        ArrayList<ClientMailbox> mailboxes = new ArrayList<ClientMailbox>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            UUID id = buffer.m_130259_();
            UUID ownerId = buffer.readBoolean() ? buffer.m_130259_() : null;
            String ownerName = ownerId != null && buffer.readBoolean() ? buffer.m_130277_() : null;
            GameProfile profile = ownerId != null ? new GameProfile(ownerId, ownerName) : null;
            String customName = buffer.readBoolean() ? buffer.m_130277_() : null;
            mailboxes.add(new ClientMailbox(id, Optional.ofNullable(profile), Optional.ofNullable(customName)));
        }
        return new MessageUpdateMailboxes(mailboxes);
    }

    public void handle(MessageUpdateMailboxes message, MessageContext context) {
        context.execute(() -> ClientPlayHandler.handleMessageUpdateMailboxes(message));
        context.setHandled(true);
    }

    public Collection<? extends IMailbox> getMailboxes() {
        return this.mailboxes;
    }
}

