/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.block.ElectricityGeneratorBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricitySourceLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.ILevelAudio;
import com.mrcrayfish.furniture.refurbished.blockentity.IPowerSwitch;
import com.mrcrayfish.furniture.refurbished.blockentity.IProcessingBlock;
import com.mrcrayfish.furniture.refurbished.client.audio.AudioManager;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.electricity.NodeSearchResult;
import com.mrcrayfish.furniture.refurbished.inventory.BuildableContainerData;
import com.mrcrayfish.furniture.refurbished.inventory.ElectricityGeneratorMenu;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3913;

public class ElectricityGeneratorBlockEntity
extends ElectricitySourceLootBlockEntity
implements IProcessingBlock,
IPowerSwitch,
ILevelAudio {
    public static final int DATA_ENERGY = 0;
    public static final int DATA_TOTAL_ENERGY = 1;
    public static final int DATA_ENABLED = 2;
    public static final int DATA_OVERLOADED = 3;
    public static final int DATA_POWERED = 4;
    public static final int DATA_NODE_COUNT = 5;
    protected final class_243 audioPosition;
    protected int totalEnergy;
    protected int energy;
    protected boolean enabled;
    protected int nodeCount;
    protected final class_3913 data = new BuildableContainerData(builder -> {
        builder.add(0, () -> this.energy, value -> {});
        builder.add(1, () -> this.totalEnergy, value -> {});
        builder.add(2, () -> this.enabled ? 1 : 0, value -> {});
        builder.add(3, () -> this.overloaded ? 1 : 0, value -> {});
        builder.add(4, () -> this.isNodePowered() ? 1 : 0, value -> {});
        builder.add(5, () -> this.nodeCount, value -> {});
    });

    public ElectricityGeneratorBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591)ModBlockEntities.ELECTRICITY_GENERATOR.get(), pos, state);
    }

    public ElectricityGeneratorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state, 1);
        this.audioPosition = pos.method_46558().method_1031(0.0, -0.375, 0.0);
    }

    @Override
    public int getNodeMaximumConnections() {
        return (Integer)Config.SERVER.electricity.maximumLinksPerElectricityGenerator.get();
    }

    protected class_2561 method_17823() {
        return Utils.translation("container", "electricity_generator", new Object[0]);
    }

    protected class_1703 method_5465(int windowId, class_1661 playerInventory) {
        if (!this.enabled) {
            this.searchNodeNetwork(false);
        }
        return new ElectricityGeneratorMenu(windowId, playerInventory, (class_1263)this, this.data);
    }

    @Override
    public boolean isMatchingContainerMenu(class_1703 menu) {
        ElectricityGeneratorMenu generator;
        return menu instanceof ElectricityGeneratorMenu && (generator = (ElectricityGeneratorMenu)menu).getContainer() == this;
    }

    @Override
    public class_3414 getSound() {
        return (class_3414)ModSounds.BLOCK_ELECTRICITY_GENERATOR_ENGINE.get();
    }

    @Override
    public class_3419 getSource() {
        return class_3419.field_15245;
    }

    @Override
    public class_243 getAudioPosition() {
        return this.audioPosition;
    }

    @Override
    public boolean canPlayAudio() {
        return this.isNodePowered() && !this.method_11015();
    }

    @Override
    public int getAudioHash() {
        return this.field_11867.hashCode();
    }

    @Override
    public boolean isAudioEqual(ILevelAudio other) {
        return other == this;
    }

    @Override
    public boolean isNodePowered() {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)ElectricityGeneratorBlock.POWERED)) {
            return (Boolean)state.method_11654((class_2769)ElectricityGeneratorBlock.POWERED);
        }
        return false;
    }

    @Override
    public void setNodePowered(boolean powered) {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)ElectricityGeneratorBlock.POWERED)) {
            this.field_11863.method_8652(this.field_11867, (class_2680)state.method_11657((class_2769)ElectricityGeneratorBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        }
    }

    @Override
    public void togglePower() {
        boolean bl = this.enabled = !this.enabled;
        if (this.enabled) {
            NodeSearchResult result = this.searchNodeNetwork(false);
            if (!result.overloaded()) {
                if (this.overloaded) {
                    this.overloaded = false;
                }
            } else {
                this.enabled = false;
            }
        }
        this.method_5431();
    }

    @Override
    public void onNodeOverloaded() {
        this.enabled = false;
        this.method_5431();
    }

    @Override
    public NodeSearchResult searchNodeNetwork(boolean cancelAtLimit) {
        NodeSearchResult result = super.searchNodeNetwork(cancelAtLimit);
        this.nodeCount = result.nodes().size();
        return result;
    }

    @Override
    public IProcessingBlock.EnergyMode getEnergyMode() {
        return IProcessingBlock.EnergyMode.ONLY_WHEN_PROCESSING;
    }

    @Override
    public int getEnergy() {
        return this.energy;
    }

    @Override
    public void addEnergy(int energy) {
        this.energy += energy;
    }

    @Override
    public boolean requiresEnergy() {
        return true;
    }

    @Override
    public int retrieveEnergy(boolean simulate) {
        int energy;
        class_1799 stack = this.method_5438(0);
        if (!stack.method_7960() && (energy = Services.ITEM.getBurnTime(stack, null) * (Integer)Config.SERVER.electricity.fuelToPowerRatio.get()) > 0) {
            if (!simulate) {
                class_1792 remainingItem = stack.method_7909().method_7858();
                if (stack.method_7914() == 1 && remainingItem != null) {
                    this.method_5447(0, new class_1799((class_1935)remainingItem));
                } else {
                    stack.method_7934(1);
                }
                this.totalEnergy = energy;
            }
            return energy;
        }
        return 0;
    }

    @Override
    public int updateAndGetTotalProcessingTime() {
        return this.getTotalProcessingTime();
    }

    @Override
    public int getTotalProcessingTime() {
        return 1;
    }

    @Override
    public int getProcessingTime() {
        return 0;
    }

    @Override
    public void setProcessingTime(int time) {
        if (this.isNodePowered()) {
            if (time == 0) {
                this.setNodePowered(false);
            }
        } else if (time == 1) {
            this.setNodePowered(true);
        }
    }

    @Override
    public void onCompleteProcess() {
    }

    @Override
    public boolean canProcess() {
        return this.enabled && !this.isNodeOverloaded();
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, ElectricityGeneratorBlockEntity generator) {
        AudioManager.get().playLevelAudio(generator);
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10573("Enabled", 1)) {
            this.enabled = tag.method_10577("Enabled");
        }
    }

    @Override
    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10556("Enabled", this.enabled);
    }

    @Override
    public void earlyNodeTick(class_1937 level) {
        if (!level.method_8608()) {
            this.processTick();
        }
        super.earlyNodeTick(level);
    }
}

