/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.framework.api.event.ClientConnectionEvents;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.ScreenEvents;
import com.mrcrayfish.framework.event.IClientConnectionEvent;
import com.mrcrayfish.framework.event.IScreenEvent;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.IconButton;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.client.util.VanillaTextures;
import com.mrcrayfish.furniture.refurbished.core.ModBlocks;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.core.ModTags;
import com.mrcrayfish.furniture.refurbished.platform.ClientServices;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_5244;
import net.minecraft.class_6862;
import net.minecraft.class_757;
import net.minecraft.class_7923;
import net.minecraft.class_8000;
import net.minecraft.class_8001;
import org.joml.Matrix4f;

public class CreativeFilters {
    private static CreativeFilters instance;
    private final List<FilterCategory> categories;
    private class_339 scrollUpButton;
    private class_339 scrollDownButton;
    private class_1761 lastTab;
    private int guiLeft;
    private int guiTop;
    private int scroll;

    public static CreativeFilters get() {
        if (instance == null) {
            instance = new CreativeFilters();
        }
        return instance;
    }

    private CreativeFilters() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new FilterCategory(ModTags.Items.GENERAL, new class_1799((class_1935)ModBlocks.CHAIR_OAK.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.BEDROOM, new class_1799((class_1935)ModBlocks.DRAWER_MANGROVE.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.KITCHEN, new class_1799((class_1935)ModBlocks.KITCHEN_SINK_YELLOW.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.OUTDOORS, new class_1799((class_1935)ModBlocks.GRILL_RED.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.BATHROOM, new class_1799((class_1935)ModBlocks.TOILET_OAK.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.ELECTRONICS, new class_1799((class_1935)ModBlocks.ELECTRICITY_GENERATOR_LIGHT.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.STORAGE, new class_1799((class_1935)ModBlocks.CRATE_BIRCH.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.FOOD, new class_1799((class_1935)ModItems.SWEET_BERRY_JAM_TOAST.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.ITEMS, new class_1799((class_1935)ModItems.SPATULA.get())));
        this.categories = builder.build();
        ScreenEvents.MODIFY_WIDGETS.register((IFrameworkEvent)((IScreenEvent.ModifyWidgets)(screen, widgets, add, remove) -> {
            if (screen instanceof class_481) {
                class_481 creativeScreen = (class_481)screen;
                this.guiLeft = ClientServices.PLATFORM.getGuiLeft((class_465<?>)creativeScreen);
                this.guiTop = ClientServices.PLATFORM.getGuiTop((class_465<?>)creativeScreen);
                this.categories.forEach(FilterCategory::loadItems);
                this.injectWidgets(creativeScreen, add);
            }
        }));
        ScreenEvents.CLOSED.register((IFrameworkEvent)((IScreenEvent.Closed)screen -> {
            if (screen instanceof class_481) {
                this.categories.forEach(category -> {
                    this.scrollUpButton = null;
                    this.scrollDownButton = null;
                    category.setFilterTab(null);
                });
            }
        }));
        ScreenEvents.AFTER_DRAW.register((IFrameworkEvent)((IScreenEvent.AfterDraw)(screen, graphics, mouseX, mouseY, partialTick) -> {
            if (screen instanceof class_481) {
                class_481 creativeScreen = (class_481)screen;
                class_1761 tab = ClientServices.PLATFORM.getSelectedCreativeModeTab();
                if (this.lastTab != tab) {
                    this.onSwitchCreativeTab(tab, creativeScreen);
                    this.lastTab = tab;
                }
            }
        }));
        ClientConnectionEvents.LOGGING_OUT.register((IFrameworkEvent)((IClientConnectionEvent.LoggingOut)player -> this.categories.forEach(category -> {
            category.resetItems();
            category.setEnabled(true);
        })));
    }

    private void injectWidgets(class_481 screen, Consumer<class_339> add) {
        this.categories.forEach(category -> {
            FilterTab tab = new FilterTab(this.guiLeft - 28, this.guiTop, (FilterCategory)category, btn -> {
                if (class_437.method_25441() || class_437.method_25442()) {
                    category.setEnabled(!category.isEnabled());
                } else {
                    this.categories.forEach(c -> c.setEnabled(false));
                    category.setEnabled(true);
                }
                this.updateItems(screen);
            });
            tab.field_22764 = false;
            add.accept((class_339)tab);
        });
        this.scrollUpButton = new IconButton(this.guiLeft - 22, this.guiTop - 12, 0, 0, btn -> {
            if (this.scroll > 0) {
                --this.scroll;
            }
            this.updateWidgets();
        });
        add.accept(this.scrollUpButton);
        this.scrollDownButton = new IconButton(this.guiLeft - 22, this.guiTop + 127, 10, 0, btn -> {
            if (this.scroll <= this.categories.size() - 4 - 1) {
                ++this.scroll;
            }
            this.updateWidgets();
        });
        add.accept(this.scrollDownButton);
        this.updateWidgets();
        this.onSwitchCreativeTab(ClientServices.PLATFORM.getSelectedCreativeModeTab(), screen);
    }

    private void updateItems(class_481 screen) {
        HashSet seenItems = new HashSet();
        LinkedHashSet categorisedItems = new LinkedHashSet();
        Services.PLATFORM.getCreativeModeTab().method_47313().forEach(stack -> this.categories.stream().filter(FilterCategory::isEnabled).forEach(category -> {
            class_1792 item = stack.method_7909();
            if (!seenItems.contains(item) && stack.method_31573(category.tag)) {
                categorisedItems.add(stack.method_7972());
                seenItems.add(item);
            }
        }));
        class_2371 items = ((class_481.class_483)screen.method_17577()).field_2897;
        items.clear();
        items.addAll(categorisedItems);
        ((class_481.class_483)screen.method_17577()).method_2473(0.0f);
    }

    private void updateWidgets() {
        this.categories.forEach(category -> category.setVisible(false));
        for (int i = this.scroll; i < this.scroll + 4 && i < this.categories.size(); ++i) {
            FilterCategory category2 = this.categories.get(i);
            category2.setY(this.guiTop + 29 * (i - this.scroll) + 11);
            category2.setVisible(true);
        }
        this.scrollUpButton.field_22763 = this.scroll > 0;
        this.scrollDownButton.field_22763 = this.scroll <= this.categories.size() - 4 - 1;
    }

    private void onSwitchCreativeTab(class_1761 tab, class_481 screen) {
        boolean isFurnitureTab;
        this.scrollUpButton.field_22764 = isFurnitureTab = tab == Services.PLATFORM.getCreativeModeTab();
        this.scrollDownButton.field_22764 = isFurnitureTab;
        if (isFurnitureTab) {
            this.updateWidgets();
            this.updateItems(screen);
            return;
        }
        this.categories.forEach(category -> category.setVisible(false));
    }

    public boolean onMouseScroll(double mouseX, double mouseY, double scroll) {
        class_1761 selectedTab = ClientServices.PLATFORM.getSelectedCreativeModeTab();
        if (selectedTab != Services.PLATFORM.getCreativeModeTab()) {
            return false;
        }
        double startX = this.guiLeft - 28;
        double startY = this.guiTop + 29;
        if (mouseX >= startX && mouseX < startX + 28.0 && mouseY >= startY && mouseY < startY + 113.0) {
            int oldScroll = this.scroll;
            this.scroll += scroll > 0.0 ? -1 : 1;
            this.scroll = class_3532.method_15340((int)this.scroll, (int)0, (int)(this.categories.size() - 4));
            if (this.scroll != oldScroll) {
                this.updateWidgets();
            }
            return true;
        }
        return false;
    }

    public static class FilterCategory {
        private final class_6862<class_1792> tag;
        private final class_1799 icon;
        private List<class_1792> items;
        private boolean enabled = true;
        private FilterTab filterTab;

        public FilterCategory(class_6862<class_1792> tag, class_1799 icon) {
            this.tag = tag;
            this.icon = icon;
        }

        public class_6862<class_1792> getTag() {
            return this.tag;
        }

        public class_1799 getIcon() {
            return this.icon;
        }

        public Optional<List<class_1792>> getItems() {
            return Optional.ofNullable(this.items);
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setFilterTab(@Nullable FilterTab filterTab) {
            this.filterTab = filterTab;
        }

        public void setVisible(boolean visible) {
            if (this.filterTab != null) {
                this.filterTab.field_22764 = visible;
            }
        }

        public void setY(int y) {
            if (this.filterTab != null) {
                this.filterTab.method_46419(y);
            }
        }

        public void loadItems() {
            if (this.items != null) {
                return;
            }
            this.items = new ArrayList<class_1792>();
            class_7923.field_41178.method_10220().forEach(item -> {
                if (item.method_40131().method_40220(this.getTag())) {
                    this.items.add((class_1792)item);
                }
            });
        }

        public void resetItems() {
            this.items = null;
        }
    }

    private static class FilterTab
    extends class_4185 {
        private final FilterCategory category;

        protected FilterTab(int x, int y, FilterCategory category, class_4185.class_4241 onPress) {
            super(x, y, 32, 26, class_5244.field_39003, onPress, field_40754);
            this.category = category;
            category.setFilterTab(this);
            class_2960 tagId = category.getTag().comp_327();
            String tooltipTitle = String.format("filterCategory.%s.%s", tagId.method_12836(), tagId.method_12832().replace("/", "."));
            String tooltipDesc = tooltipTitle + ".desc";
            this.method_47400(ScreenHelper.createMultilineTooltip(List.of(class_2561.method_43471((String)tooltipTitle), class_2561.method_43471((String)tooltipDesc).method_27692(class_124.field_1080))));
        }

        public void method_48579(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
            int textureX = 26;
            int textureY = this.category.isEnabled() ? 32 : 0;
            int textureWidth = this.category.isEnabled() ? 32 : 28;
            int textureHeight = 26;
            RenderSystem.setShaderTexture((int)0, (class_2960)VanillaTextures.CREATIVE_TABS);
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
            this.drawRotatedTexture(poseStack.method_23760().method_23761(), this.method_46426(), this.method_46427(), textureX, textureY, textureWidth, textureHeight);
            ScreenHelper.drawItem(poseStack, this.category.getIcon(), this.method_46426() + 8, this.method_46427() + 5);
        }

        private void drawRotatedTexture(Matrix4f matrix4f, int x, int y, int textureX, int textureY, int textureWidth, int textureHeight) {
            float scaleX = 0.00390625f;
            float scaleY = 0.00390625f;
            RenderSystem.setShader(class_757::method_34542);
            class_287 builder = class_289.method_1348().method_1349();
            builder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            builder.method_22918(matrix4f, (float)x, (float)(y + textureHeight), 0.0f).method_22913((float)(textureX + textureHeight) * scaleX, (float)textureY * scaleY).method_1344();
            builder.method_22918(matrix4f, (float)(x + textureWidth), (float)(y + textureHeight), 0.0f).method_22913((float)(textureX + textureHeight) * scaleX, ((float)textureY + (float)textureWidth) * scaleY).method_1344();
            builder.method_22918(matrix4f, (float)(x + textureWidth), (float)y, 0.0f).method_22913((float)textureX * scaleX, (float)(textureY + textureWidth) * scaleY).method_1344();
            builder.method_22918(matrix4f, (float)x, (float)y, 0.0f).method_22913((float)textureX * scaleX, (float)textureY * scaleY).method_1344();
            class_286.method_43433((class_287.class_7433)builder.method_1326());
        }

        protected class_8000 method_47937() {
            return class_8001.field_41687;
        }
    }
}

