/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.computer.client.graphics;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.client.util.AudioHelper;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.computer.app.PaddleBall;
import com.mrcrayfish.furniture.refurbished.computer.client.DisplayableProgram;
import com.mrcrayfish.furniture.refurbished.computer.client.Scene;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ComputerButton;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessagePaddleBall;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_7919;

public class PaddleBallGraphics
extends DisplayableProgram<PaddleBall> {
    private static final class_2960 TEXTURE = Utils.resource("textures/gui/program/paddle_ball.png");
    private float ballX;
    private float lastBallX;
    private float ballY;
    private float lastBallY;
    private float ballVelocityX;
    private float ballVelocityY;
    private float playerPos;
    private float lastPlayerPos;
    private float targetPlayerPos;
    private float opponentPos;
    private float lastOpponentPos;
    private float targetOpponentPos;
    private int playerScore;
    private int opponentScore;
    private int scoreSide;
    private int scoreAnimation;
    @Nullable
    private class_2561 displayLabel;
    private Boolean wonGame;
    private boolean playing;
    private boolean leftPaddle;
    private String opponentName = "Opponent";

    public PaddleBallGraphics(PaddleBall program) {
        super(program, 200, 100);
        this.setScene(new MainMenuScene(this));
    }

    @Override
    public void tick() {
        this.lastBallX = this.ballX;
        this.lastBallY = this.ballY;
        this.lastPlayerPos = this.playerPos;
        this.lastOpponentPos = this.opponentPos;
        this.ballX += this.ballVelocityX;
        this.ballY += this.ballVelocityY;
        this.playerPos = this.targetPlayerPos;
        this.opponentPos = this.targetOpponentPos;
        super.tick();
    }

    @Override
    public boolean blocksNavigation() {
        return this.playing;
    }

    public void updatePaddles(float playerPos, float opponentPos) {
        this.targetPlayerPos = this.leftPaddle ? playerPos : opponentPos;
        this.targetOpponentPos = this.leftPaddle ? opponentPos : playerPos;
    }

    public void updateBall(float ballX, float ballY, float velocityX, float velocityY) {
        this.ballX = ballX;
        this.ballY = ballY;
        this.ballVelocityX = velocityX;
        this.ballVelocityY = velocityY;
    }

    public void handleOpponentName(String name) {
        this.opponentName = name;
    }

    public void handleEvent(byte event) {
        switch (event) {
            case 1: {
                this.reset();
                this.playing = true;
                this.setScene(new GameScene(this));
                break;
            }
            case 2: {
                this.leftPaddle = true;
                break;
            }
            case 3: {
                this.leftPaddle = false;
                break;
            }
            case 4: {
                AudioHelper.playUISound((class_3414)ModSounds.UI_PADDLE_BALL_RETRO_WIN.get(), 1.0f, 0.5f);
                this.displayLabel = this.translation("win_game");
                this.wonGame = true;
                this.playing = false;
                break;
            }
            case 5: {
                AudioHelper.playUISound((class_3414)ModSounds.UI_PADDLE_BALL_RETRO_LOSE.get(), 1.0f, 0.5f);
                this.displayLabel = this.translation("lose_game");
                this.wonGame = false;
                this.playing = false;
                break;
            }
            case 6: {
                ++this.playerScore;
                this.scoreSide = 1;
                this.scoreAnimation = 40;
                if (this.playerScore >= 7) break;
                AudioHelper.playUISound((class_3414)ModSounds.UI_PADDLE_BALL_RETRO_SUCCESS.get(), 1.0f, 0.5f);
                break;
            }
            case 7: {
                ++this.opponentScore;
                this.scoreSide = 0;
                this.scoreAnimation = 40;
                if (this.opponentScore >= 7) break;
                AudioHelper.playUISound((class_3414)ModSounds.UI_PADDLE_BALL_RETRO_FAIL.get(), 1.0f, 0.5f);
                break;
            }
            case 8: {
                this.displayLabel = this.translation("opponent_left");
                this.wonGame = false;
                break;
            }
            case 40: {
                AudioHelper.playUISound((class_3414)ModSounds.UI_PADDLE_BALL_RETRO_HIT.get(), 1.0f, 0.5f);
            }
        }
    }

    private void reset() {
        this.displayLabel = null;
        this.wonGame = null;
        this.playerScore = 0;
        this.opponentScore = 0;
        this.ballVelocityX = 0.0f;
        this.ballVelocityY = 0.0f;
        this.scoreAnimation = 0;
        this.opponentName = "Opponent";
    }

    private static class MainMenuScene
    extends Scene {
        private final PaddleBallGraphics game;
        private final MenuButton playAiButton;
        private final MenuButton playVsButton;

        public MainMenuScene(PaddleBallGraphics game) {
            this.game = game;
            this.playAiButton = this.addWidget(new MenuButton(100, 16, this.game.translation("play_ai"), btn -> Network.getPlay().sendToServer((IMessage)new MessagePaddleBall.Action(PaddleBall.Action.JOIN_GAME, 0))));
            this.playAiButton.setClickSound((class_3414)ModSounds.UI_PADDLE_BALL_RETRO_CLICK.get());
            this.playVsButton = this.addWidget(new MenuButton(100, 16, this.game.translation("play_vs"), btn -> {
                Network.getPlay().sendToServer((IMessage)new MessagePaddleBall.Action(PaddleBall.Action.JOIN_GAME, 1));
                game.setScene(new PendingScene(game));
            }));
            this.playVsButton.setClickSound((class_3414)ModSounds.UI_PADDLE_BALL_RETRO_CLICK.get());
            class_310 mc = class_310.method_1551();
            if ((mc.method_1576() == null || mc.method_47392()) && mc.method_1558() == null) {
                this.playVsButton.method_47400(class_7919.method_47407((class_2561)this.game.translation("server_required")));
                this.playVsButton.field_22763 = false;
            }
            game.playing = false;
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
            this.playAiButton.method_48229(contentStart + (this.game.width - this.playAiButton.method_25368()) / 2, contentTop + 45);
            this.playVsButton.method_48229(contentStart + (this.game.width - this.playVsButton.method_25368()) / 2, contentTop + 65);
        }

        @Override
        public void render(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
            class_332.method_25302((class_4587)poseStack, (int)((this.game.width - 128) / 2), (int)10, (int)16, (int)0, (int)128, (int)24);
        }

        private static class MenuButton
        extends ComputerButton {
            public MenuButton(int width, int height, class_2561 label, class_4185.class_4241 onPress) {
                super(width, height, label, onPress);
            }

            @Override
            public void method_48579(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
                super.method_48579(poseStack, mouseX, mouseY, partialTick);
                if (this.method_37303() && this.method_25367()) {
                    RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
                    class_332.method_25302((class_4587)poseStack, (int)(this.method_46426() - 6), (int)(this.method_46427() + 6), (int)12, (int)0, (int)4, (int)4);
                    class_332.method_25302((class_4587)poseStack, (int)(this.method_46426() + this.method_25368() + 2), (int)(this.method_46427() + 6), (int)12, (int)0, (int)4, (int)4);
                }
            }
        }
    }

    private static class GameScene
    extends Scene {
        private final PaddleBallGraphics game;
        private final MainMenuScene.MenuButton backButton;

        public GameScene(PaddleBallGraphics game) {
            this.game = game;
            this.backButton = this.addWidget(new MainMenuScene.MenuButton(100, 16, this.game.translation("main_menu"), btn -> game.setScene(new MainMenuScene(game))));
            this.backButton.setBackgroundHighlightColour(-12107714);
            this.backButton.setTextHighlightColour(-14540251);
            this.backButton.setClickSound((class_3414)ModSounds.UI_PADDLE_BALL_RETRO_CLICK.get());
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
            this.backButton.method_48229(contentStart + (this.game.width - this.backButton.method_25368()) / 2, contentTop + 60);
        }

        @Override
        public void tick() {
            this.sendInputToServer();
            if (this.game.scoreAnimation > 0) {
                --this.game.scoreAnimation;
            }
        }

        @Override
        public void render(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
            this.backButton.field_22763 = this.game.wonGame != null;
            this.backButton.field_22764 = this.game.wonGame != null;
            class_310 mc = class_310.method_1551();
            poseStack.method_22903();
            poseStack.method_46416(100.0f, 4.0f, 0.0f);
            poseStack.method_22903();
            String label = Integer.toString(this.game.playerScore);
            int width = mc.field_1772.method_1727(label) * 2;
            poseStack.method_46416((float)(-width - 7), 0.0f, 0.0f);
            poseStack.method_22905(2.0f, 2.0f, 2.0f);
            ScreenHelper.drawString(poseStack, label, 0, 0, -13684941, false);
            poseStack.method_22909();
            poseStack.method_22903();
            poseStack.method_22905(2.0f, 2.0f, 2.0f);
            int breakWidth = mc.field_1772.method_1727(label) / 2;
            ScreenHelper.drawString(poseStack, "-", -breakWidth, 0, -13684941, false);
            poseStack.method_22909();
            poseStack.method_22903();
            poseStack.method_46416(7.0f, 0.0f, 0.0f);
            poseStack.method_22905(2.0f, 2.0f, 2.0f);
            ScreenHelper.drawString(poseStack, Integer.toString(this.game.opponentScore), 0, 0, -13684941, false);
            poseStack.method_22909();
            poseStack.method_22909();
            ScreenHelper.drawString(poseStack, this.game.translation("you"), 5, 5, -13684941, false);
            String opponentName = this.game.opponentName;
            ScreenHelper.drawString(poseStack, opponentName, 195 - mc.field_1772.method_1727(opponentName), 5, -13684941, false);
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
            poseStack.method_22903();
            float smoothHostPos = class_3532.method_16439((float)partialTick, (float)this.game.lastPlayerPos, (float)this.game.playerPos);
            poseStack.method_46416(4.0f, smoothHostPos, 0.0f);
            class_332.method_25302((class_4587)poseStack, (int)0, (int)0, (int)0, (int)0, (int)6, (int)28);
            poseStack.method_22909();
            poseStack.method_22903();
            float smoothOpponentPos = class_3532.method_16439((float)partialTick, (float)this.game.lastOpponentPos, (float)this.game.opponentPos);
            poseStack.method_46416(192.0f, smoothOpponentPos, 0.0f);
            class_332.method_25302((class_4587)poseStack, (int)-2, (int)0, (int)6, (int)0, (int)6, (int)28);
            poseStack.method_22909();
            poseStack.method_22903();
            float smoothBallX = class_3532.method_16439((float)partialTick, (float)this.game.lastBallX, (float)this.game.ballX);
            float smoothBallY = class_3532.method_16439((float)partialTick, (float)this.game.lastBallY, (float)this.game.ballY);
            smoothBallX = this.game.leftPaddle ? smoothBallX : 200.0f - smoothBallX;
            poseStack.method_46416(smoothBallX, smoothBallY, 0.0f);
            class_332.method_25302((class_4587)poseStack, (int)0, (int)0, (int)12, (int)0, (int)4, (int)4);
            poseStack.method_22909();
            if (this.game.scoreAnimation > 0 && this.game.scoreAnimation / 5 % 2 == 0) {
                poseStack.method_22903();
                poseStack.method_46416((float)(196 * this.game.scoreSide), 0.0f, 0.0f);
                class_332.method_25294((class_4587)poseStack, (int)0, (int)0, (int)4, (int)100, (int)-10143432);
                poseStack.method_22909();
            }
            if (this.game.wonGame != null && this.game.displayLabel != null) {
                class_2561 bannerLabel = this.game.displayLabel;
                int bannerColour = this.game.wonGame != false ? -13147337 : -10143432;
                class_332.method_27534((class_4587)poseStack, (class_327)mc.field_1772, (class_2561)bannerLabel, (int)(this.game.width / 2), (int)40, (int)bannerColour);
            }
        }

        private void sendInputToServer() {
            boolean up = class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)265);
            boolean down = class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)264);
            byte input = (byte)(up && down ? 0 : (up ? 1 : (down ? 2 : 0)));
            Network.getPlay().sendToServer((IMessage)new MessagePaddleBall.Action(PaddleBall.Action.INPUT, input));
        }
    }

    private static class PendingScene
    extends Scene {
        private final PaddleBallGraphics game;
        private final MainMenuScene.MenuButton backButton;

        private PendingScene(PaddleBallGraphics game) {
            this.game = game;
            this.backButton = this.addWidget(new MainMenuScene.MenuButton(100, 16, this.game.translation("cancel"), btn -> {
                Network.getPlay().sendToServer((IMessage)new MessagePaddleBall.Action(PaddleBall.Action.UPDATE_STATE, 0));
                game.setScene(new MainMenuScene(game));
            }));
            this.backButton.setClickSound((class_3414)ModSounds.UI_PADDLE_BALL_RETRO_CLICK.get());
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
            this.backButton.method_48229(contentStart + (this.game.width - this.backButton.method_25368()) / 2, contentTop + 65);
        }

        @Override
        public void render(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
            class_332.method_25302((class_4587)poseStack, (int)((this.game.width - 128) / 2), (int)10, (int)16, (int)0, (int)128, (int)24);
            String loading = switch ((int)(class_156.method_658() / 300L % 4L)) {
                default -> "O o o";
                case 1, 3 -> "o O o";
                case 2 -> "o o O";
            };
            class_310 mc = class_310.method_1551();
            class_332.method_25300((class_4587)poseStack, (class_327)mc.field_1772, (String)loading, (int)(this.game.width / 2), (int)50, (int)-2896706);
            class_332.method_27534((class_4587)poseStack, (class_327)mc.field_1772, (class_2561)this.game.translation("searching_players"), (int)(this.game.width / 2), (int)40, (int)-2896706);
        }
    }
}

