/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.network.play;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.blockentity.FryingPanBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.GrillBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IWaterTap;
import com.mrcrayfish.furniture.refurbished.blockentity.TelevisionBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.IFluidContainerBlock;
import com.mrcrayfish.furniture.refurbished.client.ClientComputer;
import com.mrcrayfish.furniture.refurbished.client.FurnitureScreens;
import com.mrcrayfish.furniture.refurbished.client.LinkHandler;
import com.mrcrayfish.furniture.refurbished.client.ToolAnimationRenderer;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.PostBoxScreen;
import com.mrcrayfish.furniture.refurbished.client.gui.toast.ItemToast;
import com.mrcrayfish.furniture.refurbished.client.particle.ItemFlushParticle;
import com.mrcrayfish.furniture.refurbished.computer.client.DisplayableProgram;
import com.mrcrayfish.furniture.refurbished.computer.client.graphics.PaddleBallGraphics;
import com.mrcrayfish.furniture.refurbished.inventory.ComputerMenu;
import com.mrcrayfish.furniture.refurbished.inventory.WorkbenchMenu;
import com.mrcrayfish.furniture.refurbished.network.message.MessageClearMessage;
import com.mrcrayfish.furniture.refurbished.network.message.MessageComputerState;
import com.mrcrayfish.furniture.refurbished.network.message.MessageDoorbellNotification;
import com.mrcrayfish.furniture.refurbished.network.message.MessageFlipAnimation;
import com.mrcrayfish.furniture.refurbished.network.message.MessageFlushItem;
import com.mrcrayfish.furniture.refurbished.network.message.MessageNameMailbox;
import com.mrcrayfish.furniture.refurbished.network.message.MessagePaddleBall;
import com.mrcrayfish.furniture.refurbished.network.message.MessageSyncFluid;
import com.mrcrayfish.furniture.refurbished.network.message.MessageSyncLink;
import com.mrcrayfish.furniture.refurbished.network.message.MessageTelevisionChannel;
import com.mrcrayfish.furniture.refurbished.network.message.MessageToolAnimation;
import com.mrcrayfish.furniture.refurbished.network.message.MessageUpdateMailboxes;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWaterTapAnimation;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWorkbench;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_437;
import net.minecraft.class_4599;
import net.minecraft.class_5250;
import net.minecraft.class_703;
import net.minecraft.class_898;

public class ClientPlayHandler {
    public static void handleMessageSyncFluid(MessageSyncFluid message) {
        IFluidContainerBlock block;
        FluidContainer container;
        class_310 mc = class_310.method_1551();
        class_1937 level = (class_1937)Objects.requireNonNull(mc.field_1687);
        class_2586 class_25862 = level.method_8321(message.getPos());
        if (class_25862 instanceof IFluidContainerBlock && (container = (block = (IFluidContainerBlock)class_25862).getFluidContainer()) != null) {
            container.handleSync(level, message.getFluid(), message.getAmount());
        }
    }

    public static void handleMessageFlipAnimation(MessageFlipAnimation message) {
        class_310 mc = class_310.method_1551();
        class_1937 level = (class_1937)Objects.requireNonNull(mc.field_1687);
        class_2586 class_25862 = level.method_8321(message.getPos());
        if (class_25862 instanceof GrillBlockEntity) {
            GrillBlockEntity grill = (GrillBlockEntity)class_25862;
            grill.playFlipAnimation(message.getIndex());
        } else {
            class_25862 = level.method_8321(message.getPos());
            if (class_25862 instanceof FryingPanBlockEntity) {
                FryingPanBlockEntity fryingPan = (FryingPanBlockEntity)class_25862;
                fryingPan.playFlipAnimation(message.getIndex());
            }
        }
    }

    public static void handleMessageUpdateMailboxes(MessageUpdateMailboxes message) {
        PostBoxScreen.updateMailboxes(message.getMailboxes());
    }

    public static void handleMessageClearMessage(MessageClearMessage message) {
        class_310 mc = class_310.method_1551();
        class_437 class_4372 = mc.field_1755;
        if (class_4372 instanceof PostBoxScreen) {
            PostBoxScreen postBox = (PostBoxScreen)class_4372;
            postBox.clearMessage();
        }
    }

    public static void handleMessageDoorbell(MessageDoorbellNotification message) {
        if (((Boolean)Config.CLIENT.doorbellNotification.get()).booleanValue()) {
            class_310 mc = class_310.method_1551();
            class_5250 title = Utils.translation("gui", "doorbell_rang", new Object[0]);
            class_5250 description = class_2561.method_43470((String)message.getName());
            mc.method_1566().method_1999((class_368)new ItemToast((class_2561)title, (class_2561)description, new class_1799((class_1935)class_1802.field_16315)));
        }
    }

    public static void handleMessageSyncLink(MessageSyncLink message) {
        LinkHandler.get().setLinkingNode(message.getPos());
    }

    public static void handleMessageTelevisionChannel(MessageTelevisionChannel message) {
        class_310 mc = class_310.method_1551();
        class_1937 level = (class_1937)Objects.requireNonNull(mc.field_1687);
        class_2586 class_25862 = level.method_8321(message.getPos());
        if (class_25862 instanceof TelevisionBlockEntity) {
            TelevisionBlockEntity television = (TelevisionBlockEntity)class_25862;
            television.setChannelFromId(message.getChannel());
        }
    }

    public static void handleMessageComputerState(MessageComputerState message) {
        class_310 mc = class_310.method_1551();
        class_1703 class_17032 = mc.field_1724.field_7512;
        if (class_17032 instanceof ComputerMenu) {
            ComputerMenu menu = (ComputerMenu)class_17032;
            ClientComputer computer = (ClientComputer)menu.getComputer();
            computer.launchProgram(message.getId());
        }
    }

    @Nullable
    private static PaddleBallGraphics getPaddleGame() {
        ComputerMenu menu;
        ClientComputer computer;
        DisplayableProgram<?> displayableProgram;
        class_310 mc = class_310.method_1551();
        class_1703 class_17032 = mc.field_1724.field_7512;
        if (class_17032 instanceof ComputerMenu && (displayableProgram = (computer = (ClientComputer)(menu = (ComputerMenu)class_17032).getComputer()).getDisplayable()) instanceof PaddleBallGraphics) {
            PaddleBallGraphics game = (PaddleBallGraphics)displayableProgram;
            return game;
        }
        return null;
    }

    public static void handleMessageTennisGamePaddlePosition(MessagePaddleBall.PaddlePosition message) {
        PaddleBallGraphics game = ClientPlayHandler.getPaddleGame();
        if (game != null) {
            game.updatePaddles(message.getPlayerPos(), message.getOpponentPos());
        }
    }

    public static void handleMessageTennisGameBallUpdate(MessagePaddleBall.BallUpdate message) {
        PaddleBallGraphics game = ClientPlayHandler.getPaddleGame();
        if (game != null) {
            game.updateBall(message.getBallX(), message.getBallY(), message.getVelocityX(), message.getVelocityY());
        }
    }

    public static void handleMessagePaddleBallEvent(MessagePaddleBall.Event message) {
        PaddleBallGraphics game = ClientPlayHandler.getPaddleGame();
        if (game != null) {
            game.handleEvent(message.getEvent());
        }
    }

    public static void handleMessagePaddleBallOpponentName(MessagePaddleBall.OpponentName message) {
        PaddleBallGraphics game = ClientPlayHandler.getPaddleGame();
        if (game != null) {
            game.handleOpponentName(message.getName());
        }
    }

    public static void handleMessageToolAnimation(MessageToolAnimation message) {
        switch (message.getTool()) {
            case SPATULA: {
                ToolAnimationRenderer.get().playSpatulaAnimation(message.getPos(), message.getDirection());
                break;
            }
            case KNIFE: {
                ToolAnimationRenderer.get().playKnifeAnimation(message.getPos(), message.getDirection());
            }
        }
    }

    public static void handleMessageFlushItem(MessageFlushItem message) {
        class_1297 class_12972;
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 != null && (class_12972 = mc.field_1687.method_8469(message.getEntityId())) instanceof class_1542) {
            class_1542 entity = (class_1542)class_12972;
            class_898 dispatcher = mc.method_1561();
            class_4599 buffers = mc.method_22940();
            class_243 pos = class_243.method_24953((class_2382)message.getPos());
            mc.field_1713.method_3058((class_703)new ItemFlushParticle(dispatcher, buffers, mc.field_1687, entity, pos));
            mc.field_1687.method_2945(message.getEntityId(), class_1297.class_5529.field_26999);
        }
    }

    public static void handleMessageWaterTapAnimation(MessageWaterTapAnimation message) {
        class_2586 class_25862;
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 != null && (class_25862 = mc.field_1687.method_8321(message.getPos())) instanceof IWaterTap) {
            IWaterTap tap = (IWaterTap)class_25862;
            tap.playWaterAnimation();
        }
    }

    public static void handleMessageWorkbenchItemCounts(MessageWorkbench.ItemCounts message) {
        class_1703 class_17032;
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null && (class_17032 = mc.field_1724.field_7512) instanceof WorkbenchMenu) {
            WorkbenchMenu menu = (WorkbenchMenu)class_17032;
            menu.updateItemCounts(message.getCounts());
        }
    }

    public static void handleMessageNameMailbox(MessageNameMailbox message) {
        FurnitureScreens.openNameableScreen(message.getPos(), (class_2561)Utils.translation("gui", "set_mailbox_name", new Object[0]), 32);
    }
}

