/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.platform;

import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.platform.services.IFluidHelper;
import it.unimi.dsi.fastutil.Pair;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorageUtil;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.SingleFluidStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3414;
import net.minecraft.class_3611;

public class FabricFluidHelper
implements IFluidHelper {
    @Override
    public long getBucketCapacity() {
        return 81000L;
    }

    @Override
    public class_3414 getBucketEmptySound(class_3611 fluid) {
        return FluidVariantAttributes.getEmptySound((FluidVariant)FluidVariant.of((class_3611)fluid));
    }

    @Override
    public FluidContainer createFluidContainer(long capacity, @Nullable Consumer<FluidContainer> onChange) {
        return new FabricFluidContainer(capacity, onChange);
    }

    @Override
    public class_1269 performInteractionWithBlock(class_1657 player, class_1268 hand, class_1937 level, class_2338 pos, class_2350 face) {
        Storage storage = (Storage)FluidStorage.SIDED.find(level, pos, (Object)face);
        return storage != null && FluidStorageUtil.interactWithFluidStorage((Storage)storage, (class_1657)player, (class_1268)hand) ? class_1269.field_5812 : class_1269.field_5811;
    }

    @Override
    public boolean isFluidContainerItem(class_1799 stack) {
        return !stack.method_7960() && FluidStorage.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack)) != null;
    }

    public static class FabricFluidContainer
    extends FluidContainer {
        private final SingleFluidStorage tank;

        protected FabricFluidContainer(long capacity, @Nullable Consumer<FluidContainer> onChange) {
            this.tank = SingleFluidStorage.withFixedCapacity((long)capacity, () -> {
                if (onChange != null) {
                    onChange.accept(this);
                }
            });
        }

        @Override
        public long getCapacity() {
            return this.tank.getCapacity();
        }

        @Override
        public boolean isEmpty() {
            return this.tank.isResourceBlank();
        }

        @Override
        public class_3611 getStoredFluid() {
            return ((FluidVariant)this.tank.getResource()).getFluid();
        }

        @Override
        public long getStoredAmount() {
            return this.tank.getAmount();
        }

        @Override
        protected void setStored(class_3611 fluid, long amount) {
            this.tank.variant = FluidVariant.of((class_3611)fluid);
            this.tank.amount = amount;
        }

        @Override
        public long push(class_3611 fluid, long amount, boolean simulate) {
            try (Transaction transaction = Transaction.openOuter();){
                long filled = this.tank.insert((TransferVariant)FluidVariant.of((class_3611)fluid), amount, (TransactionContext)transaction);
                if (!simulate) {
                    transaction.commit();
                }
                long l = filled;
                return l;
            }
        }

        @Override
        public Pair<class_3611, Long> pull(long amount, boolean simulate) {
            try (Transaction transaction = Transaction.openOuter();){
                FluidVariant variant = (FluidVariant)this.tank.getResource();
                long drained = this.tank.extract((TransferVariant)variant, amount, (TransactionContext)transaction);
                if (!simulate) {
                    transaction.commit();
                }
                Pair pair = Pair.of((Object)variant.getFluid(), (Object)drained);
                return pair;
            }
        }

        @Override
        public void load(class_2487 tag) {
            this.tank.readNbt(tag.method_10562("FluidTank"));
        }

        @Override
        public void save(class_2487 tag) {
            class_2487 tankTag = new class_2487();
            this.tank.writeNbt(tankTag);
            tag.method_10566("FluidTank", (class_2520)tankTag);
        }

        public SingleFluidStorage getTank() {
            return this.tank;
        }
    }
}

