/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.google.common.base.Preconditions;
import com.mrcrayfish.furniture.refurbished.blockentity.BasicLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.CuttingBoardCombiningRecipe;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class CuttingBoardBlockEntity
extends BasicLootBlockEntity {
    private final RecipeManager.CachedCheck<Container, ? extends SingleItemRecipe> slicingRecipeCache;
    private final RecipeManager.CachedCheck<Container, CuttingBoardCombiningRecipe> combiningRecipeCache;
    private final RecipeManager.CachedCheck<Container, ? extends SingleItemRecipe> outputCache;
    protected final int useableContainerSize;
    protected boolean sync;
    protected boolean canExtract;
    protected boolean placedByPlayer;

    public CuttingBoardBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.CUTTING_BOARD.get(), pos, state, 5, (RecipeType<? extends SingleItemRecipe>)((RecipeType)ModRecipeTypes.CUTTING_BOARD_SLICING.get()), (RecipeType<CuttingBoardCombiningRecipe>)((RecipeType)ModRecipeTypes.CUTTING_BOARD_COMBINING.get()));
    }

    public CuttingBoardBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int containerSize, RecipeType<? extends SingleItemRecipe> slicingRecipeType, RecipeType<CuttingBoardCombiningRecipe> combiningRecipeType) {
        super(type, pos, state, containerSize + 1);
        this.useableContainerSize = containerSize;
        this.slicingRecipeCache = RecipeManager.m_220267_(slicingRecipeType);
        this.combiningRecipeCache = RecipeManager.m_220267_(combiningRecipeType);
        this.outputCache = RecipeManager.m_220267_(slicingRecipeType);
    }

    @Override
    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        return false;
    }

    protected Component m_6820_() {
        return Utils.translation("container", "cutting_board", new Object[0]);
    }

    protected AbstractContainerMenu m_6555_(int windowId, Inventory playerInventory) {
        return null;
    }

    public boolean placeItem(ItemStack heldItem) {
        int placeIndex = this.getPlaceIndex();
        if (this.m_7013_(placeIndex, heldItem)) {
            ItemStack copy = heldItem.m_41777_();
            copy.m_41764_(1);
            heldItem.m_41774_(1);
            if (!this.f_58857_.m_5776_()) {
                this.placedByPlayer = true;
                this.canExtract = false;
                this.playPlaceIngredientSound(1.0f);
            }
            this.m_6836_(placeIndex, copy);
            return true;
        }
        return false;
    }

    public void removeItem() {
        int removeIndex = this.getHeadIndex();
        if (removeIndex >= 0 && !this.m_8020_(removeIndex).m_41619_()) {
            ItemStack stack = this.m_8020_(removeIndex);
            this.spawnItemIntoLevel(this.f_58857_, stack);
            this.m_6836_(removeIndex, ItemStack.f_41583_);
            this.canExtract = false;
        }
    }

    public boolean sliceItem(Level level, boolean spawnIntoLevel) {
        int sliceIndex = this.getHeadIndex();
        if (sliceIndex != 0) {
            return false;
        }
        ItemStack input = this.m_8020_(sliceIndex);
        Optional<? extends SingleItemRecipe> recipe = this.getSlicingRecipe(input);
        if (recipe.isPresent()) {
            if (!this.f_58857_.m_5776_()) {
                level.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.ITEM_KNIFE_CHOP.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                this.spawnSliceParticles(input);
                this.spawnSliceResultFromRecipe(sliceIndex, recipe.get(), spawnIntoLevel);
            }
            return true;
        }
        return false;
    }

    private void spawnSliceParticles(ItemStack stack) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.f_58858_;
            RandomSource rand = serverLevel.m_213780_();
            for (int i = 0; i < 8; ++i) {
                serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5, 1, rand.m_188583_() * 0.15, rand.m_188500_() * 0.2, rand.m_188583_() * 0.15, 0.0);
            }
        }
    }

    private void spawnMagicParticles() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.f_58858_;
            RandomSource rand = serverLevel.m_213780_();
            for (int i = 0; i < 8; ++i) {
                double x = (double)pos.m_123341_() + 0.5 + 0.3 * rand.m_188583_();
                double y = (double)pos.m_123342_() + 0.1;
                double z = (double)pos.m_123343_() + 0.5 + 0.3 * rand.m_188583_();
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123749_, x, y, z, 1, rand.m_188583_() * 0.02, rand.m_188583_() * 0.02, rand.m_188583_() * 0.02, 0.0);
            }
        }
    }

    private void spawnSliceResultFromRecipe(int sliceIndex, SingleItemRecipe recipe, boolean spawnIntoLevel) {
        Preconditions.checkNotNull((Object)this.f_58857_);
        ItemStack result = recipe.m_8043_();
        if (spawnIntoLevel) {
            this.spawnItemIntoLevel(this.f_58857_, result);
            this.m_6836_(sliceIndex, ItemStack.f_41583_);
            return;
        }
        this.m_6836_(sliceIndex, result.m_41777_());
        this.canExtract = true;
    }

    private void spawnItemIntoLevel(Level level, ItemStack stack) {
        BlockPos pos = this.f_58858_;
        ItemEntity entity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.0625, (double)pos.m_123343_() + 0.5, stack.m_41777_());
        entity.m_32060_();
        entity.m_20256_(new Vec3(0.0, 0.15, 0.0));
        level.m_7967_((Entity)entity);
    }

    private void playPlaceIngredientSound(float pitch) {
        Level level = Objects.requireNonNull(this.f_58857_);
        Vec3 vec = Vec3.m_82539_((Vec3i)this.f_58858_);
        level.m_6263_(null, vec.f_82479_, vec.f_82480_, vec.f_82481_, (SoundEvent)ModSounds.BLOCK_CUTTING_BOARD_PLACED_INGREDIENT.get(), SoundSource.PLAYERS, 1.0f, pitch + 0.05f * (float)level.f_46441_.m_188583_());
    }

    public int getPlaceIndex() {
        return this.getHeadIndex() + 1;
    }

    public int getHeadIndex() {
        for (int i = this.useableContainerSize - 1; i >= 0; --i) {
            if (this.m_8020_(i).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean m_7013_(int slotIndex, ItemStack stack) {
        return slotIndex >= 0 && slotIndex < this.useableContainerSize && slotIndex == this.getPlaceIndex() && this.isSlotInsertable(slotIndex) && this.canPlaceOnTop(stack);
    }

    @Override
    public boolean m_7157_(int slotIndex, ItemStack stack, Direction direction) {
        if (slotIndex >= 0 && slotIndex < this.useableContainerSize && slotIndex == this.getHeadIndex() && this.canExtract) {
            return this.outputCache.m_213657_((Container)new SimpleContainer(new ItemStack[]{stack}), Objects.requireNonNull(this.f_58857_)).isEmpty();
        }
        return true;
    }

    public void m_6836_(int slotIndex, ItemStack stack) {
        super.m_6836_(slotIndex, stack);
        if (!stack.m_41619_() && this.getHeadIndex() >= 0 && !Objects.requireNonNull(this.f_58857_).m_5776_()) {
            this.craftCombiningRecipe(this.placedByPlayer);
        }
    }

    public ItemStack m_7407_(int slotIndex, int count) {
        ItemStack stack = super.m_7407_(slotIndex, count);
        if (this.m_7983_()) {
            this.canExtract = false;
        }
        return stack;
    }

    @Override
    protected boolean isSlotInsertable(int slotIndex) {
        ItemStack target = this.m_8020_(slotIndex);
        return target.m_41619_() || target.m_41613_() < target.m_41741_() && target.m_41613_() < 1;
    }

    public boolean canPlaceOnTop(ItemStack stack) {
        return this.getNextCombiningRecipe(stack).isPresent() || this.getHeadIndex() == -1 && this.getSlicingRecipe(stack).isPresent();
    }

    private Optional<? extends SingleItemRecipe> getSlicingRecipe(ItemStack stack) {
        return this.slicingRecipeCache.m_213657_((Container)new SimpleContainer(new ItemStack[]{stack}), Objects.requireNonNull(this.f_58857_));
    }

    private Optional<CuttingBoardCombiningRecipe> getCombiningRecipe() {
        return this.combiningRecipeCache.m_213657_((Container)this, Objects.requireNonNull(this.f_58857_));
    }

    private Optional<CuttingBoardCombiningRecipe> getNextCombiningRecipe(ItemStack stack) {
        int placeIndex = this.getPlaceIndex();
        if (placeIndex >= this.useableContainerSize) {
            return Optional.empty();
        }
        SimpleContainer container = new SimpleContainer(placeIndex + 1);
        IntStream.range(0, placeIndex + 1).forEach(arg_0 -> this.lambda$getNextCombiningRecipe$0((Container)container, arg_0));
        container.m_6836_(container.m_6643_() - 1, stack);
        return this.combiningRecipeCache.m_213657_((Container)container, Objects.requireNonNull(this.f_58857_));
    }

    private void craftCombiningRecipe(boolean spawnIntoLevel) {
        this.placedByPlayer = false;
        Optional<CuttingBoardCombiningRecipe> optional = this.getCombiningRecipe();
        if (optional.isEmpty()) {
            return;
        }
        CuttingBoardCombiningRecipe recipe = optional.get();
        if (!recipe.completelyMatches((Container)this)) {
            return;
        }
        Level level = Objects.requireNonNull(this.f_58857_);
        ItemStack stack = recipe.m_5874_((Container)this);
        List<ItemStack> remainingItems = this.getCraftingRemainingItems();
        this.m_6211_();
        this.m_6596_();
        this.spawnSliceParticles(stack);
        this.spawnMagicParticles();
        Vec3 center = Vec3.m_82539_((Vec3i)this.f_58858_);
        level.m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (spawnIntoLevel) {
            this.spawnItemIntoLevel(level, stack);
            remainingItems.forEach(item -> this.spawnItemIntoLevel(this.f_58857_, (ItemStack)item));
            return;
        }
        this.m_6836_(0, stack);
        for (int i = 0; i < remainingItems.size() && i < this.useableContainerSize; ++i) {
            this.m_6836_(i + 1, remainingItems.get(i));
        }
        this.canExtract = true;
    }

    private List<ItemStack> getCraftingRemainingItems() {
        ArrayList<ItemStack> remainingItems = new ArrayList<ItemStack>();
        for (int i = 0; i < this.useableContainerSize; ++i) {
            Item item;
            ItemStack stack = this.m_8020_(i);
            if (stack.m_41619_() || !stack.m_41720_().m_41470_() || (item = stack.m_41720_().m_41469_()) == null) continue;
            remainingItems.add(new ItemStack((ItemLike)item));
        }
        return remainingItems;
    }

    public void m_6596_() {
        super.m_6596_();
        this.sync();
    }

    protected void sync() {
        this.sync = true;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CuttingBoardBlockEntity entity) {
        if (entity.sync) {
            BlockEntityHelper.sendCustomUpdate((BlockEntity)entity, entity.m_5995_());
            entity.sync = false;
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("CanExtract", this.canExtract);
        tag.m_128379_("PlacedByPlayer", this.placedByPlayer);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128425_("CanExtract", 1)) {
            this.canExtract = compound.m_128471_("CanExtract");
        }
        if (compound.m_128425_("PlacedByPlayer", 1)) {
            this.placedByPlayer = compound.m_128471_("PlacedByPlayer");
        }
    }

    private /* synthetic */ void lambda$getNextCombiningRecipe$0(Container container, int index) {
        container.m_6836_(index, this.m_8020_(index));
    }
}

