/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.block.MicrowaveBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleProcessingLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IHomeControlDevice;
import com.mrcrayfish.furniture.refurbished.blockentity.ILevelAudio;
import com.mrcrayfish.furniture.refurbished.blockentity.IPowerSwitch;
import com.mrcrayfish.furniture.refurbished.client.audio.AudioManager;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.inventory.BuildableContainerData;
import com.mrcrayfish.furniture.refurbished.inventory.IContainerHolder;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class MicrowaveBlockEntity
extends ElectricityModuleProcessingLootBlockEntity
implements IPowerSwitch,
IHomeControlDevice,
ILevelAudio,
Nameable,
StackedContentsCompatible {
    public static final int[] INPUT_SLOTS = new int[]{0};
    public static final int[] OUTPUT_SLOTS = new int[]{1};
    public static final int DATA_POWERED = 0;
    public static final int DATA_ENABLED = 1;
    public static final int DATA_PROCESS_TIME = 2;
    public static final int DATA_MAX_PROCESS_TIME = 3;
    public static final double MAX_AUDIO_DISTANCE = Mth.m_144952_((double)3.5);
    protected final Vec3 audioPosition;
    protected boolean enabled;
    protected boolean processing;
    protected final ContainerData data = new BuildableContainerData(builder -> {
        builder.add(0, () -> this.powered ? 1 : 0, value -> {});
        builder.add(1, () -> this.enabled ? 1 : 0, value -> {});
        builder.add(2, () -> this.processingTime, value -> {
            this.processingTime = value;
        });
        builder.add(3, () -> this.totalProcessingTime, value -> {
            this.totalProcessingTime = value;
        });
    });

    public MicrowaveBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.MICROWAVE.get(), pos, state, (RecipeType<? extends ProcessingRecipe>)((RecipeType)ModRecipeTypes.MICROWAVE_HEATING.get()));
    }

    public MicrowaveBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, RecipeType<? extends ProcessingRecipe> recipeType) {
        super(type, pos, state, 2, recipeType);
        this.audioPosition = Vec3.m_82512_((Vec3i)pos);
    }

    protected Component m_6820_() {
        return Utils.translation("container", "microwave", new Object[0]);
    }

    protected AbstractContainerMenu m_6555_(int windowId, Inventory playerInventory) {
        return Services.MENU.createMicrowaveMenu(windowId, playerInventory, (Container)this, this.data);
    }

    @Override
    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        IContainerHolder holder;
        return menu instanceof IContainerHolder && (holder = (IContainerHolder)menu).container() == this;
    }

    @Override
    public int[] getInputSlots() {
        return INPUT_SLOTS;
    }

    @Override
    public int[] getOutputSlots() {
        return OUTPUT_SLOTS;
    }

    @Override
    public int[] getEnergySlots() {
        return NO_SLOTS;
    }

    @Override
    public boolean canProcess() {
        return super.canProcess() && this.enabled;
    }

    @Override
    public void onOpen(Level level, BlockPos pos, BlockState state) {
        level.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.BLOCK_MICROWAVE_OPEN.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.f_46441_.m_188501_());
        this.setDoorState(state, true);
    }

    @Override
    public void onClose(Level level, BlockPos pos, BlockState state) {
        level.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.BLOCK_MICROWAVE_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.f_46441_.m_188501_());
        this.setDoorState(state, false);
    }

    private void setDoorState(BlockState state, boolean open) {
        Level level = this.m_58904_();
        if (level != null) {
            level.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)MicrowaveBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    @Override
    public void togglePower() {
        this.enabled = !this.enabled;
        this.m_6596_();
        BlockEntityHelper.sendCustomUpdate((BlockEntity)this, this.m_5995_());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("Enabled", 1)) {
            this.enabled = tag.m_128471_("Enabled");
        }
        if (tag.m_128425_("Processing", 1)) {
            this.processing = tag.m_128471_("Processing");
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("Enabled", this.enabled);
        tag.m_128379_("Processing", this.processing);
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128379_("Enabled", this.enabled);
        tag.m_128379_("Processing", this.processing);
        BlockEntityHelper.saveCustomName(tag, this.m_7770_());
        return tag;
    }

    @Override
    public BlockPos getDevicePos() {
        return this.f_58858_;
    }

    @Override
    public boolean isDeviceEnabled() {
        return this.enabled;
    }

    @Override
    public void toggleDeviceState() {
        this.enabled = !this.enabled;
        this.m_6596_();
        this.syncDataToTrackingClients();
    }

    @Override
    public void setDeviceState(boolean enabled) {
        this.enabled = enabled;
        this.m_6596_();
        this.syncDataToTrackingClients();
    }

    @Override
    public Component getDeviceName() {
        if (this.m_8077_()) {
            return this.m_7770_();
        }
        return this.m_6820_();
    }

    @Override
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.BLOCK_MICROWAVE_FAN.get();
    }

    @Override
    public SoundSource getSource() {
        return SoundSource.BLOCKS;
    }

    @Override
    public Vec3 getAudioPosition() {
        return this.audioPosition;
    }

    @Override
    public boolean canPlayAudio() {
        return this.isNodePowered() && this.processing && this.enabled && !this.m_58901_();
    }

    @Override
    public int getAudioHash() {
        return this.f_58858_.hashCode();
    }

    @Override
    public boolean isAudioEqual(ILevelAudio other) {
        return this == other;
    }

    @Override
    public double getAudioRadiusSqr() {
        return MAX_AUDIO_DISTANCE;
    }

    @Override
    public void moduleTick(Level level) {
        super.moduleTick(level);
        if (!level.f_46443_) {
            boolean processing = this.processTick();
            if (this.processing != processing) {
                this.processing = processing;
                this.syncDataToTrackingClients();
            }
        } else {
            AudioManager.get().playLevelAudio(this);
        }
    }

    public void m_5809_(StackedContents contents) {
        for (ItemStack stack : this.items) {
            contents.m_36491_(stack);
        }
    }
}

