/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity.fluid;

import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.blockentity.IWaterTap;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWaterTapAnimation;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface IFluidContainerBlock {
    @Nullable
    public FluidContainer getFluidContainer();

    default public InteractionResult tryAndFillWithFluid(Level level, BlockPos pos, Fluid fluid, @Nullable Vec3 splashPos) {
        FluidContainer container = this.getFluidContainer();
        if (container == null) {
            return InteractionResult.PASS;
        }
        if (!container.isEmpty() && !container.getStoredFluid().m_6212_(fluid)) {
            return InteractionResult.PASS;
        }
        if (container.getStoredAmount() >= container.getCapacity()) {
            return InteractionResult.PASS;
        }
        long filled = container.push(fluid, FluidContainer.BUCKET_CAPACITY, false);
        if (filled > 0L) {
            SoundEvent event;
            if (fluid.m_6212_((Fluid)Fluids.f_76193_)) {
                BlockEntity entity;
                IFluidContainerBlock iFluidContainerBlock;
                if (splashPos != null && !level.m_5776_()) {
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123769_, splashPos.f_82479_, splashPos.f_82480_, splashPos.f_82481_, 10, 0.0, 0.0, 0.0, 0.0);
                }
                if ((iFluidContainerBlock = this) instanceof BlockEntity && (entity = (BlockEntity)iFluidContainerBlock) instanceof IWaterTap && !level.m_5776_()) {
                    Network.getPlay().sendToTrackingBlockEntity(() -> entity, (IMessage)new MessageWaterTapAnimation(pos));
                    level.m_5594_(null, pos, (SoundEvent)ModSounds.BLOCK_KITCHEN_SINK_FILL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
            if ((event = Services.FLUID.getBucketEmptySound(fluid)) != null && !level.m_5776_()) {
                Vec3 soundPos = splashPos != null ? splashPos : Vec3.m_82512_((Vec3i)pos);
                level.m_6263_(null, soundPos.f_82479_, soundPos.f_82480_, soundPos.f_82481_, event, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    default public InteractionResult tryAndCreateObsidian(Level level, BlockPos pos, Fluid dispensingFluid, Vec3 spawnPos) {
        FluidContainer container = this.getFluidContainer();
        if (container == null) {
            return InteractionResult.PASS;
        }
        if (!dispensingFluid.m_6212_((Fluid)Fluids.f_76193_)) {
            return InteractionResult.PASS;
        }
        if (container.getStoredAmount() < FluidContainer.BUCKET_CAPACITY || !container.getStoredFluid().m_6212_((Fluid)Fluids.f_76195_)) {
            return InteractionResult.PASS;
        }
        Pair<Fluid, Long> drained = container.pull(FluidContainer.BUCKET_CAPACITY, true);
        if ((Long)drained.right() != FluidContainer.BUCKET_CAPACITY) {
            return InteractionResult.PASS;
        }
        if (!level.m_5776_()) {
            container.pull(FluidContainer.BUCKET_CAPACITY, false);
            ItemEntity entity = new ItemEntity(level, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, new ItemStack((ItemLike)Blocks.f_50080_));
            entity.m_32060_();
            level.m_7967_((Entity)entity);
            level.m_6263_(null, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, SoundEvents.f_12031_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_46796_(1501, pos, 0);
            IFluidContainerBlock iFluidContainerBlock = this;
            if (iFluidContainerBlock instanceof BlockEntity) {
                BlockEntity blockEntity = (BlockEntity)iFluidContainerBlock;
                Network.getPlay().sendToTrackingBlockEntity(() -> blockEntity, (IMessage)new MessageWaterTapAnimation(pos));
            }
        }
        return InteractionResult.SUCCESS;
    }

    default public InteractionResult interactWithBottle(Player player, InteractionHand hand, BlockPos pos) {
        Potion potion;
        FluidContainer container = this.getFluidContainer();
        if (container == null) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_150930_(Items.f_42590_)) {
            if (container.getStoredAmount() >= FluidContainer.BOTTLE_CAPACITY && container.getStoredFluid().m_6212_((Fluid)Fluids.f_76193_)) {
                Level level = player.m_9236_();
                if (!level.m_5776_()) {
                    container.pull(FluidContainer.BOTTLE_CAPACITY, false);
                    Item bottle = heldItem.m_41720_();
                    player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)heldItem, (Player)player, (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_)));
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)bottle));
                    level.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_142346_(null, GameEvent.f_157816_, pos);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (heldItem.m_150930_(Items.f_42589_) && (potion = PotionUtils.m_43579_((ItemStack)heldItem)) == Potions.f_43599_ && (container.isEmpty() || container.getStoredAmount() < container.getCapacity() && container.getStoredFluid().m_6212_((Fluid)Fluids.f_76193_))) {
            Level level = player.m_9236_();
            if (!level.m_5776_()) {
                container.push((Fluid)Fluids.f_76193_, FluidContainer.BOTTLE_CAPACITY, false);
                Item potionItem = heldItem.m_41720_();
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)heldItem, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                player.m_36246_(Stats.f_12982_.m_12902_((Object)potionItem));
                level.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_(null, GameEvent.f_157769_, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    default public InteractionResult performPlatformInteraction(Player player, InteractionHand hand, BlockPos pos, Direction face) {
        return Services.FLUID.performInteractionWithBlock(player, hand, player.m_9236_(), pos, face);
    }
}

