/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.blockentity.CuttingBoardBlockEntity;
import com.mrcrayfish.furniture.refurbished.client.gui.overlay.IHudOverlay;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.crafting.CuttingBoardCombiningRecipe;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class CuttingBoardHelperOverlay
implements IHudOverlay {
    private static final int COLUMNS = 7;
    private static final int TITLE_HEIGHT = 13;

    @Override
    public void draw(PoseStack poseStack, float partialTick) {
        if (!((Boolean)Config.CLIENT.showCuttingBoardHelper.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91077_ == null || mc.f_91074_ == null) {
            return;
        }
        HitResult hitResult = mc.f_91077_;
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult result = (BlockHitResult)hitResult;
        BlockEntity entity = mc.f_91073_.m_7702_(result.m_82425_());
        if (!(entity instanceof CuttingBoardBlockEntity)) {
            return;
        }
        CuttingBoardBlockEntity cuttingBoard = (CuttingBoardBlockEntity)entity;
        int placeIndex = cuttingBoard.getPlaceIndex();
        SimpleContainer container = new SimpleContainer(placeIndex);
        IntStream.range(0, placeIndex).forEach(arg_0 -> CuttingBoardHelperOverlay.lambda$draw$0((Container)container, cuttingBoard, arg_0));
        List recipes = mc.f_91073_.m_7465_().m_44013_((RecipeType)ModRecipeTypes.CUTTING_BOARD_COMBINING.get());
        Stream<Item> combinable = recipes.stream().filter(arg_0 -> CuttingBoardHelperOverlay.lambda$draw$1((Container)container, mc, placeIndex, arg_0)).flatMap(recipe -> Stream.of(((Ingredient)recipe.m_7527_().get(placeIndex)).m_43908_())).map(ItemStack::m_41720_);
        Stream<Item> sliceable = mc.f_91073_.m_7465_().m_44013_((RecipeType)ModRecipeTypes.CUTTING_BOARD_SLICING.get()).stream().flatMap(recipe -> Stream.of(((Ingredient)recipe.m_7527_().get(0)).m_43908_())).map(ItemStack::m_41720_);
        Stream<Item> items = placeIndex == 0 ? Stream.concat(combinable, sliceable) : combinable;
        List<Item> placeable = items.distinct().sorted(Comparator.comparing(Item::m_41393_)).toList();
        boolean drawPlaceableElement = !placeable.isEmpty();
        boolean drawSliceableElement = this.canSlice(cuttingBoard);
        int areaWidth = 134;
        int areaHeight = this.getAreaHeight(placeable, drawPlaceableElement, drawSliceableElement);
        int areaStart = 5;
        int guiHeight = mc.m_91268_().m_85446_();
        int areaTop = (guiHeight - areaHeight) / 2;
        if (drawPlaceableElement) {
            int elementHeight = this.getPlaceableHeight(placeable);
            ScreenHelper.fillRounded(poseStack, areaStart, areaTop, areaWidth, elementHeight, -1728053248);
            ScreenHelper.fillRounded(poseStack, areaStart, areaTop, areaWidth, 13, -1728053248);
            Screen.m_93215_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (Component)Components.GUI_PLACEABLE, (int)(areaStart + areaWidth / 2), (int)(areaTop + 2), (int)-1);
            for (int i = 0; i < placeable.size(); ++i) {
                int x = areaStart + i % 7 * 18 + 1 + 4;
                int y = areaTop + i / 7 * 18 + 1 + 4 + 13;
                ScreenHelper.drawItem(new ItemStack((ItemLike)placeable.get(i)), x, y);
            }
        }
        if (drawSliceableElement) {
            Component sliceableLabel = Components.GUI_SLICEABLE;
            int elementHeight = 18;
            int contentWidth = 18 + Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)sliceableLabel);
            int contentTop = areaTop + areaHeight - elementHeight;
            int labelStart = areaStart + (areaWidth - contentWidth) / 2;
            ScreenHelper.fillRounded(poseStack, areaStart, contentTop, areaWidth, elementHeight, -1724404169);
            ScreenHelper.drawItem(new ItemStack((ItemLike)ModItems.KNIFE.get()), labelStart, contentTop + 1);
            Screen.m_93243_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (Component)sliceableLabel, (int)(labelStart + 18), (int)(contentTop + 5), (int)-1);
        }
    }

    private int getAreaHeight(List<Item> placeable, boolean combining, boolean slicing) {
        int height = 0;
        if (combining) {
            height += this.getPlaceableHeight(placeable);
        }
        if (slicing) {
            height += 18;
        }
        if (combining && slicing) {
            height += 5;
        }
        return height;
    }

    private int getPlaceableHeight(List<Item> placeable) {
        return (placeable.size() / 7 + 1) * 18 + 1 + 8 + 13;
    }

    private boolean canSlice(CuttingBoardBlockEntity entity) {
        ItemStack placedItem = entity.m_8020_(0);
        if (entity.getHeadIndex() == 0 && !placedItem.m_41619_()) {
            Level level = Objects.requireNonNull(entity.m_58904_());
            Optional optional = level.m_7465_().m_44015_((RecipeType)ModRecipeTypes.CUTTING_BOARD_SLICING.get(), (Container)new SimpleContainer(new ItemStack[]{placedItem}), level);
            return optional.isPresent();
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$draw$1(Container container, Minecraft mc, int placeIndex, CuttingBoardCombiningRecipe recipe) {
        return recipe.m_5818_(container, (Level)mc.f_91073_) && placeIndex < recipe.m_7527_().size();
    }

    private static /* synthetic */ void lambda$draw$0(Container container, CuttingBoardBlockEntity cuttingBoard, int index) {
        container.m_6836_(index, cuttingBoard.m_8020_(index));
    }
}

