/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.client.ClientComputer;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.ElectricityContainerScreen;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.IWidgetGroup;
import com.mrcrayfish.furniture.refurbished.computer.client.Desktop;
import com.mrcrayfish.furniture.refurbished.computer.client.DisplayableProgram;
import com.mrcrayfish.furniture.refurbished.computer.client.Window;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ProgramShortcutButton;
import com.mrcrayfish.furniture.refurbished.inventory.ComputerMenu;
import com.mrcrayfish.furniture.refurbished.mixin.client.ScreenAccessor;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class ComputerScreen
extends ElectricityContainerScreen<ComputerMenu> {
    public static final ResourceLocation TEXTURE = Utils.resource("textures/gui/container/computer.png");
    private static final int DISPLAY_LEFT = 15;
    private static final int DISPLAY_TOP = 15;
    public static final int DISPLAY_WIDTH = 226;
    public static final int DISPLAY_HEIGHT = 120;
    private static final int LOADING_TIME = 20;
    private static final int LOADING_BAR_WIDTH = 100;
    private final Desktop desktop = new Desktop(this);
    @Nullable
    private Window window;
    private int loading = 20;

    public ComputerScreen(ComputerMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.desktop.getShortcuts().forEach(x$0 -> {
            ProgramShortcutButton cfr_ignored_0 = (ProgramShortcutButton)this.m_7787_((GuiEventListener)x$0);
        });
        this.f_97726_ = 256;
        this.f_97727_ = 150;
        this.getComputer().setScreen(this);
    }

    public ClientComputer getComputer() {
        return (ClientComputer)((ComputerMenu)this.f_97732_).getComputer();
    }

    @Nullable
    public Window getOrCreateWindow() {
        DisplayableProgram<?> displayable = this.getComputer().getDisplayable();
        if (this.window == null && displayable != null) {
            this.window = new Window(displayable, this.getComputer());
            this.m_142416_((GuiEventListener)this.window.getCloseButton());
            this.updateWindow();
        } else if (this.window != null && displayable == null) {
            this.m_169411_((GuiEventListener)this.window.getCloseButton());
            this.window.onClose();
            this.window = null;
        }
        return this.window;
    }

    private void updateWindow() {
        if (this.window != null) {
            this.window.update(this.f_97735_ + 15, this.f_97736_ + 15, 226, 120);
        }
    }

    protected void m_232761_() {
        this.m_7856_();
        this.m_7522_(null);
        this.updateWindow();
        this.desktop.update(this.f_97735_ + 15, this.f_97736_ + 15, 226, 120);
    }

    public void m_6574_(Minecraft minecraft, int $$1, int $$2) {
        super.m_6574_(minecraft, $$1, $$2);
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        this.m_7333_(poseStack);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int displayLeft = this.f_97735_ + 15;
        int displayTop = this.f_97736_ + 15;
        int displayEnd = displayLeft + 226;
        int displayBottom = displayTop + 120;
        if (this.loading > 0) {
            float time = (20.0f - ((float)this.loading - this.f_96541_.m_91296_())) / 20.0f;
            int loadingBarStart = displayLeft + 63;
            int loadingBarWidth = (int)(100.0f * time);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(loadingBarStart - 1), (int)(displayBottom - 31), (int)(loadingBarStart + 100 + 1), (int)(displayBottom - 23), (int)-12107714);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)loadingBarStart, (int)(displayBottom - 30), (int)(loadingBarStart + loadingBarWidth), (int)(displayBottom - 24), (int)-1);
            GuiComponent.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)Components.GUI_BOOTING, (int)(displayLeft + 113), (int)(displayBottom - 42), (int)-1);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            GuiComponent.m_93160_((PoseStack)poseStack, (int)(displayLeft + 97), (int)(displayTop + 23), (int)32, (int)36, (float)0.0f, (float)this.f_97727_, (int)16, (int)18, (int)256, (int)256);
            return;
        }
        GuiComponent.m_239260_((int)displayLeft, (int)displayTop, (int)displayEnd, (int)displayBottom);
        this.desktop.render(poseStack, mouseX, mouseY, partialTick);
        Window window = this.getOrCreateWindow();
        if (window != null) {
            window.render(poseStack, this.f_96547_, mouseX, mouseY, this.f_96541_.m_91296_());
        }
        GuiComponent.m_240060_();
    }

    protected void m_181908_() {
        if (this.loading > 0) {
            --this.loading;
            return;
        }
        if (this.window != null) {
            this.window.tick();
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.loading > 0) {
            return false;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.m_7222_() != null && this.m_7282_() && button == 0 && this.m_7222_().m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (this.window != null && this.window.getDisplayable().blocksNavigation() && (key == 265 || key == 264 || key == 263 || key == 262)) {
            return true;
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    public void addWidgets(IWidgetGroup group) {
        ScreenAccessor accessor = (ScreenAccessor)((Object)this);
        group.getWidgets().forEach(listener -> {
            accessor.getChildren().add((GuiEventListener)listener);
            if (listener instanceof NarratableEntry) {
                NarratableEntry entry = (NarratableEntry)listener;
                accessor.getNarratables().add(entry);
            }
        });
    }

    public void removeWidgets(IWidgetGroup group) {
        group.getWidgets().forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
    }

    public List<? extends GuiEventListener> m_6702_() {
        return super.m_6702_();
    }
}

