/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.IconButton;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ComputerButton;
import com.mrcrayfish.furniture.refurbished.image.ImagePresets;
import com.mrcrayfish.furniture.refurbished.image.PaletteImage;
import com.mrcrayfish.furniture.refurbished.inventory.DoorMatMenu;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageUpdatePainting;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayDeque;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class DoorMatScreen
extends AbstractContainerScreen<DoorMatMenu> {
    private static final ResourceLocation TEXTURE = Utils.resource("textures/gui/container/door_mat.png");
    private static final PaletteImage[] PRESETS = new PaletteImage[]{ImagePresets.BLANK, ImagePresets.HEART, ImagePresets.MUSHROOM, ImagePresets.FORWARD_ARROW, ImagePresets.WARNING, ImagePresets.HOUSE, ImagePresets.CRISSCROSS, ImagePresets.STRIPES, ImagePresets.WAVES_PATTERN, ImagePresets.GEM_PATTERN, ImagePresets.ABSTRACT_PATTERN, ImagePresets.SWIRL_PATTERN};
    private PaletteImage image;
    private Tool currentTool = Tool.PENCIL;
    @Nullable
    private Tool activeTool;
    private int selectedColourIndex = 1;
    private int currentPreset = 0;

    public DoorMatScreen(DoorMatMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 134;
        this.f_97727_ = 103;
        this.image = PRESETS[0].copy();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ + this.f_97726_ / 2 - 45 - 20, this.f_97736_ + 14, 0, 20, btn -> {
            this.image = PRESETS[Math.floorMod(--this.currentPreset, PRESETS.length)].copy();
        }, (btn, poseStack, mouseX, mouseY) -> this.m_96602_(poseStack, (Component)Utils.translation("gui", "previous_preset", new Object[0]), mouseX, mouseY)));
        this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ + this.f_97726_ / 2 + 45, this.f_97736_ + 14, 10, 20, btn -> {
            this.image = PRESETS[Math.floorMod(++this.currentPreset, PRESETS.length)].copy();
        }, (btn, poseStack, mouseX, mouseY) -> this.m_96602_(poseStack, (Component)Utils.translation("gui", "next_preset", new Object[0]), mouseX, mouseY)));
        for (int i = 1; i < PaletteImage.COLOURS.length; ++i) {
            this.m_142416_((GuiEventListener)new ColourButton(this.f_97735_ + (i - 1) * 8 + 7, this.f_97736_ + 65, i));
        }
        this.m_142416_((GuiEventListener)new ToolButton(this.f_97735_ + 6, this.f_97736_ + 77, 30, 10, Tool.PENCIL));
        this.m_142416_((GuiEventListener)new ToolButton(this.f_97735_ + 29, this.f_97736_ + 77, 40, 10, Tool.ERASER));
        this.m_142416_((GuiEventListener)new ToolButton(this.f_97735_ + 52, this.f_97736_ + 77, 50, 10, Tool.FILL));
        this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 75, this.f_97736_ + 77, 53, 20, (Component)Utils.translation("gui", "save", new Object[0]), var1 -> Network.getPlay().sendToServer((IMessage)new MessageUpdatePainting(this.image))));
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
    }

    protected void m_7286_(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        this.m_7333_(poseStack);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        for (int y = 0; y < this.image.getHeight(); ++y) {
            for (int x = 0; x < this.image.getWidth(); ++x) {
                int pixelStart = this.f_97735_ + 39 + x * 4;
                int pixelEnd = pixelStart + 4;
                int pixelTop = this.f_97736_ + 4 + y * 4;
                int pixelBottom = pixelTop + 4;
                GuiComponent.m_93172_((PoseStack)poseStack, (int)pixelStart, (int)pixelTop, (int)pixelEnd, (int)pixelBottom, (int)PaletteImage.COLOURS[this.image.get(x, y)]);
            }
        }
        if (this.activeTool != null) {
            this.activateTool(mouseX, mouseY, true);
        }
    }

    private boolean activateTool(double mouseX, double mouseY, boolean continuous) {
        int start = this.f_97735_ + 39;
        int end = start + 56;
        int top = this.f_97736_ + 4;
        int bottom = top + 40;
        if (mouseX >= (double)start && mouseX < (double)end && mouseY >= (double)top && mouseY < (double)bottom) {
            int x = (int)((mouseX - (double)start) / 4.0);
            int y = (int)((mouseY - (double)top) / 4.0);
            if (this.currentTool.getFunction().apply(this.image, x, y, this.selectedColourIndex) && !continuous) {
                this.activeTool = this.currentTool;
            }
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.activateTool(mouseX, mouseY, false)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.activeTool != null && button == 0) {
            this.activeTool = null;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    private static enum Tool {
        PENCIL((image, x, y, colourIndex) -> {
            image.set(x, y, colourIndex);
            return true;
        }),
        ERASER((image, x, y, colourIndex) -> {
            image.set(x, y, 0);
            return true;
        }),
        FILL((image, x, y, colourIndex) -> {
            int fillColourIndex = image.get(x, y);
            if (fillColourIndex == colourIndex) {
                return false;
            }
            ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
            queue.offer(Pair.of((Object)x, (Object)y));
            while (!queue.isEmpty()) {
                Pair pair = (Pair)queue.poll();
                int pixelX = (Integer)pair.left();
                int pixelY = (Integer)pair.right();
                image.set(pixelX, pixelY, colourIndex);
                if (pixelY - 1 >= 0 && image.get(pixelX, pixelY - 1) == fillColourIndex) {
                    queue.offer(Pair.of((Object)pixelX, (Object)(pixelY - 1)));
                }
                if (pixelY + 1 < image.getHeight() && image.get(pixelX, pixelY + 1) == fillColourIndex) {
                    queue.offer(Pair.of((Object)pixelX, (Object)(pixelY + 1)));
                }
                if (pixelX - 1 >= 0 && image.get(pixelX - 1, pixelY) == fillColourIndex) {
                    queue.offer(Pair.of((Object)(pixelX - 1), (Object)pixelY));
                }
                if (pixelX + 1 >= image.getWidth() || image.get(pixelX + 1, pixelY) != fillColourIndex) continue;
                queue.offer(Pair.of((Object)(pixelX + 1), (Object)pixelY));
            }
            return false;
        });

        private final ToolFunction function;

        private Tool(ToolFunction function) {
            this.function = function;
        }

        public ToolFunction getFunction() {
            return this.function;
        }
    }

    private class ColourButton
    extends ComputerButton {
        private final int colourIndex;

        protected ColourButton(int x, int y, int colourIndex) {
            super(8, 8, CommonComponents.f_237098_, btn -> {
                com$mrcrayfish$furniture$refurbished$client$gui$screen$DoorMatScreen$this.selectedColourIndex = colourIndex;
            });
            this.f_93620_ = x;
            this.f_93621_ = y;
            this.colourIndex = colourIndex;
            this.setBackgroundColour(PaletteImage.COLOURS[colourIndex]);
            this.setBackgroundHighlightColour(PaletteImage.COLOURS[colourIndex]);
            this.setOutlineColour(PaletteImage.COLOURS[colourIndex]);
            this.setOutlineHighlightColour(-1);
        }

        public boolean m_198029_() {
            return super.m_198029_() || DoorMatScreen.this.selectedColourIndex == this.colourIndex;
        }

        public int getColourIndex() {
            return this.colourIndex;
        }
    }

    private class ToolButton
    extends IconButton {
        private final Tool tool;

        public ToolButton(int x, int y, int u, int v, Tool tool) {
            super(x, y, u, v, btn -> {
                com$mrcrayfish$furniture$refurbished$client$gui$screen$DoorMatScreen$this.currentTool = tool;
            });
            this.tool = tool;
        }

        public boolean m_198029_() {
            return super.m_198029_() || DoorMatScreen.this.currentTool == this.tool;
        }
    }

    @FunctionalInterface
    private static interface ToolFunction {
        public boolean apply(PaletteImage var1, int var2, int var3, int var4);
    }
}

